/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.xui;

import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import net.xoetrope.data.XDataSource;
import net.xoetrope.debug.DebugLogger;
import net.xoetrope.debug.XLogWriter;
import net.xoetrope.registry.ComponentCustomizer;
import net.xoetrope.xml.XmlElement;
import net.xoetrope.xml.XmlSource;
import net.xoetrope.xui.PageSupport;
import net.xoetrope.xui.WidgetAdapter;
import net.xoetrope.xui.XComponentConstructor;
import net.xoetrope.xui.XComponentFactory;
import net.xoetrope.xui.XContentHolder;
import net.xoetrope.xui.XLifeCycleListener;
import net.xoetrope.xui.XPageDisplay;
import net.xoetrope.xui.XPageLoader;
import net.xoetrope.xui.XPageManager;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.XProjectManager;
import net.xoetrope.xui.XStartupObject;
import net.xoetrope.xui.helper.ReflectionHelper;

public class XApplicationContext
implements XPageDisplay,
WindowListener {
    protected XPageManager pageMgr;
    protected boolean bUseWindow;
    protected XDataSource modelDataSource;
    protected Class defaultSourceClass = XDataSource.class;
    protected XStartupObject startupObject;
    protected int clientWidth = 800;
    protected int clientHeight = 600;
    protected XProject currentProject;
    protected String defaultTargetClass;
    protected WidgetAdapter adapter;
    protected String widgetSet;
    private static Object shutdownHook;

    public XApplicationContext(XStartupObject xStartupObject, String[] stringArray) {
        this(xStartupObject, "net.xoetrope.xui.XTarget", stringArray);
    }

    public XApplicationContext(XStartupObject xStartupObject, String string, String[] stringArray) {
        this.startupObject = xStartupObject;
        this.currentProject = XProjectManager.getCurrentProject(this.startupObject);
        this.currentProject.setObject("AppContext", this);
        this.currentProject.setObject("StartupArgs", stringArray);
        this.defaultTargetClass = string;
        this.adapter = WidgetAdapter.getInstance();
        this.setup(stringArray, true);
    }

    protected int loadSecondaryProject(XmlElement xmlElement) {
        XProject xProject = this.currentProject;
        try {
            String[] stringArray = new String[]{};
            XProject xProject2 = this.currentProject = new XProject();
            URL uRL = new URL(this.currentProject.findResource("startup.properties"), xmlElement.getAttribute("path") + "/");
            URL[] uRLArray = new URL[]{uRL, new URL(uRL, "resources/"), new URL(uRL, "pages/"), new URL(uRL, "build/classes/"), new URL(uRL, "classes/"), new URL(uRL, "lang/"), new URL(uRL, "src/")};
            ClassLoader classLoader = (ClassLoader)ReflectionHelper.constructViaReflection("net.xoetrope.optional.resources.XProjectClassLoader", new Object[]{this.currentProject, this.getClass().getClassLoader()});
            ReflectionHelper.setViaReflection("Urls", (Object)classLoader, (Object)uRLArray, URL[].class);
            XProjectManager.setCurrentProject(xProject2);
            this.setup(stringArray, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.currentProject = xProject;
        return 0;
    }

    protected void setup(String[] stringArray, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        String string;
        this.widgetSet = this.startupObject.getWidgetClassPackage();
        boolean bl2 = stringArray != null && stringArray.length > 1;
        String string2 = bl2 ? stringArray[1] : this.widgetSet;
        this.currentProject.setPackageName(string2);
        this.currentProject.setWidgetPackageName(string2);
        this.setResourceFile(bl2 ? stringArray[0] : "startup.properties");
        this.addSecondaryClassLoaders(string2);
        String string3 = this.currentProject.getStartupParam("Icon");
        if (string3 != null) {
            this.startupObject.setIcon(this.currentProject.getImage(string3));
        }
        if ((string = this.currentProject.getStartupParam("LAF")) != null && !string.equals("System")) {
            try {
                object3 = Class.forName(string.trim());
                object2 = new Class[]{};
                object = ((Class)object3).getDeclaredMethod("installLaf", (Class<?>)object2);
                ((Method)object).invoke(null, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl) {
            try {
                object3 = this.currentProject.getBufferedReader("projects.xml");
                if (object3 != null && (object2 = XmlSource.read((Reader)object3)) != null) {
                    object = object2.getChildren();
                    int n = ((Vector)object).size();
                    for (int i = 0; i < n; ++i) {
                        XmlElement xmlElement = (XmlElement)((Vector)object).elementAt(i);
                        this.loadSecondaryProject(xmlElement);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.currentProject.getStatus() == 6) {
            object3 = this.currentProject.getObject("MenuBar");
            this.startupObject.setApplicationMenuBar(object3);
        }
        this.initialise();
        this.currentProject.setStatus(3);
    }

    public void shutdown() {
        if (this.canClose()) {
            System.exit(0);
        }
    }

    protected void addSecondaryClassLoaders(String string) {
        XPageManager xPageManager = this.currentProject.getPageManager();
        String string2 = this.currentProject.getStartupParam("NumBuilderClasses");
        int n = 0;
        if (string2 != null) {
            n = Math.max(new Integer(string2), 0);
        }
        boolean bl = false;
        for (int i = 0; i <= n; ++i) {
            String string3 = i == 0 ? this.currentProject.getStartupParam("BuilderClass") : this.currentProject.getStartupParam("BuilderClass" + new Integer(i - 1).toString());
            XPageLoader xPageLoader = null;
            if (string3 != null) {
                try {
                    xPageLoader = (XPageLoader)ReflectionHelper.constructViaReflection(null, string3, XProject.class, this.currentProject);
                }
                catch (Exception exception) {
                    DebugLogger.logError("Unable to load builder class: " + exception.getMessage());
                }
            }
            if (xPageLoader == null && !bl) {
                try {
                    xPageLoader = (XPageLoader)ReflectionHelper.constructViaReflection(null, "net.xoetrope.builder.XuiBuilder", XProject.class, this.currentProject);
                    bl = true;
                    Vector vector = this.currentProject.getCustomerClassLoaders();
                    if (vector != null && vector.size() > 0) {
                        xPageLoader.setClassLoader((ClassLoader)vector.elementAt(0));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (xPageLoader == null) continue;
            xPageLoader.setPackageName(string);
            if (xPageLoader == null) continue;
            xPageManager.addSecondaryLoader(xPageLoader);
        }
    }

    public void setDefaultDataSource(String string) {
        try {
            this.defaultSourceClass = Class.forName(string.trim());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    protected void setResourceFile(String string) {
        this.currentProject.initialise(string);
        try {
            String string2 = this.currentProject.getStartupParam("UseWindow");
            this.bUseWindow = string2.compareTo("true") == 0;
            String string3 = this.currentProject.getStartupParam("ClientWidth");
            if (string3 != null) {
                this.clientWidth = Integer.parseInt(string3);
            }
            if ((string3 = this.currentProject.getStartupParam("ClientHeight")) != null) {
                this.clientHeight = Integer.parseInt(string3);
            }
            if ((string3 = this.currentProject.getStartupParam("XDataSourceClass")) != null) {
                try {
                    this.defaultSourceClass = Class.forName(string3.trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            int n = 0;
            String string4 = null;
            do {
                if ((string4 = this.currentProject.getStartupParam("StartupObject" + n++)) == null) continue;
                try {
                    Object object;
                    int n2 = string4.indexOf(59);
                    String string5 = string4.substring(0, n2);
                    string4 = string4.substring(n2 + 1);
                    n2 = string4.indexOf(59);
                    if (n2 > 0) {
                        string4 = string4.substring(0, n2);
                        object = ReflectionHelper.constructViaReflection(string4, XProject.class, this.currentProject);
                        this.currentProject.setObject(string5, object);
                        continue;
                    }
                    object = Class.forName(string4.trim());
                    this.currentProject.setObject(string5, ((Class)object).newInstance());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (string4 != null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void init() {
        String string = this.startupObject.getWidgetClassPackage();
        this.currentProject.setPackageName(string);
        this.currentProject.setWidgetPackageName(string);
        this.setResourceFile(this.startupObject.getParameter("StartFile") != null ? this.startupObject.getParameter("StartFile") : "startup.properties");
        this.addSecondaryClassLoaders(string);
        this.initialise();
    }

    protected void initialise() {
        Object object;
        boolean bl;
        boolean bl2 = bl = this.currentProject.getStatus() > 2;
        if (!bl) {
            object = this.currentProject.getStartupParam("LogWriter");
            if (object != null) {
                try {
                    Object obj = Class.forName(((String)object).trim()).newInstance();
                    DebugLogger.setOutputWriter((XLogWriter)obj);
                    Object obj2 = Class.forName(((String)object).trim()).newInstance();
                    ((XLogWriter)obj2).setStream(true);
                    DebugLogger.setErrorWriter((XLogWriter)obj2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.register();
        }
        try {
            object = this.startupObject.getDocumentBase();
            if (object != null) {
                this.currentProject.setDocumentBase((URL)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.startupObject.setupWindow(this, this.currentProject, this.clientWidth, this.clientHeight);
        if (!bl) {
            this.addShutdownHook();
        }
        this.setContent(bl);
        this.startupObject.refresh();
    }

    protected void addShutdownHook() {
        try {
            if (shutdownHook == null) {
                shutdownHook = ReflectionHelper.constructViaReflection(null, "net.xoetrope.xui.build.conditional.ShutdownHook", XProject.class, this.currentProject);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addLifeCycleListener() {
        try {
            String string = this.currentProject.getStartupParam("LifeCycleListener");
            if (string != null && string.length() > 0) {
                XLifeCycleListener xLifeCycleListener = (XLifeCycleListener)Class.forName(string.trim()).newInstance();
                Class[] classArray = new Class[1];
                Object[] objectArray = new Object[1];
                classArray[0] = XLifeCycleListener.class;
                objectArray[0] = xLifeCycleListener;
                Method method = shutdownHook.getClass().getMethod("addLifeCycleListener", classArray);
                method.invoke(shutdownHook, objectArray);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.getCause().printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean canClose() {
        try {
            Class[] classArray = new Class[1];
            Object[] objectArray = new Object[1];
            classArray[0] = XProject.class;
            objectArray[0] = this.currentProject;
            Method method = shutdownHook.getClass().getMethod("canClose", classArray);
            Object object = method.invoke(shutdownHook, objectArray);
            if (object != null) {
                return (Boolean)object;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.getCause().printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    protected void register() {
        Object object;
        String string;
        int n = 0;
        String string2 = this.currentProject.getStartupParam("NumComponentFactories");
        if (string2 != null) {
            n = new Integer(string2);
        }
        for (int i = 0; i < n; ++i) {
            string = this.currentProject.getStartupParam("ComponentFactory" + i);
            try {
                if (string == null) continue;
                object = (XComponentConstructor)ReflectionHelper.constructViaReflection(null, string, XProject.class, this.currentProject);
                XComponentFactory.registerComponentFactory(string, (XComponentConstructor)object);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            String string3 = this.widgetSet.substring(this.widgetSet.lastIndexOf(46) + 1);
            if (!"awt".endsWith(string3)) {
                string = string3.substring(0, 1).toUpperCase() + string3.substring(1).toLowerCase() + "ComponentFactory";
                object = "net.xoetrope." + string3.toLowerCase() + "." + string;
                XComponentConstructor xComponentConstructor = (XComponentConstructor)ReflectionHelper.constructViaReflection(null, object, XProject.class, this.currentProject);
                XComponentFactory.registerComponentFactory(string, xComponentConstructor);
            }
        }
        catch (Error error) {
            // empty catch block
        }
    }

    protected void setContent(boolean bl) {
        if (!bl) {
            try {
                this.modelDataSource = (XDataSource)ReflectionHelper.constructViaReflection(null, this.defaultSourceClass, XProject.class, this.currentProject);
                this.currentProject.setObject("ModelDataSource", this.modelDataSource);
            }
            catch (Exception exception) {
                return;
            }
            try {
                String string = this.currentProject.getStartupParam("ModelData");
                if (string != null) {
                    try {
                        this.modelDataSource.read(this.currentProject.getBufferedReader(string, null));
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.addLifeCycleListener();
        }
        this.startupObject.setAppTitle(this.currentProject.getStartupParam("Title"));
        this.setHome();
    }

    public void setHome() {
        try {
            String string = this.currentProject.getStartupParam("StartPackage");
            String string2 = this.currentProject.getStartupParam("StartClass");
            if (string == null && (string2 == null || string2.length() == 0)) {
                string2 = "home";
            }
            if (string != null) {
                string = string + ".";
            }
            this.pageMgr = this.currentProject.getPageManager();
            this.pageMgr.setPackageName(string);
            this.pageMgr.setPageDisplay(this);
            if (string2 != null && !string2.equals("NONE")) {
                this.pageMgr.showPage(string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Object displayPage(PageSupport pageSupport) {
        return this.displayPage(pageSupport, null);
    }

    public Object displayPage(PageSupport pageSupport, String string) {
        return this.displayPage(pageSupport, string, null);
    }

    public Object displayPage(PageSupport pageSupport, String string, Object object) {
        PageSupport pageSupport2 = pageSupport;
        this.startupObject.restoreViews();
        XContentHolder xContentHolder = (XContentHolder)this.findTarget(string);
        if (xContentHolder == null) {
            return null;
        }
        this.adapter.setSize(pageSupport2, this.clientWidth - (this.bUseWindow ? 0 : 8), this.clientHeight - (this.bUseWindow ? 0 : 34));
        this.adapter.setVisible(pageSupport2, true);
        PageSupport pageSupport3 = null;
        try {
            pageSupport3 = (PageSupport)xContentHolder.getChildComponent(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (pageSupport2 != pageSupport3) {
            xContentHolder.setNextAttributes(object);
            xContentHolder.add(pageSupport2, "Center");
            pageSupport2.pageAdded();
            if (pageSupport3 != null) {
                pageSupport3.saveBoundComponentValues();
                xContentHolder.remove(pageSupport3);
                pageSupport2.setStatus(5);
                try {
                    pageSupport3.pageDeactivated();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                pageSupport2.updateBindings();
                pageSupport2.updateBoundComponentValues();
            }
            catch (Exception exception) {
                // empty catch block
            }
            xContentHolder.doLayout();
            this.adapter.doLayout(pageSupport2);
        } else {
            pageSupport2.updateBindings();
            pageSupport2.updateBoundComponentValues();
        }
        xContentHolder.doLayout();
        this.adapter.setVisible(pageSupport2, true);
        this.adapter.repaint(pageSupport2);
        this.adapter.doLayout(pageSupport2);
        ComponentCustomizer componentCustomizer = (ComponentCustomizer)this.currentProject.getObject("ComponentCustomizer");
        componentCustomizer.activateCustomize();
        pageSupport2.setStatus(3);
        try {
            pageSupport2.pageActivated();
        }
        catch (Exception exception) {
            // empty catch block
        }
        pageSupport2.setStatus(4);
        return pageSupport2;
    }

    public Object displayDecoration(PageSupport pageSupport, String string) {
        return this.startupObject.displayDecoration(pageSupport, string);
    }

    public void doLayout() {
        this.adapter.doLayout(this.startupObject.getContentPaneEx());
    }

    public void hidePage(PageSupport pageSupport) {
        PageSupport pageSupport2 = null;
        Object object = this.startupObject.getContentPaneEx();
        try {
            pageSupport2 = (PageSupport)this.adapter.getComponent(object, 0);
            if (pageSupport2 != null && pageSupport != pageSupport2) {
                this.adapter.remove(object, pageSupport2);
                pageSupport.setStatus(5);
                pageSupport.pageDeactivated();
                this.adapter.doLayout(object);
                this.startupObject.validate();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object findTarget(String string) {
        Object object = this.startupObject.getContentPaneEx();
        if (string == null) {
            string = "content";
        }
        int n = this.adapter.getComponentCount(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = this.adapter.getComponent(object, i);
            String string2 = this.adapter.getName(object2);
            if (string2 == null || !string2.equals(string)) continue;
            return object2;
        }
        return null;
    }

    public Object getTarget(int n) {
        Object object = this.startupObject.getContentPaneEx();
        return this.adapter.getComponent(object, n);
    }

    public int getNumTargets() {
        Object object = this.startupObject.getContentPaneEx();
        return this.adapter.getComponentCount(object);
    }

    public void setupFrameset(Hashtable hashtable) {
        this.startupObject.setupFrameset(hashtable);
    }

    public XContentHolder addTarget(String string, Object object, int n, int n2, Hashtable hashtable) {
        Object object2;
        Object object3 = this.startupObject.getContentPaneEx();
        XContentHolder xContentHolder = null;
        try {
            object2 = Class.forName(this.defaultTargetClass.trim());
            xContentHolder = (XContentHolder)((Class)object2).newInstance();
        }
        catch (Exception exception) {
            Throwable throwable = exception.getCause();
            if (throwable != null) {
                throwable.printStackTrace();
            }
            DebugLogger.logWarning("Could not load the frame/target from the classpath");
        }
        if (xContentHolder == null) {
            try {
                if (this.adapter.requiresParent()) {
                    object2 = new Object[]{object3};
                    xContentHolder = (XContentHolder)ReflectionHelper.constructViaReflection(this.defaultTargetClass, (Object[])object2);
                } else {
                    object2 = this.startupObject.getClass().getClassLoader().loadClass(this.defaultTargetClass);
                    xContentHolder = (XContentHolder)((Class)object2).newInstance();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (xContentHolder != null) {
            int n3 = 0;
            if (((String)object).equalsIgnoreCase("CENTER") && !this.bUseWindow) {
                n3 = 34;
            }
            xContentHolder.setup(string, n - (this.bUseWindow ? 0 : 8), n2 - n3, hashtable);
            this.adapter.add(object3, xContentHolder, object);
            return xContentHolder;
        }
        return null;
    }

    public void removeAllTargets() {
        this.adapter.removeAll(this.startupObject.getContentPaneEx());
    }

    public void setDefaultTargetClass(String string) {
        this.defaultTargetClass = string;
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.canClose()) {
            this.currentProject.setStatus(4);
            boolean bl = !"false".equals(this.currentProject.getStartupParam("ExitOnClose"));
            this.currentProject.setStatus(5);
            if (bl) {
                System.exit(0);
            } else {
                windowEvent.getWindow().dispose();
            }
        }
    }

    public int getClientWidth() {
        return this.clientWidth;
    }

    public int getClientHeight() {
        return this.clientHeight;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

