/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.xml.jaxp;

import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.xoetrope.xml.XmlElement;
import net.xoetrope.xml.XmlParser;
import net.xoetrope.xml.jaxp.JaxpXmlElement;
import net.xoetrope.xui.XProject;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JaxpXmlParser
implements XmlParser {
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private ErrorHandler errorHandler;
    private EntityResolver entityResolver;

    protected JaxpXmlParser() {
    }

    public static JaxpXmlParser getInstance(XProject xProject) {
        JaxpXmlParser jaxpXmlParser = (JaxpXmlParser)xProject.getObject("JaxpXmlParser");
        if (jaxpXmlParser == null) {
            jaxpXmlParser = new JaxpXmlParser();
            xProject.setObject("JaxpXmlParser", jaxpXmlParser);
        }
        return jaxpXmlParser;
    }

    public XmlElement createXmlElement(String string) {
        throw new UnsupportedOperationException();
    }

    public XmlElement parse(Reader reader) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        Document document = null;
        try {
            boolean bl = documentBuilder.isValidating();
            if (this.entityResolver != null) {
                documentBuilder.setEntityResolver(this.entityResolver);
            }
            document = documentBuilder.parse(new InputSource(reader));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        return new JaxpXmlElement(document.getDocumentElement());
    }

    public XmlElement parse(Reader reader, String string) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(true);
        try {
            documentBuilderFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (string != null) {
            documentBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, string);
        }
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (this.errorHandler != null) {
                documentBuilder.setErrorHandler(this.errorHandler);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        Document document = null;
        try {
            document = documentBuilder.parse(new InputSource(reader));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        return new JaxpXmlElement(document.getDocumentElement());
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }
}

