/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.xml.jaxp;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import net.xoetrope.xml.XmlElement;
import net.xoetrope.xui.helper.ReflectionHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JaxpXmlElement
implements XmlElement {
    protected Element element;
    protected Vector children;

    public JaxpXmlElement() {
    }

    public JaxpXmlElement(Element element) {
        this.element = element;
    }

    public JaxpXmlElement(String string) {
        throw new UnsupportedOperationException("Method XercesXmlElement(String) not yet implemented.");
    }

    public XmlElement elementAt(int n) {
        Object e;
        if (this.children == null) {
            this.getChildren();
        }
        if ((e = this.children.elementAt(n)) instanceof Element) {
            return new JaxpXmlElement((Element)e);
        }
        if (e instanceof JaxpXmlElement) {
            return (JaxpXmlElement)e;
        }
        return null;
    }

    public String getAttribute(String string) {
        if (!this.element.hasAttribute(string)) {
            return null;
        }
        return this.element.getAttribute(string);
    }

    public Vector getChildren() {
        return this.getChildren("*");
    }

    public Vector getChildren(String string) {
        this.children = new Vector();
        NodeList nodeList = this.element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if (string != null && string.charAt(0) != '*' && !string.equals(element.getNodeName())) continue;
            this.children.addElement(new JaxpXmlElement(element));
        }
        return this.children;
    }

    public String getName() {
        return this.element.getTagName();
    }

    public void setName(String string) {
        throw new UnsupportedOperationException("Method setName( String newName ) not yet implemented.");
    }

    public String getContent() {
        String string = this.element.getNodeValue();
        if (string == null) {
            try {
                string = (String)ReflectionHelper.getViaReflection("getTextContent", this.element);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return string;
    }

    public void setContent(String string) {
        try {
            ReflectionHelper.setViaReflection("setTextContent", (Object)this.element, (Object)string, String.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Enumeration enumerateAttributeNames() {
        Vector<String> vector = new Vector<String>();
        NamedNodeMap namedNodeMap = this.element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            vector.add(namedNodeMap.item(i).getNodeName());
        }
        return vector.elements();
    }

    public void setAttribute(String string, String string2) {
        this.element.setAttribute(string, string2);
    }

    public void addChild(XmlElement xmlElement) {
        if (xmlElement instanceof JaxpXmlElement) {
            this.element.appendChild((Element)xmlElement.getImplementation());
        }
    }

    public XmlElement createElement(String string) {
        Element element = this.element.getOwnerDocument().createElement(string);
        this.element.appendChild(element);
        return new JaxpXmlElement(element);
    }

    public XmlElement getFirstChildNamed(String string) {
        Element element = (Element)this.element.getElementsByTagName(string).item(0);
        return element == null ? null : new JaxpXmlElement(element);
    }

    public String getNamespace() {
        return this.element.getNamespaceURI();
    }

    public int getAttributeCount() {
        return this.element.getAttributes().getLength();
    }

    public Properties getAttributes() {
        NamedNodeMap namedNodeMap = this.element.getAttributes();
        int n = namedNodeMap.getLength();
        Properties properties = new Properties();
        for (int i = 0; i < n; ++i) {
            Node node = namedNodeMap.item(i);
            properties.setProperty(node.getNodeName(), node.getNodeValue());
        }
        return properties;
    }

    public String getAttributeNamespace(String string) {
        return this.element.getAttributeNode(string).getOwnerElement().getNamespaceURI();
    }

    public Object getImplementation() {
        return this.element;
    }

    public Element getElement() {
        return this.element;
    }

    public void remove(XmlElement xmlElement) {
        this.element.removeChild(((JaxpXmlElement)xmlElement).getElement());
    }

    public void removeAttribute(String string) {
        this.element.removeAttribute(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.outputTag(stringBuffer, this.element, false);
        this.outputAttribs(stringBuffer, this.element);
        stringBuffer.append(">");
        stringBuffer = this.iterateElements(this.element.getChildNodes(), stringBuffer);
        this.outputTag(stringBuffer, this.element, true);
        return stringBuffer.toString();
    }

    private StringBuffer iterateElements(NodeList nodeList, StringBuffer stringBuffer) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node;
            Node node2 = nodeList.item(i);
            if (node2 instanceof Element) {
                node = (Element)node2;
                this.outputTag(stringBuffer, (Element)node, false);
                this.outputAttribs(stringBuffer, (Element)node);
                stringBuffer.append(">");
                stringBuffer = this.iterateElements(node.getChildNodes(), stringBuffer);
                this.outputTag(stringBuffer, (Element)node, true);
                continue;
            }
            if (!(node2 instanceof Node)) continue;
            node = node2;
            stringBuffer.append(node.getNodeValue());
            stringBuffer = this.iterateElements(node.getChildNodes(), stringBuffer);
        }
        return stringBuffer;
    }

    private StringBuffer outputAttribs(StringBuffer stringBuffer, Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            stringBuffer.append(" ");
            stringBuffer.append(node.getNodeName());
            stringBuffer.append("=\"");
            stringBuffer.append(node.getNodeValue());
            stringBuffer.append("\"");
        }
        return stringBuffer;
    }

    private void outputTag(StringBuffer stringBuffer, Element element, boolean bl) {
        stringBuffer.append("<");
        if (bl) {
            stringBuffer.append("/");
        }
        stringBuffer.append(element.getTagName());
        if (bl) {
            stringBuffer.append(">");
        }
    }

    public Object clone() {
        Element element = this.clone(this.element);
        return new JaxpXmlElement(element);
    }

    private Element clone(Element element) {
        Element element2 = this.element.getOwnerDocument().createElement(element.getTagName());
        try {
            String string = (String)ReflectionHelper.getViaReflection("getTextContent", element);
            if (string != null) {
                string.trim();
                if (string.length() > 0) {
                    ReflectionHelper.setViaReflection("setTextContent", (Object)element2, (Object)string, String.class);
                }
            }
            NamedNodeMap namedNodeMap = this.element.getAttributes();
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                String string2 = namedNodeMap.item(i).getNodeName();
                element2.setAttribute(string2, element.getAttribute(string2));
            }
            NodeList nodeList = this.element.getChildNodes();
            int n2 = nodeList.getLength();
            for (int i = 0; i < n2; ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                Element element3 = (Element)node;
                element2.appendChild(element3);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return element2;
    }
}

