/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferInt;
import java.awt.image.Kernel;
import javax.swing.JComponent;
import javax.swing.Timer;

public class XGraphicsUtils {
    protected int shadowSize = 5;
    protected float shadowOpacity = 0.5f;
    protected Color shadowColor = new Color(0);

    public BufferedImage createShadow(BufferedImage bufferedImage, int n) {
        int n2 = bufferedImage.getWidth() + n * 2;
        int n3 = bufferedImage.getHeight() + n * 2;
        BufferedImage bufferedImage2 = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, n, n, null);
        graphics2D.dispose();
        this.applyShadow(bufferedImage2, n);
        return bufferedImage2;
    }

    public void applyShadow(BufferedImage bufferedImage, int n) {
        int n2;
        int n3;
        int n4;
        int n5 = bufferedImage.getWidth();
        int n6 = bufferedImage.getHeight();
        int n7 = n - 1 >> 1;
        int n8 = n - n7;
        int n9 = n7;
        int n10 = n5 - n8;
        int n11 = n7;
        int n12 = n6 - n8;
        int n13 = this.shadowColor.getRGB() & 0xFFFFFF;
        int[] nArray = new int[n];
        int n14 = 0;
        int[] nArray2 = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        int n15 = n8 * n5;
        float f = this.shadowOpacity / (float)n;
        int n16 = 0;
        int n17 = 0;
        while (n16 < n6) {
            n4 = 0;
            n14 = 0;
            n3 = 0;
            while (n3 < n) {
                nArray[n3] = n2 = nArray2[n17] >>> 24;
                n4 += n2;
                ++n3;
                ++n17;
            }
            n17 -= n8;
            n3 = n9;
            while (n3 < n10) {
                n2 = (int)((float)n4 * f);
                nArray2[n17] = n2 << 24 | n13;
                n4 -= nArray[n14];
                nArray[n14] = n2 = nArray2[n17 + n8] >>> 24;
                n4 += n2;
                if (++n14 >= n) {
                    n14 -= n;
                }
                ++n3;
                ++n17;
            }
            n17 = ++n16 * n5;
        }
        n16 = 0;
        n17 = 0;
        while (n16 < n5) {
            n4 = 0;
            n14 = 0;
            n3 = 0;
            while (n3 < n) {
                nArray[n3] = n2 = nArray2[n17] >>> 24;
                n4 += n2;
                ++n3;
                n17 += n5;
            }
            n17 -= n15;
            n3 = n11;
            while (n3 < n12) {
                n2 = (int)((float)n4 * f);
                nArray2[n17] = n2 << 24 | n13;
                n4 -= nArray[n14];
                nArray[n14] = n2 = nArray2[n17 + n15] >>> 24;
                n4 += n2;
                if (++n14 >= n) {
                    n14 -= n;
                }
                ++n3;
                n17 += n5;
            }
            n17 = ++n16;
        }
    }

    public BufferedImage createDropShadow(BufferedImage bufferedImage) {
        if (bufferedImage != null) {
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
            BufferedImage bufferedImage3 = this.createShadowMask(bufferedImage);
            this.getBlurOp(this.shadowSize).filter(bufferedImage3, bufferedImage2);
            return bufferedImage2;
        }
        return null;
    }

    public void applyBlur(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        if (n == 1) {
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.dispose();
            return;
        }
        int n13 = bufferedImage.getWidth();
        int n14 = bufferedImage.getHeight();
        int n15 = n - 1 >> 1;
        int n16 = n - n15;
        int n17 = n15;
        int n18 = n13 - n16;
        int n19 = n15;
        int n20 = n14 - n16;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        int n21 = 0;
        for (n12 = 0; n12 < n14; ++n12) {
            n11 = 0;
            n10 = 0;
            n9 = 0;
            n8 = 0;
            n21 = 0;
            for (n7 = 0; n7 < n; ++n7) {
                n6 = bufferedImage.getRGB(n7, n12);
                n5 = (n6 & 0xFF000000) >>> 24;
                n4 = (n6 & 0xFF0000) >>> 16;
                n3 = (n6 & 0xFF00) >>> 8;
                n2 = n6 & 0xFF;
                nArray[n7] = n5;
                nArray2[n7] = n4;
                nArray3[n7] = n3;
                nArray4[n7] = n2;
                n11 += n5;
                n10 += n4;
                n9 += n3;
                n8 += n2;
            }
            for (n7 = n17; n7 < n18; ++n7) {
                n6 = n11 / n;
                n5 = n10 / n;
                n4 = n9 / n;
                n3 = n8 / n;
                bufferedImage2.setRGB(n7, n12, n6 << 24 | n5 << 16 | n4 << 8 | n3);
                n11 -= nArray[n21];
                n10 -= nArray2[n21];
                n9 -= nArray3[n21];
                n8 -= nArray4[n21];
                n2 = bufferedImage.getRGB(n7 + n16, n12);
                n6 = (n2 & 0xFF000000) >>> 24;
                n5 = (n2 & 0xFF0000) >>> 16;
                n4 = (n2 & 0xFF00) >>> 8;
                n3 = n2 & 0xFF;
                nArray[n21] = n6;
                nArray2[n21] = n5;
                nArray3[n21] = n4;
                nArray4[n21] = n3;
                n11 += n6;
                n10 += n5;
                n9 += n4;
                n8 += n3;
                if (++n21 < n) continue;
                n21 -= n;
            }
        }
        for (n12 = 0; n12 < n13; ++n12) {
            n11 = 0;
            n10 = 0;
            n9 = 0;
            n8 = 0;
            n21 = 0;
            for (n7 = 0; n7 < n; ++n7) {
                n6 = bufferedImage2.getRGB(n12, n7);
                n5 = (n6 & 0xFF000000) >>> 24;
                n4 = (n6 & 0xFF0000) >>> 16;
                n3 = (n6 & 0xFF00) >>> 8;
                n2 = n6 & 0xFF;
                nArray[n7] = n5;
                nArray2[n7] = n4;
                nArray3[n7] = n3;
                nArray4[n7] = n2;
                n11 += n5;
                n10 += n4;
                n9 += n3;
                n8 += n2;
            }
            for (n7 = n19; n7 < n20; ++n7) {
                n6 = n11 / n;
                n5 = n10 / n;
                n4 = n9 / n;
                n3 = n8 / n;
                bufferedImage2.setRGB(n12, n7, n6 << 24 | n5 << 16 | n4 << 8 | n3);
                n11 -= nArray[n21];
                n10 -= nArray2[n21];
                n9 -= nArray3[n21];
                n8 -= nArray4[n21];
                n2 = bufferedImage2.getRGB(n12, n7 + n16);
                n6 = (n2 & 0xFF000000) >>> 24;
                n5 = (n2 & 0xFF0000) >>> 16;
                n4 = (n2 & 0xFF00) >>> 8;
                n3 = n2 & 0xFF;
                nArray[n21] = n6;
                nArray2[n21] = n5;
                nArray3[n21] = n4;
                nArray4[n21] = n3;
                n11 += n6;
                n10 += n5;
                n9 += n4;
                n8 += n3;
                if (++n21 < n) continue;
                n21 -= n;
            }
        }
    }

    public BufferedImage createShadowMask(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.setComposite(AlphaComposite.getInstance(5, this.shadowOpacity));
        graphics2D.setColor(this.shadowColor);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.dispose();
        return bufferedImage2;
    }

    public ConvolveOp getBlurOp(int n) {
        float[] fArray = new float[n * n];
        float f = 1.0f / (float)(n * n);
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = f;
        }
        return new ConvolveOp(new Kernel(n, n, fArray));
    }

    public static void vibrate(final JComponent jComponent) {
        final Point point = jComponent.getLocation();
        final long l = System.currentTimeMillis();
        Timer timer = new Timer(10, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                long l2 = System.currentTimeMillis() - l;
                double d = (double)l2 % 50.0 / 50.0;
                double d2 = d * Math.PI * 2.0;
                int n = (int)(Math.sin(d2) * 5.0 + (double)point.x);
                jComponent.setLocation(n, point.y);
                jComponent.repaint();
                if (l2 >= 500L) {
                    this.stopShake((Timer)actionEvent.getSource(), jComponent);
                }
            }

            public void stopShake(Timer timer, JComponent jComponent2) {
                timer.stop();
                jComponent2.setLocation(point);
                jComponent2.repaint();
            }
        });
        timer.start();
    }
}

