/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing.tree;

import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.xoetrope.swing.XTree;
import net.xoetrope.swing.tree.XTreeModelAdapter;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.data.XDataBinding;
import net.xoetrope.xui.data.XModel;
import net.xoetrope.xui.data.XModelAdapterConfigurable;

public class XTreeBinding
extends XDataBinding {
    protected XTree treeComponent;
    protected XTreeModelAdapter adapter;

    public void setup(XProject xProject, Object object, Hashtable hashtable, Hashtable hashtable2) {
        this.setupHelper(xProject, object, hashtable, hashtable2);
        this.treeComponent = (XTree)object;
        String string = (String)hashtable2.get("adapter");
        if (string != null) {
            try {
                this.adapter = (XTreeModelAdapter)Class.forName(string.trim()).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.adapter == null) {
            this.adapter = new XTreeModelAdapter();
        }
        if (this.adapter instanceof XModelAdapterConfigurable) {
            ((XModelAdapterConfigurable)((Object)this.adapter)).configure(null, hashtable2);
        }
    }

    public void get() {
        try {
            this.adapter.setModel(this.sourceModel);
            this.treeComponent.setModel(new DefaultTreeModel(this.adapter));
            this.set();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void set() {
        if (this.outputModel != null) {
            this.outputModel.set(this.getTreePath());
        }
    }

    public String getName() {
        return (String)this.adapter.getModel().get();
    }

    public void setSource(XModel xModel) {
        if (this.adapter.getModel() != xModel) {
            this.adapter.setModel(xModel);
            this.get();
        }
    }

    public void setOutput(XModel xModel, String string) {
        if (this.outputModel == null || !this.outputModel.equals(xModel)) {
            this.outputModel = xModel;
            if (this.outputModel.get() == null && this.treeComponent.getModel().getChildCount(this.treeComponent.getModel().getRoot()) > 0) {
                try {
                    String string2 = this.getTreePath();
                    Vector<String> vector = new Vector<String>();
                    int n = string2.indexOf(47);
                    int n2 = 0;
                    while (n > 0) {
                        vector.add(string2.substring(n2, n++));
                        n2 = n;
                        n = string2.indexOf(47, n2);
                    }
                    vector.add(string2.substring(n2));
                    if (vector.size() > 0) {
                        Object[] objectArray = vector.toArray();
                        TreePath treePath = new TreePath(objectArray);
                        this.treeComponent.setSelectionPath(treePath);
                        this.treeComponent.scrollPathToVisible(treePath);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected String getTreePath() {
        String string = null;
        if (this.treeComponent.getSelectionPath() != null) {
            Object[] objectArray = this.treeComponent.getSelectionPath().getPath();
            string = "";
            for (int i = 1; i < objectArray.length; ++i) {
                string = string + objectArray[i].toString() + "/";
            }
            if (string.length() > 0) {
                string = string.substring(0, string.length() - 1);
            }
        }
        if (string == null) {
            return "";
        }
        if (string.trim().compareTo("") != 0) {
            return string;
        }
        return "";
    }

    public String getType() {
        return "tree";
    }
}

