/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing.toolbar;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import net.xoetrope.swing.XButton;

public class XToolbarButton
extends XButton {
    public XToolbarButton() {
        this.setOpaque(false);
    }

    public void paintBorder(Graphics graphics) {
    }

    public void paintComponent(Graphics graphics) {
        String string;
        ButtonModel buttonModel = this.getModel();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Rectangle rectangle = this.getBounds();
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(0.0f, 0.0f, rectangle.width, rectangle.height, 10.0f, 10.0f);
        RoundRectangle2D.Float float_2 = new RoundRectangle2D.Float(1.0f, 1.0f, rectangle.width - 2, rectangle.height - 3, 8.0f, 8.0f);
        RoundRectangle2D.Float float_3 = new RoundRectangle2D.Float(2.0f, 2.0f, rectangle.width - 4, rectangle.height - 5, 6.0f, 6.0f);
        graphics2D.clip(float_);
        Color color = this.getBackground();
        Color color2 = color.darker();
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color.brighter(), 0.0f, rectangle.height, color, true);
        if (buttonModel.isRollover()) {
            if (!buttonModel.isPressed()) {
                graphics2D.setPaint(gradientPaint);
            } else {
                graphics2D.setPaint(color);
            }
            graphics2D.fill(float_2);
        }
        if (buttonModel.isRollover()) {
            graphics2D.setPaint(new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), buttonModel.isPressed() ? 156 : 128));
            graphics2D.draw(float_2);
            GradientPaint gradientPaint2 = new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 200), 0.0f, rectangle.height, new Color(255, 255, 255, 0), true);
            graphics2D.setPaint(gradientPaint2);
            graphics2D.draw(float_3);
        }
        int n = 0;
        Icon icon = null;
        if (buttonModel.isPressed()) {
            icon = this.getPressedIcon();
        } else if (buttonModel.isRollover()) {
            icon = this.getRolloverIcon();
        } else if (buttonModel.isRollover()) {
            icon = this.getRolloverIcon();
        } else if (!buttonModel.isEnabled()) {
            icon = this.getDisabledIcon();
        } else if (buttonModel.isSelected()) {
            icon = this.getSelectedIcon();
        }
        if (icon == null) {
            icon = this.getIcon();
        }
        if (icon != null) {
            int n2 = icon.getIconHeight();
            int n3 = icon.getIconWidth();
            n += n3 + 4;
            icon.paintIcon(this, graphics, 4, Math.max(4, (rectangle.height - n2) / 2 + 1));
        }
        if ((string = this.getText()) != null && string.length() > 0) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics2D.setColor(this.getForeground());
            graphics2D.drawString(string, n + 4, rectangle.height / 2 + fontMetrics.getDescent() + 2);
        }
    }
}

