/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.xoetrope.swing.table.ColumnGroup;
import net.xoetrope.swing.table.GroupableTableHeader;

public class GroupableTableHeaderUI
extends BasicTableHeaderUI {
    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle = graphics.getClipBounds();
        if (this.header.getColumnModel() == null) {
            return;
        }
        ((GroupableTableHeader)this.header).setColumnMargin();
        int n = 0;
        Dimension dimension = this.header.getSize();
        Rectangle rectangle2 = new Rectangle(0, 0, dimension.width, dimension.height);
        Hashtable<ColumnGroup, Rectangle> hashtable = new Hashtable<ColumnGroup, Rectangle>();
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            rectangle2.height = dimension.height;
            rectangle2.y = 0;
            TableColumn tableColumn = enumeration.nextElement();
            Enumeration enumeration2 = ((GroupableTableHeader)this.header).getColumnGroups(tableColumn);
            if (enumeration2 != null) {
                int n2 = 0;
                while (enumeration2.hasMoreElements()) {
                    ColumnGroup columnGroup = (ColumnGroup)enumeration2.nextElement();
                    Rectangle rectangle3 = (Rectangle)hashtable.get(columnGroup);
                    if (rectangle3 == null) {
                        rectangle3 = new Rectangle(rectangle2);
                        Dimension dimension2 = columnGroup.getSize(this.header.getTable());
                        rectangle3.width = dimension2.width;
                        rectangle3.height = dimension2.height;
                        hashtable.put(columnGroup, rectangle3);
                    }
                    this.paintCell(graphics, rectangle3, columnGroup);
                    rectangle2.height = dimension.height - (n2 += rectangle3.height);
                    rectangle2.y = n2;
                }
            }
            rectangle2.width = tableColumn.getWidth();
            if (rectangle2.intersects(rectangle)) {
                this.paintCell(graphics, rectangle2, n);
            }
            rectangle2.x += rectangle2.width;
            ++n;
        }
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n) {
        TableColumn tableColumn = this.header.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.header.getDefaultRenderer();
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, false, -1, n);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(graphics, component, this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, ColumnGroup columnGroup) {
        TableCellRenderer tableCellRenderer = columnGroup.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.header.getDefaultRenderer();
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), columnGroup.getHeaderValue(), false, false, -1, -1);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(graphics, component, this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    private int getHeaderHeight() {
        int n = 0;
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            Object object;
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            if (tableCellRenderer == null) {
                tableCellRenderer = this.header.getDefaultRenderer();
            }
            int n2 = 0;
            if (tableCellRenderer != null) {
                object = tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, false, -1, i);
                n2 = ((Component)object).getPreferredSize().height;
            }
            if ((object = ((GroupableTableHeader)this.header).getColumnGroups(tableColumn)) != null) {
                while (object.hasMoreElements()) {
                    ColumnGroup columnGroup = (ColumnGroup)object.nextElement();
                    n2 += columnGroup.getSize((JTable)this.header.getTable()).height;
                }
            }
            n = Math.max(n, n2);
        }
        return n;
    }

    private Dimension createHeaderSize(long l) {
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        if ((l += (long)(tableColumnModel.getColumnMargin() * tableColumnModel.getColumnCount())) > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        return new Dimension((int)l, this.getHeaderHeight());
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        long l = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getPreferredWidth();
        }
        return this.createHeaderSize(l);
    }
}

