/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing.table;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.xoetrope.swing.table.ColumnGroup;
import net.xoetrope.swing.table.GroupableTableHeaderUI;

public class GroupableTableHeader
extends JTableHeader {
    private static final String uiClassID = "GroupableTableHeaderUI";
    protected Vector columnGroups = null;

    public GroupableTableHeader(TableColumnModel tableColumnModel) {
        super(tableColumnModel);
        this.setUI(new GroupableTableHeaderUI());
        this.setReorderingAllowed(false);
    }

    public void setUI(TableHeaderUI tableHeaderUI) {
    }

    protected void setUI(GroupableTableHeaderUI groupableTableHeaderUI) {
        super.setUI(groupableTableHeaderUI);
    }

    public void setReorderingAllowed(boolean bl) {
        this.reorderingAllowed = false;
    }

    public void addColumnGroup(ColumnGroup columnGroup) {
        if (this.columnGroups == null) {
            this.columnGroups = new Vector();
        }
        this.columnGroups.addElement(columnGroup);
    }

    public Enumeration getColumnGroups(TableColumn tableColumn) {
        if (this.columnGroups == null) {
            return null;
        }
        Enumeration enumeration = this.columnGroups.elements();
        while (enumeration.hasMoreElements()) {
            ColumnGroup columnGroup = (ColumnGroup)enumeration.nextElement();
            Vector vector = columnGroup.getColumnGroups(tableColumn, new Vector());
            if (vector == null) continue;
            return vector.elements();
        }
        return null;
    }

    public void setColumnMargin() {
        if (this.columnGroups == null) {
            return;
        }
        int n = this.getColumnModel().getColumnMargin();
        Enumeration enumeration = this.columnGroups.elements();
        while (enumeration.hasMoreElements()) {
            ColumnGroup columnGroup = (ColumnGroup)enumeration.nextElement();
            columnGroup.setColumnMargin(n);
        }
    }
}

