/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing.splash;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class XSplashWindow
extends Window {
    private static XSplashWindow instance;
    private Image image;
    private boolean paintCalled = false;
    private int x;
    private int y;
    private int imgWidth;
    private int imgHeight;
    private BufferedImage screenShot;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XSplashWindow(Frame frame, Image image) {
        super(frame);
        this.image = image;
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (mediaTracker.isErrorID(0)) {
            this.setSize(0, 0);
            System.err.println("Warning: SplashWindow couldn't load splash image.");
            XSplashWindow xSplashWindow = this;
            synchronized (xSplashWindow) {
                this.paintCalled = true;
                this.notifyAll();
            }
            return;
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.imgWidth = image.getWidth(this);
        this.imgHeight = image.getHeight(this);
        this.x = (dimension.width - this.imgWidth) / 2;
        this.y = (dimension.height - this.imgHeight) / 2;
        this.captureScreenShot();
        this.setSize(this.imgWidth, this.imgHeight);
        this.setLocation(this.x, this.y);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseClicked(MouseEvent mouseEvent) {
                XSplashWindow xSplashWindow = XSplashWindow.this;
                synchronized (xSplashWindow) {
                    XSplashWindow.this.paintCalled = true;
                    XSplashWindow.this.notifyAll();
                }
                XSplashWindow.this.dispose();
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addWindowListener(new WindowAdapter(){

            public void windowDeactivated(WindowEvent windowEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        XSplashWindow.this.captureScreenShot();
                        XSplashWindow.this.toFront();
                    }
                });
            }
        });
    }

    public Graphics getGraphics() {
        return super.getGraphics();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        if (this.screenShot != null) {
            graphics.drawImage(this.screenShot, 0, 0, this);
        }
        graphics.drawImage(this.image, 0, 0, this);
        if (!this.paintCalled) {
            this.paintCalled = true;
            XSplashWindow xSplashWindow = this;
            synchronized (xSplashWindow) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splash(Image image) {
        if (instance == null && image != null) {
            Frame frame = new Frame();
            instance = new XSplashWindow(frame, image);
            instance.show();
            if (!EventQueue.isDispatchThread() && Runtime.getRuntime().availableProcessors() == 1) {
                XSplashWindow xSplashWindow = instance;
                synchronized (xSplashWindow) {
                    while (!XSplashWindow.instance.paintCalled) {
                        try {
                            instance.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
    }

    public static void splash(URL uRL) {
        if (uRL != null) {
            XSplashWindow.splash(Toolkit.getDefaultToolkit().createImage(uRL));
        }
    }

    public static void disposeSplash(int n) {
        if (instance != null) {
            instance.repaint();
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    instance.getOwner().dispose();
                    instance = null;
                }
            };
            Timer timer = new Timer(n, actionListener);
            timer.setRepeats(false);
            timer.start();
        }
    }

    public static void invokeMain(String string, String[] stringArray) {
        try {
            Class.forName(string.trim()).getMethod("main", String[].class).invoke(null, new Object[]{stringArray});
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Failed to invoke main method");
            internalError.initCause(exception);
            throw internalError;
        }
    }

    public void setAlwaysOnTop() {
        try {
            Class[] classArray = new Class[]{Boolean.TYPE};
            XSplashWindow xSplashWindow = this;
            Method method = xSplashWindow.getClass().getMethod("setAlwaysOnTop", classArray);
            if (method != null) {
                Object[] objectArray = new Object[]{Boolean.TRUE};
                if (method != null) {
                    method.invoke((Object)xSplashWindow, objectArray);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void captureScreenShot() {
        try {
            this.setSize(0, 0);
            Robot robot = new Robot();
            Rectangle rectangle = new Rectangle(this.x, this.y, this.imgWidth, this.imgHeight);
            this.screenShot = robot.createScreenCapture(rectangle);
            this.setSize(this.imgWidth, this.imgHeight);
            this.repaint();
        }
        catch (AWTException aWTException) {
            aWTException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        XSplashWindow.splash(XSplashWindow.class.getResource("/splash.gif"));
        if (stringArray.length == 0) {
            XSplashWindow.invokeMain("net.xoetrope.swing.XApplet", stringArray);
        } else {
            String[] stringArray2 = new String[stringArray.length - 1];
            for (int i = 1; i < stringArray.length; ++i) {
                stringArray2[i - 1] = stringArray[i];
            }
            XSplashWindow.invokeMain(stringArray[0], stringArray2);
        }
        XSplashWindow.disposeSplash(8000);
    }
}

