/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing.painter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import net.xoetrope.swing.painter.XTitlePainter;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.XProjectManager;

public class XGradientBackground
implements XTitlePainter {
    protected Color titleColor;
    protected Color titleTextColor = new Color(255, 255, 255);
    protected Font titleFont;
    protected float titleHeight = 3.0f;
    protected boolean blend = true;
    protected String title;
    protected int titlePos = 1;
    protected XProject currentProject = XProjectManager.getCurrentProject();

    public void paint(Graphics2D graphics2D, Object object, int n, int n2) {
        this.paint(graphics2D, (JComponent)object, n, n2);
    }

    public void paint(Graphics2D graphics2D, JComponent jComponent, int n, int n2) {
        int n3;
        Graphics2D graphics2D2 = graphics2D;
        JComponent jComponent2 = jComponent;
        Color color = jComponent2.getForeground();
        Color color2 = jComponent2.getBackground();
        AffineTransform affineTransform = graphics2D2.getTransform();
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n4 = this.blend ? this.currentProject.getStartupParamAsInt("ClientWidth") : ((Component)jComponent2).getWidth();
        int n5 = n3 = this.blend ? this.currentProject.getStartupParamAsInt("ClientHeight") : ((Component)jComponent2).getHeight();
        if (n4 == 0 && n3 == 0) {
            n4 = n;
            n3 = n2;
        }
        Rectangle rectangle = this.blend ? jComponent2.getParent().getParent().getBounds() : jComponent2.getBounds();
        AffineTransform affineTransform2 = null;
        if (this.blend) {
            affineTransform2 = (AffineTransform)graphics2D2.getTransform().clone();
            affineTransform2.translate(-rectangle.x, -rectangle.y);
            graphics2D2.setTransform(affineTransform2);
        }
        this.paintBackground(graphics2D2, n + rectangle.x, n2 + rectangle.y, n4, n3, color, color2);
        this.paintExtras(graphics2D2, jComponent, n, n2);
        if (this.blend) {
            graphics2D2.setTransform(affineTransform);
        }
        if (this.titleColor != null) {
            Object object;
            color2 = new Color(255, 255, 255, 10);
            this.titleHeight = 3.0f;
            if (this.title != null) {
                object = jComponent2.getFont();
                int n6 = (int)((Font)object).getSize2D();
                this.titleHeight += (float)n6 + 4.0f;
            }
            object = new GradientPaint(0.0f, 0.0f, this.titleColor, n, this.titleHeight, color2);
            graphics2D2.setPaint((Paint)object);
            Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, this.titlePos == 1 ? (float)n2 - this.titleHeight : 0.0f, n, this.titleHeight);
            graphics2D2.fill(float_);
            if (this.title != null) {
                if (this.titleFont != null) {
                    graphics2D2.setFont(this.titleFont);
                }
                graphics2D2.setColor(this.titleTextColor);
                graphics2D2.drawString(this.title, 3.0f, this.titlePos == 1 ? (float)(n2 - 3) : this.titleHeight - 3.0f);
            }
        }
        graphics2D2.setPaint(null);
    }

    protected Paint getBackgroundPaint(Color color, float f, float f2, Color color2) {
        return new GradientPaint(0.0f, 0.0f, color, f, f2, color2);
    }

    protected void paintBackground(Graphics2D graphics2D, float f, float f2, float f3, float f4, Color color, Color color2) {
        Paint paint = this.getBackgroundPaint(color, f3, f4, color2);
        graphics2D.setPaint(paint);
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, f, f2);
        graphics2D.fill(float_);
    }

    protected void paintExtras(Graphics2D graphics2D, Object object, int n, int n2) {
    }

    public void setTitleColor(Color color) {
        this.titleColor = color;
    }

    public void setTitleTextColor(Color color) {
        this.titleTextColor = color;
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
    }

    public void setBlend(boolean bl) {
        this.blend = bl;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setTitlePosition(int n) {
        this.titlePos = n;
    }
}

