/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing.docking;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import net.xoetrope.swing.docking.XCardPanel;
import net.xoetrope.swing.docking.XDockable;
import net.xoetrope.swing.docking.XDockingPreview;

public class XDockingSideBar
extends JPanel {
    private static final int PREVIEW_SIZE = 250;
    private FontMetrics fm;
    private Color sidebarBkColor;
    private Color sidebarTextColor;
    private Color sidebarRolloverTextColor;
    private boolean isVertical;
    private String docklocation;
    private Dimension defSize = new Dimension(25, 25);
    private Container glassPane;
    private XDockingPreview dockingPreview;

    public XDockingSideBar(Container container, String string) {
        this.glassPane = container;
        this.docklocation = string.toLowerCase();
        this.isVertical = !this.docklocation.equals("south");
        this.setOpaque(true);
        this.setLayout(new BoxLayout(this, this.isVertical ? 1 : 0));
        this.glassPane.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                XDockingSideBar.this.redispatchMouseEvent(mouseEvent, false);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                XDockingSideBar.this.redispatchMouseEvent(mouseEvent, false);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (XDockingSideBar.this.dockingPreview != null) {
                    Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), XDockingSideBar.this.dockingPreview);
                    if (XDockingSideBar.this.dockingPreview.contains(point)) {
                        return;
                    }
                    XDockingSideBar.this.hidePopup();
                    XDockingSideBar.this.redispatchMouseEvent(mouseEvent, true);
                }
            }
        });
        this.glassPane.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                if (XDockingSideBar.this.dockingPreview != null) {
                    Point point = mouseEvent.getPoint();
                    Point point2 = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, XDockingSideBar.this.dockingPreview);
                    if (XDockingSideBar.this.dockingPreview.contains(point2)) {
                        return;
                    }
                    if (XDockingSideBar.this.docklocation.equals("west") && point.x < XDockingSideBar.this.dockingPreview.getX()) {
                        return;
                    }
                    if (XDockingSideBar.this.docklocation.equals("east") && point.x > XDockingSideBar.this.dockingPreview.getX()) {
                        return;
                    }
                    if (XDockingSideBar.this.docklocation.equals("south") && point.y > XDockingSideBar.this.dockingPreview.getY()) {
                        return;
                    }
                    Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    if (!XDockingSideBar.this.isChildOf(XDockingSideBar.this.dockingPreview, component)) {
                        XDockingSideBar.this.hidePopup();
                    }
                }
                XDockingSideBar.this.redispatchMouseEvent(mouseEvent, true);
            }
        });
    }

    public void applyStyles(Color color, Color color2, Color color3) {
        this.sidebarBkColor = color;
        this.sidebarTextColor = color2;
        this.sidebarRolloverTextColor = color3;
        this.setBackground(color);
    }

    public void add(XDockable xDockable) {
        this.add(new XDockButton(xDockable, this.isVertical));
        this.revalidate();
    }

    public void removeDockable(XDockable xDockable) {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            XDockButton xDockButton = (XDockButton)this.getComponent(i);
            if (xDockButton.dockable != xDockable) continue;
            this.remove(xDockButton);
            this.revalidate();
            return;
        }
    }

    public Dimension getPreferredSize() {
        if (this.getComponentCount() == 0) {
            return new Dimension(0, 0);
        }
        if (this.defSize != null) {
            return this.defSize;
        }
        return super.getPreferredSize();
    }

    public void showPopup(XDockable xDockable) {
        this.hidePopup();
        this.dockingPreview = new XDockingPreview(this.glassPane, xDockable);
        Point point = this.getLocation();
        Point point2 = SwingUtilities.convertPoint(this, new Point(0, 0), this.glassPane);
        if (this.docklocation.equals("west")) {
            this.dockingPreview.setLocation(this.getWidth(), point2.y);
            this.dockingPreview.setSize(250, this.getHeight());
        } else if (this.docklocation.equals("east")) {
            this.dockingPreview.setLocation(point.x - 250, point2.y);
            this.dockingPreview.setSize(250, this.getHeight());
        } else if (this.docklocation.equals("south")) {
            this.dockingPreview.setLocation(point2.x, point2.y - 250);
            this.dockingPreview.setSize(this.getWidth(), 250);
        } else {
            this.dockingPreview = null;
            return;
        }
        this.glassPane.setLayout(null);
        this.glassPane.add(this.dockingPreview);
        this.glassPane.setVisible(true);
    }

    public void hidePopup() {
        if (this.dockingPreview != null) {
            XDockable xDockable = this.dockingPreview.getDockable();
            this.dockingPreview.setVisible(false);
            this.glassPane.remove(this.dockingPreview);
            this.glassPane.setVisible(false);
            this.repaint();
            xDockable.dockedContainer.fireDockingPanelListeners(3);
        }
        this.dockingPreview = null;
    }

    private void redispatchMouseEvent(MouseEvent mouseEvent, boolean bl) {
        Component component;
        Point point = mouseEvent.getPoint();
        Container container = this.getRootPane().getContentPane();
        Point point2 = SwingUtilities.convertPoint(this.glassPane, point, container);
        if (point2.y >= 0 && (component = SwingUtilities.getDeepestComponentAt(container, point2.x, point2.y)) != null) {
            Point point3 = SwingUtilities.convertPoint(this.glassPane, point, component);
            component.dispatchEvent(new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point3.x, point3.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
        }
    }

    private boolean isChildOf(Component component, Component component2) {
        while (component2 != null) {
            if (component2 == component) {
                return true;
            }
            component2 = component2.getParent();
        }
        return false;
    }

    public class XDockButton
    extends JButton
    implements ActionListener,
    MouseListener {
        private String title;
        private Dimension preferredSize;
        private XDockable dockable;
        private boolean hasMouse;
        private boolean isVertical;

        public XDockButton(XDockable xDockable, boolean bl) {
            this.setBackground(XDockingSideBar.this.sidebarBkColor);
            this.dockable = xDockable;
            this.dockable.launchContainer = this;
            this.title = xDockable.title;
            this.isVertical = bl;
            if (!this.isVertical) {
                this.setText(this.title);
            }
            Dimension dimension = super.getPreferredSize();
            this.setSize(new Dimension(dimension.height, dimension.width));
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
            if (this.dockable.icon != null) {
                this.setIcon(this.dockable.icon);
            }
            this.setOpaque(false);
            this.addActionListener(this);
            this.addMouseListener(this);
        }

        public XDockable getDockable() {
            return this.dockable;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.dockable != null) {
                Container container = this.getParent();
                XCardPanel xCardPanel = this.dockable.getCardPanel();
                xCardPanel.restoreViews();
                this.dockable.dockedContainer.restoreContent(this.dockable);
                container.remove(this);
                container.repaint();
                if (container.getComponentCount() == 0) {
                    ((JComponent)container).revalidate();
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.hasMouse = false;
            XDockingSideBar.this.hidePopup();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.hasMouse = false;
            XDockingSideBar.this.hidePopup();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (!this.hasMouse && XDockingSideBar.this.dockingPreview == null && !XDockingSideBar.this.glassPane.isVisible()) {
                this.hasMouse = true;
                final XDockable xDockable = ((XDockButton)mouseEvent.getSource()).getDockable();
                Timer timer = new Timer(1000, new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (XDockButton.this.hasMouse) {
                            XDockingSideBar.this.showPopup(xDockable);
                        }
                    }
                });
                timer.setRepeats(false);
                timer.start();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.hasMouse = false;
        }

        public Insets getInsets() {
            return new Insets(1, 1, 1, 1);
        }

        public void paintComponent(Graphics graphics) {
            if (XDockingSideBar.this.fm == null) {
                XDockingSideBar.this.fm = graphics.getFontMetrics(this.getFont());
                this.preferredSize = null;
                this.revalidate();
            }
            ButtonModel buttonModel = this.getModel();
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            Rectangle rectangle = this.getBounds();
            RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(0.0f, 0.0f, rectangle.width, rectangle.height, 10.0f, 10.0f);
            RoundRectangle2D.Float float_2 = new RoundRectangle2D.Float(1.0f, 1.0f, rectangle.width - 2, rectangle.height - 3, 8.0f, 8.0f);
            RoundRectangle2D.Float float_3 = new RoundRectangle2D.Float(2.0f, 2.0f, rectangle.width - 4, rectangle.height - 5, 6.0f, 6.0f);
            graphics2D.clip(float_);
            Color color = this.getBackground();
            Color color2 = color.darker();
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color.brighter(), 0.0f, rectangle.height, color, true);
            if (buttonModel.isRollover()) {
                if (!buttonModel.isPressed()) {
                    graphics2D.setPaint(gradientPaint);
                } else {
                    graphics2D.setPaint(color);
                }
                graphics2D.fill(float_2);
            }
            if (buttonModel.isRollover()) {
                graphics2D.setPaint(new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), buttonModel.isPressed() ? 156 : 128));
                graphics2D.draw(float_2);
                GradientPaint gradientPaint2 = new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 200), 0.0f, rectangle.height, new Color(255, 255, 255, 0), true);
                graphics2D.setPaint(gradientPaint2);
                graphics2D.draw(float_3);
            }
            int n = 0;
            Icon icon = null;
            if (buttonModel.isPressed()) {
                icon = this.getPressedIcon();
            } else if (buttonModel.isRollover()) {
                icon = this.getRolloverIcon();
            } else if (buttonModel.isRollover()) {
                icon = this.getRolloverIcon();
            } else if (!buttonModel.isEnabled()) {
                icon = this.getDisabledIcon();
            } else if (buttonModel.isSelected()) {
                icon = this.getSelectedIcon();
            }
            if (icon == null) {
                icon = this.getIcon();
            }
            if (!this.isVertical) {
                String string;
                if (icon != null) {
                    int n2 = icon.getIconHeight();
                    int n3 = icon.getIconWidth();
                    n += n3 + 4;
                    icon.paintIcon(this, graphics, 4, Math.max(4, (rectangle.height - n2) / 2 + 1));
                }
                if ((string = this.getText()) != null && string.length() > 0) {
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    graphics2D.setColor(buttonModel.isRollover() ? XDockingSideBar.this.sidebarRolloverTextColor : XDockingSideBar.this.sidebarTextColor);
                    graphics2D.drawString(string, n + 4, rectangle.height / 2 + fontMetrics.getDescent() + 2);
                }
            } else {
                int n4 = XDockingSideBar.this.fm.stringWidth(this.title);
                int n5 = 0;
                if (icon != null) {
                    n5 = icon.getIconWidth();
                }
                this.preferredSize = new Dimension(((XDockingSideBar)XDockingSideBar.this).defSize.width, n4 + 16 + n5);
                n = 0;
                if (icon != null) {
                    int n6 = icon.getIconHeight();
                    icon.paintIcon(this, graphics2D, (rectangle.width - n6) / 2, rectangle.height - 2 - n5);
                }
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.translate(0, this.preferredSize.width - 1);
                graphics2D.rotate(-1.57);
                graphics2D.setColor(buttonModel.isRollover() ? XDockingSideBar.this.sidebarRolloverTextColor : XDockingSideBar.this.sidebarTextColor);
                graphics2D.drawString(this.title, (float)n + ((float)(this.preferredSize.width - n4) - 8.0f), (float)XDockingSideBar.this.fm.getHeight() + 2.0f);
                graphics2D.setTransform(affineTransform);
            }
        }

        public Dimension getPreferredSize() {
            Object object;
            if (!this.isVertical) {
                return new Dimension(super.getPreferredSize().width + 8, ((XDockingSideBar)XDockingSideBar.this).defSize.height);
            }
            if (this.preferredSize != null) {
                return this.preferredSize;
            }
            int n = 16;
            if (XDockingSideBar.this.fm == null) {
                object = this.getGraphics();
                XDockingSideBar.this.fm = ((Graphics)object).getFontMetrics();
                ((Graphics)object).dispose();
            }
            n = XDockingSideBar.this.fm.stringWidth(this.title) + 16;
            object = this.getIcon();
            int n2 = 0;
            if (object != null) {
                n2 = object.getIconWidth();
            }
            this.preferredSize = new Dimension(((XDockingSideBar)XDockingSideBar.this).defSize.width, n + n2);
            return new Dimension(this.getFont().getSize() + 16, ((XDockingSideBar)XDockingSideBar.this).defSize.height);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }
}

