/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing.docking;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.xoetrope.swing.docking.XCardPanel;
import net.xoetrope.swing.docking.XDockable;
import net.xoetrope.swing.docking.XDockableHeader;
import net.xoetrope.swing.docking.XDockableTransferHandler;
import net.xoetrope.swing.docking.XDockingPanelListener;
import org.jdesktop.swingx.JXMultiSplitPane;
import org.jdesktop.swingx.MultiSplitLayout;

public class XDockingPanel
extends JPanel {
    public static final boolean USE_REMOVE_STRATEGY = false;
    public static final int CLOSED = 0;
    public static final int MAXIMIZED = 1;
    public static final int MINIMIZED = 2;
    public static final int PREVIEW_CLOSED = 3;
    public static final int PREVIEW_OPENED = 4;
    public static final int RESTORED = 5;
    protected XDockableHeader activeHeader;
    protected JPanel contentPane;
    protected JPanel headerPanel;
    protected Dimension defSize;
    private CardLayout contentManager;
    private String constraint;
    protected JXMultiSplitPane splitPane;
    protected ArrayList listeners;

    public XDockingPanel(String string) {
        this.constraint = string;
        this.listeners = new ArrayList();
        this.setName(string);
        this.setBackground(SystemColor.control);
        this.setLayout(new BorderLayout());
        this.setTransferHandler(new XDockableTransferHandler(this));
        this.headerPanel = new JPanel();
        this.headerPanel.setLayout(new GridLayout(1, 0));
        this.add((Component)this.headerPanel, "North");
        this.contentPane = new JPanel();
        this.add((Component)this.contentPane, "Center");
        this.contentPane.setOpaque(true);
        this.contentPane.setBackground(Color.white);
        this.contentManager = new CardLayout();
        this.contentPane.setLayout(this.contentManager);
    }

    public void addDockingPanelListener(XDockingPanelListener xDockingPanelListener) {
        this.listeners.add(xDockingPanelListener);
    }

    public void removeDockingPanelListener(XDockingPanelListener xDockingPanelListener) {
        this.listeners.remove(xDockingPanelListener);
    }

    public void fireDockingPanelListeners(int n) {
        int n2 = this.listeners.size();
        block8: for (int i = 0; i < n2; ++i) {
            XDockingPanelListener xDockingPanelListener = (XDockingPanelListener)this.listeners.get(i);
            switch (n) {
                case 0: {
                    xDockingPanelListener.panelClosed();
                    continue block8;
                }
                case 1: {
                    xDockingPanelListener.panelMaximized();
                    continue block8;
                }
                case 2: {
                    xDockingPanelListener.panelMimimized();
                    continue block8;
                }
                case 3: {
                    xDockingPanelListener.panelPreviewClosed();
                    continue block8;
                }
                case 4: {
                    xDockingPanelListener.panelPreviewOpened();
                    continue block8;
                }
                case 5: {
                    xDockingPanelListener.panelRestored();
                }
            }
        }
    }

    void addDragProxies(Container container) {
        container.setLayout(null);
        this.splitPane = (JXMultiSplitPane)this.getParent();
        if (this.splitPane != null) {
            XDockableProxy xDockableProxy;
            int n;
            ArrayList<XDockableProxy> arrayList = new ArrayList<XDockableProxy>();
            Component[] componentArray = this.splitPane.getComponents();
            for (n = 0; n < componentArray.length; ++n) {
                Component component = componentArray[n];
                if (!(component instanceof XDockingPanel)) continue;
                xDockableProxy = new XDockableProxy((XDockingPanel)component);
                Point point = SwingUtilities.convertPoint(component, 0, 0, container);
                xDockableProxy.setLocation(point);
                xDockableProxy.setVisible(true);
                xDockableProxy.setSize(component.getSize());
                xDockableProxy.setTransferHandler(new XDockableTransferHandler(this));
                arrayList.add(xDockableProxy);
            }
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    Rectangle rectangle;
                    Rectangle rectangle2 = ((XDockableProxy)object).getBounds();
                    if (rectangle2.intersects(rectangle = ((XDockableProxy)object2).getBounds())) {
                        int n = rectangle2.width * rectangle2.height;
                        int n2 = rectangle.width * rectangle.height;
                        if (n < n2) {
                            return -1;
                        }
                        if (n > n2) {
                            return 1;
                        }
                        return 0;
                    }
                    if (rectangle2.contains(rectangle)) {
                        return 1;
                    }
                    if (rectangle2.equals(rectangle)) {
                        return 0;
                    }
                    return -1;
                }
            });
            n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                xDockableProxy = (XDockableProxy)arrayList.get(i);
                container.add(xDockableProxy);
            }
        }
    }

    private void addChildAreas(ArrayList arrayList, MultiSplitLayout.Node node) {
        if (node instanceof MultiSplitLayout.Leaf) {
            arrayList.add(node.getBounds());
        } else if (node instanceof MultiSplitLayout.Split) {
            List list = ((MultiSplitLayout.Split)node).getChildren();
            for (int i = 0; i < list.size(); ++i) {
                MultiSplitLayout.Node node2 = (MultiSplitLayout.Node)list.get(i);
                this.addChildAreas(arrayList, node2);
            }
        }
    }

    public String getConstraint() {
        return this.constraint;
    }

    public void setConstraint(String string) {
        this.constraint = string;
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    public void restoreContent(XDockable xDockable) {
        int n = this.headerPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            ((XDockableHeader)this.headerPanel.getComponent(i)).setActive(false);
        }
        this.contentPane.add((Component)xDockable.content, xDockable.getId());
        this.contentManager.show(this.contentPane, xDockable.getId());
        this.setVisible(true);
        this.restoreDividers(xDockable.dockedContainer);
        this.headerPanel.add(xDockable.header);
        XDockableHeader cfr_ignored_0 = xDockable.header;
        xDockable.header.setZoomState(1);
        xDockable.header.setVisible(true);
        xDockable.header.setActive(true);
        this.activeHeader = xDockable.header;
        this.splitPane.revalidate();
        this.fireDockingPanelListeners(5);
    }

    public void addDockable(XDockable xDockable, Color[] colorArray, String[] stringArray) {
        if (this.activeHeader != null) {
            this.activeHeader.setActive(false);
        }
        xDockable.dockedContainer = this;
        XDockableHeader xDockableHeader = null;
        xDockableHeader = xDockable.header == null ? new XDockableHeader(xDockable, colorArray, stringArray) : xDockable.header;
        xDockableHeader.setText(xDockable.title);
        xDockableHeader.setToolTipText(xDockable.title);
        xDockable.header = xDockableHeader;
        this.headerPanel.add(xDockableHeader);
        xDockable.content.setName(xDockable.constraint);
        this.contentPane.add((Component)xDockable.content, xDockable.getId());
        this.contentManager.show(this.contentPane, xDockable.getId());
        this.activeHeader = xDockableHeader;
        this.activeHeader.setActive(true);
    }

    public void setActivateHeader(XDockableHeader xDockableHeader) {
        if (this.activeHeader != null) {
            this.activeHeader.setActive(false);
        }
        this.activeHeader = xDockableHeader;
        XDockable xDockable = this.activeHeader.getDockable();
        this.contentManager.show(this.contentPane, xDockable.getId());
        this.activeHeader.setActive(true);
    }

    public void removeDockable(XDockable xDockable, boolean bl, boolean bl2) {
        this.removeDockable(xDockable, bl);
        if (bl2 && xDockable.dockingSideBar != null) {
            xDockable.dockingSideBar.removeDockable(xDockable);
        }
    }

    public void removeDockable(XDockable xDockable, boolean bl) {
        this.activeHeader = xDockable.header;
        Container container = this.getParent();
        if (!(container instanceof JXMultiSplitPane)) {
            while (!(container instanceof XCardPanel)) {
                container = container.getParent();
            }
            ((XCardPanel)container).swapViews(xDockable);
        }
        this.splitPane = (JXMultiSplitPane)this.getParent();
        int n = this.getComponentZOrder(this.headerPanel, this.activeHeader);
        if (n > 0) {
            --n;
        }
        this.headerPanel.remove(this.activeHeader);
        this.headerPanel.revalidate();
        boolean bl2 = this.headerPanel.getComponentCount() > 0;
        this.headerPanel.doLayout();
        this.headerPanel.repaint();
        if (!bl2) {
            this.setVisible(false);
            this.hideDividers(xDockable.dockedContainer);
        }
        if (bl) {
            xDockable.dockingSideBar.add(xDockable);
        }
        this.contentManager.removeLayoutComponent(xDockable.content);
        this.contentPane.remove(xDockable.content);
        this.activeHeader = null;
        if (bl2) {
            if (n >= 0) {
                this.activeHeader = (XDockableHeader)this.headerPanel.getComponent(n);
            }
            if (this.activeHeader != null) {
                this.contentManager.show(this.contentPane, this.activeHeader.getDockable().getId());
                this.activeHeader.setActive(true);
            }
        }
        this.revalidate();
        this.splitPane.revalidate();
        this.fireDockingPanelListeners(bl ? 2 : 0);
    }

    public void dock() {
        this.removeDockable(this.activeHeader.getDockable(), true);
    }

    public String getTitle() {
        return this.activeHeader.getText();
    }

    public void setTitle(String string) {
        this.activeHeader.setText(string);
        this.activeHeader.setToolTipText(string);
    }

    public Dimension getPreferredSize() {
        if (this.defSize != null) {
            return this.defSize;
        }
        return super.getPreferredSize();
    }

    private void hideDividers(Component component) {
        MultiSplitLayout multiSplitLayout = (MultiSplitLayout)this.splitPane.getLayout();
        MultiSplitLayout.Node node = multiSplitLayout.getNodeForComponent(component);
        if (node != null) {
            MultiSplitLayout.Split split = node.getParent();
            split.hide(node);
            if (!split.isVisible()) {
                split.getParent().hide((MultiSplitLayout.Node)split);
            }
            split.checkDividers(split);
            while (!split.isVisible() && (split = split.getParent()) != null) {
                split.checkDividers(split);
            }
        }
        multiSplitLayout.setFloatingDividers(false);
    }

    private void restoreDividers(Component component) {
        MultiSplitLayout multiSplitLayout = (MultiSplitLayout)this.splitPane.getLayout();
        MultiSplitLayout.Node node = multiSplitLayout.getNodeForComponent(component);
        if (node != null) {
            node.setVisible(true);
            MultiSplitLayout.Split split = node.getParent();
            split.restoreDividers(split);
        }
        multiSplitLayout.setFloatingDividers(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getComponentZOrder(Container container, Component component) {
        if (component == null) {
            return -1;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            if (component.getParent() != container) {
                return -1;
            }
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                if (container.getComponent(i) != component) continue;
                return i;
            }
        }
        return -1;
    }

    public class XDockableProxy
    extends JLabel {
        private XDockingPanel dockingPanel;

        XDockableProxy(XDockingPanel xDockingPanel2) {
            this.dockingPanel = xDockingPanel2;
        }

        public XDockingPanel getDockingPanel() {
            return this.dockingPanel;
        }
    }
}

