/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing.docking;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import net.xoetrope.swing.docking.XDockable;
import net.xoetrope.swing.docking.XDockableHeader;
import net.xoetrope.swing.docking.XDockingPanel;

public class XDockableTransferHandler
extends TransferHandler {
    private static XDockable transferDockable;
    private Object target;
    private static DataFlavor dockableFlavor;

    public XDockableTransferHandler(Object object) {
        this.target = object;
        if (dockableFlavor == null) {
            try {
                dockableFlavor = new DataFlavor("application/x-xui-xdockable");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        XDockableTransferHandler.transferDockable.header.endDock();
        XDockingPanel xDockingPanel = null;
        if (jComponent instanceof XDockingPanel) {
            xDockingPanel = (XDockingPanel)jComponent;
        } else if (jComponent instanceof XDockableHeader) {
            xDockingPanel = (XDockingPanel)((XDockableHeader)jComponent).getParent().getParent();
        } else if (jComponent instanceof XDockingPanel.XDockableProxy) {
            xDockingPanel = ((XDockingPanel.XDockableProxy)jComponent).getDockingPanel();
        }
        if (xDockingPanel != null) {
            XDockableTransferHandler.transferDockable.dockedContainer.removeDockable(transferDockable, false);
            xDockingPanel.addDockable(transferDockable, null, null);
            if (!xDockingPanel.isVisible()) {
                xDockingPanel.restoreContent(transferDockable);
            }
            transferDockable = null;
            return transferable instanceof XDockableTransferHandler;
        }
        return false;
    }

    protected Transferable createTransferable(JComponent jComponent) {
        return new XDockableTransferable(((XDockableHeader)jComponent).getDockable());
    }

    public int getSourceActions(JComponent jComponent) {
        return 2;
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (transferDockable != null) {
            XDockableTransferHandler.transferDockable.header.endDock();
        }
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        if (jComponent instanceof XDockableHeader) {
            XDockableTransferHandler.transferDockable.header.showDock(jComponent, ((XDockableHeader)jComponent).getParent().getParent());
            return true;
        }
        if (jComponent instanceof XDockingPanel) {
            XDockableTransferHandler.transferDockable.header.showDock(jComponent, jComponent);
            return true;
        }
        if (jComponent instanceof XDockingPanel.XDockableProxy) {
            XDockingPanel xDockingPanel = ((XDockingPanel.XDockableProxy)jComponent).getDockingPanel();
            XDockableTransferHandler.transferDockable.header.showDock(jComponent, xDockingPanel);
            return true;
        }
        return false;
    }

    private class XDockableTransferable
    implements Transferable {
        XDockableTransferable(XDockable xDockable) {
            transferDockable = xDockable;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return transferDockable;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{dockableFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dockableFlavor.equals(dataFlavor);
        }
    }
}

