/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing.docking;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.TransferHandler;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicButtonUI;
import net.xoetrope.swing.docking.XCardPanel;
import net.xoetrope.swing.docking.XDockable;
import net.xoetrope.swing.docking.XDockableTransferHandler;

public class XDockableHeader
extends JLabel
implements MouseListener,
MouseMotionListener,
ActionListener {
    public static final int BUTTON_SIZE = 8;
    private static final int NORMAL = 0;
    private static final int ROLLOVER = 1;
    private static final int PRESSED = 2;
    private static final int NUM_BUTTON_STATES = 3;
    public static final int MINIMIZE = 0;
    public static final int ZOOM = 1;
    public static final int CLOSE = 2;
    public static final int RESTORE = 3;
    public static final int NUM_IMAGE_TYPES = 4;
    private static Image[] buttonImages;
    private static Color activeColor;
    private static Color activeTextColor;
    private static Color pressedTextColor;
    private static Color headerTextColor;
    private static Color headerBkColor;
    private static boolean useGradientHeaders;
    private MouseEvent firstMouseEvent = null;
    private XDockable dockable;
    private boolean active;
    private Container glassPane;
    private JButton sysMinimizeBtn;
    private JButton sysCloseBtn;
    private JButton sysZoomBtn;
    private JPanel buttonPanel;
    private Method clipIfNecessary;
    private int minHeaderHeight = 2;

    public XDockableHeader(XDockable xDockable, Color[] colorArray, String[] stringArray) {
        this.dockable = xDockable;
        if (xDockable.icon != null) {
            int n = xDockable.icon.getIconHeight();
            this.minHeaderHeight = Math.max(n + 6, this.minHeaderHeight);
        }
        this.active = true;
        if (colorArray != null) {
            headerBkColor = colorArray[0];
            headerTextColor = colorArray[1];
            activeColor = colorArray[2];
            activeTextColor = colorArray[3];
            pressedTextColor = colorArray[4];
        } else {
            XDockableHeader cfr_ignored_0 = xDockable.header;
            XDockableHeader cfr_ignored_1 = xDockable.header;
            XDockableHeader cfr_ignored_2 = xDockable.header;
            XDockableHeader cfr_ignored_3 = xDockable.header;
            XDockableHeader cfr_ignored_4 = xDockable.header;
        }
        if (stringArray == null) {
            stringArray = new String[]{xDockable.header.sysMinimizeBtn.getToolTipText(), xDockable.header.sysZoomBtn.getToolTipText(), xDockable.header.sysCloseBtn.getToolTipText()};
        }
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(1, 3, 1, 3));
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout());
        this.buttonPanel.setOpaque(false);
        if (buttonImages == null) {
            buttonImages = new Image[12];
        }
        this.sysMinimizeBtn = new JButton();
        this.buttonPanel.add(this.sysMinimizeBtn);
        this.setButtonProperties(this.sysMinimizeBtn, 0, stringArray[0], xDockable.canMinimize);
        this.sysZoomBtn = new JButton();
        this.buttonPanel.add(this.sysZoomBtn);
        this.setButtonProperties(this.sysZoomBtn, 1, stringArray[1], xDockable.canZoom);
        this.sysCloseBtn = new JButton();
        this.buttonPanel.add(this.sysCloseBtn);
        this.setButtonProperties(this.sysCloseBtn, 2, stringArray[2], xDockable.canClose);
        this.add((Component)this.buttonPanel, "East");
        this.setTransferHandler(new XDockableTransferHandler(xDockable.dockedContainer));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    protected void setButtonProperties(JButton jButton, int n, String string, boolean bl) {
        jButton.setToolTipText(string);
        jButton.setIcon(new ImageIcon(this.getImage(n, 0)));
        jButton.setPressedIcon(new ImageIcon(this.getImage(n, 2)));
        jButton.setRolloverIcon(new ImageIcon(this.getImage(n, 1)));
        jButton.setPreferredSize(new Dimension(8, 8));
        jButton.setBackground(headerBkColor);
        jButton.setOpaque(false);
        jButton.setBorderPainted(false);
        jButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        jButton.setUI(new BasicButtonUI());
        jButton.addActionListener(this);
        jButton.setVisible(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.sysZoomBtn) {
            int n = 3;
            if (this.isZoomed()) {
                n = 1;
            }
            this.setZoomState(n);
            this.zoomPanel();
        } else {
            this.dockable.dockedContainer.removeDockable(this.dockable, actionEvent.getSource() == this.sysMinimizeBtn);
        }
    }

    public XDockable getDockable() {
        return this.dockable;
    }

    public void setActive(boolean bl) {
        this.getComponent(0).setVisible(bl);
        this.active = bl;
        this.repaint();
    }

    public void setCanClose(boolean bl) {
        this.dockable.canClose = bl;
        this.sysCloseBtn.setVisible(bl);
    }

    public boolean getCanClose() {
        return this.dockable.canClose;
    }

    public void setCanMinimize(boolean bl) {
        this.dockable.canMinimize = bl;
        this.sysMinimizeBtn.setVisible(bl);
    }

    public boolean getCanMinimize() {
        return this.dockable.canMinimize;
    }

    public void setCanDockClose(boolean bl) {
        this.dockable.canDock = bl;
    }

    public boolean getCanDock() {
        return this.dockable.canDock;
    }

    public void setCanDrag(boolean bl) {
        this.dockable.canDrag = bl;
    }

    public boolean getCanDrag() {
        return this.dockable.canDrag;
    }

    public void setCanZoom(boolean bl) {
        this.dockable.canZoom = bl;
    }

    public boolean getCanZoom() {
        return this.dockable.canZoom;
    }

    public Insets getInsets() {
        return new Insets(2, 4, 2, 4);
    }

    public void setZoomState(int n) {
        this.sysZoomBtn.setIcon(new ImageIcon(this.getImage(n, 0)));
        this.sysZoomBtn.setPressedIcon(new ImageIcon(this.getImage(n, 2)));
        this.sysZoomBtn.setRolloverIcon(new ImageIcon(this.getImage(n, 1)));
    }

    public void zoomPanel() {
        XCardPanel xCardPanel = this.dockable.getCardPanel();
        if (xCardPanel != null) {
            xCardPanel.swapViews(this.dockable);
            this.dockable.header.setZoomState(xCardPanel.isZoomed() ? 3 : 1);
            this.dockable.dockedContainer.fireDockingPanelListeners(xCardPanel.isZoomed() ? 1 : 5);
        }
    }

    public boolean isZoomed() {
        XCardPanel xCardPanel = this.dockable.getCardPanel();
        if (xCardPanel != null) {
            return xCardPanel.isZoomed();
        }
        return false;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(Math.max(20, dimension.width), Math.min(35, Math.max(this.minHeaderHeight, dimension.height)));
    }

    public void paintComponent(Graphics graphics) {
        int n;
        Object object;
        Rectangle rectangle = this.getBounds();
        Color color = headerBkColor;
        graphics.setColor(color);
        if (useGradientHeaders && graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            float f = (float)rectangle.height / 4.0f;
            f = f * f / (float)rectangle.width;
            object = new GradientPaint(0.0f, 0.0f, XDockableHeader.brightenColor(color, 110), f, 3.0f * (float)rectangle.height / 4.0f, XDockableHeader.brightenColor(color, 90), true);
            graphics2D.setPaint((Paint)object);
            graphics2D.fill(new Rectangle(0, 0, rectangle.width, rectangle.height));
            graphics2D.draw3DRect(0, 0, rectangle.width - 1, rectangle.height - 1, true);
        } else {
            graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        }
        if (this.active) {
            int n2 = activeColor.getRed();
            int n3 = activeColor.getGreen();
            int n4 = activeColor.getBlue();
            graphics.setColor(activeColor.brighter());
            graphics.drawLine(0, 0, rectangle.width - 1, 0);
            graphics.drawLine(rectangle.width - 1, 0, rectangle.width - 1, 2);
            graphics.drawLine(0, 0, 0, 2);
            graphics.setColor(activeColor);
            graphics.setColor(new Color(n2, n3, n4, 223));
            graphics.drawLine(1, 1, rectangle.width - 2, 1);
            graphics.setColor(new Color(n2, n3, n4, 128));
            graphics.drawLine(1, 2, rectangle.width - 2, 2);
        }
        int n5 = 0;
        if (this.dockable.icon != null) {
            n = this.dockable.icon.getIconHeight();
            graphics.drawImage(this.dockable.icon.getImage(), 5, (rectangle.height - n) / 2, this);
            n5 = 8 + this.dockable.icon.getIconWidth();
        } else {
            for (n = 0; n < 3; ++n) {
                graphics.setColor(new Color(255, 255, 255, 200));
                graphics.fillRect(4, 6 + n * 4, 2, 2);
                graphics.setColor(new Color(0, 0, 0, 128));
                graphics.fillRect(3, 5 + n * 4, 2, 2);
            }
            n5 = 10;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.setColor(headerTextColor);
        object = graphics.getClip();
        int n6 = rectangle.width - (n5 + (this.active ? this.buttonPanel.getWidth() + 4 : 0));
        graphics.setClip(n5, 0, n6, rectangle.height);
        String string = this.getText();
        string = this.clipStringIfNecessary(this, fontMetrics, string, n6);
        graphics.drawString(string, n5, rectangle.height / 2 + fontMetrics.getDescent() + 1);
        graphics.setClip((Shape)object);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.firstMouseEvent = mouseEvent;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.zoomPanel();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.firstMouseEvent != null) {
            mouseEvent.consume();
            int n = 2;
            int n2 = Math.abs(mouseEvent.getX() - this.firstMouseEvent.getX());
            int n3 = Math.abs(mouseEvent.getY() - this.firstMouseEvent.getY());
            if ((n2 > 5 || n3 > 5) && this.dockable.canDrag) {
                JComponent jComponent = (JComponent)mouseEvent.getSource();
                TransferHandler transferHandler = jComponent.getTransferHandler();
                transferHandler.exportAsDrag(jComponent, this.firstMouseEvent, n);
                this.firstMouseEvent = null;
                this.glassPane = (Container)this.getRootPane().getGlassPane();
                this.glassPane.setVisible(true);
                this.dockable.dockedContainer.addDragProxies(this.glassPane);
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.endDock();
        this.dockable.dockedContainer.setActivateHeader(this);
    }

    public void showDock(JComponent jComponent, Container container) {
        if (this.glassPane != null) {
            for (Component component : this.glassPane.getComponents()) {
                ((JComponent)component).setBorder(component == jComponent ? new LineBorder(new Color(255, 0, 0, 128), 3) : null);
            }
        }
    }

    public void endDock() {
        if (this.glassPane != null) {
            this.glassPane.removeAll();
            this.glassPane.setVisible(false);
            this.glassPane = null;
        }
        this.firstMouseEvent = null;
    }

    private Image getImage(int n, int n2) {
        int n3 = n * 3 + n2;
        if (buttonImages[n3] == null) {
            XDockableHeader.buttonImages[n3] = new BufferedImage(8, 8, 2);
            Graphics2D graphics2D = (Graphics2D)buttonImages[n3].getGraphics();
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_RENDERING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setStroke(new BasicStroke(1.0f));
            for (int i = 0; i < 2; ++i) {
                RoundRectangle2D.Double double_;
                int n4;
                int n5 = i == 0 ? 0 : -1;
                int n6 = n4 = i == 0 ? 64 : 255;
                Color color = n2 == 1 ? activeTextColor : (n2 == 2 ? pressedTextColor : headerTextColor);
                int n7 = color.getRed();
                int n8 = color.getGreen();
                int n9 = color.getBlue();
                graphics2D.setColor(new Color(n7, n8, n9, n4));
                if (n == 0) {
                    double_ = new RoundRectangle2D.Double(1 + n5, 1 + n5 + 8 - 4, 6.0, 2.0, 2.0, 2.0);
                    graphics2D.draw(double_);
                    continue;
                }
                if (n == 2) {
                    graphics2D.drawLine(1 + n5, 1 + n5, 7 + n5, 7 + n5);
                    graphics2D.drawLine(7 + n5, 1 + n5, 1 + n5, 7 + n5);
                    continue;
                }
                if (n == 1) {
                    double_ = new RoundRectangle2D.Double(1 + n5, 1 + n5, 6.0, 6.0, 2.0, 2.0);
                    graphics2D.draw(double_);
                    continue;
                }
                if (n != 3) continue;
                double_ = new RoundRectangle2D.Double(1 + n5, 3 + n5, 5.0, 4.0, 2.0, 2.0);
                graphics2D.draw(double_);
                double_ = new RoundRectangle2D.Double(2 + n5, 1 + n5, 5.0, 4.0, 2.0, 2.0);
                graphics2D.draw(double_);
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, object);
            graphics2D.dispose();
        }
        return buttonImages[n3];
    }

    public static void setUseGradientHeaders(boolean bl) {
        useGradientHeaders = bl;
    }

    public static Color brightenColor(Color color, int n) {
        if (n == 100) {
            return color;
        }
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        return new Color(Color.HSBtoRGB(fArray[0], fArray[1], Math.min(1.0f, (float)n * fArray[2] / 100.0f)));
    }

    public String clipStringIfNecessary(JComponent jComponent, FontMetrics fontMetrics, String string, int n) {
        if (string == null || string.length() == 0) {
            return "";
        }
        try {
            Class<?> clazz = Class.forName("sun.swing.SwingUtilities2");
            Class[] classArray = new Class[]{JComponent.class, FontMetrics.class, String.class, Integer.TYPE};
            this.clipIfNecessary = clazz.getMethod("clipStringIfNecessary", classArray);
            if (this.clipIfNecessary != null) {
                Object[] objectArray = new Object[]{this, fontMetrics, string, new Integer(n)};
                string = (String)this.clipIfNecessary.invoke(null, objectArray);
                return string;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "";
    }

    static {
        useGradientHeaders = true;
    }
}

