/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing.dnd;

import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.Hashtable;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import net.xoetrope.swing.XImage;
import net.xoetrope.swing.XList;
import net.xoetrope.swing.dnd.XComponentTransferable;
import net.xoetrope.swing.dnd.XDragInfo;
import net.xoetrope.swing.dnd.XDragInfoTransferable;
import net.xoetrope.swing.dnd.XDragManager;
import net.xoetrope.swing.dnd.XModelTransfereable;
import net.xoetrope.xui.XPage;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.data.XDataBinding;
import net.xoetrope.xui.data.XModel;
import net.xoetrope.xui.data.XModelHelper;
import net.xoetrope.xui.registry.XRegistrationSetup;

public class XModelTransferHandler
extends TransferHandler
implements XRegistrationSetup {
    protected DataFlavor[] dataFlavors = new DataFlavor[3];

    public XModelTransferHandler() {
        try {
            this.dataFlavors[0] = new DataFlavor("application/x-xui-xmodeldockable");
            this.dataFlavors[1] = new DataFlavor("application/x-xui-xcomponent");
            this.dataFlavors[2] = new DataFlavor("application/x-xui-xdraginfo");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.dataFlavors;
    }

    public void setup(XProject xProject, Object object, Hashtable hashtable, Hashtable hashtable2) {
    }

    protected Transferable createTransferable(JComponent jComponent) {
        Container container;
        for (container = jComponent.getParent(); container != null && !(container instanceof XPage); container = container.getParent()) {
        }
        if (container != null) {
            if (container instanceof XDragManager) {
                XPage xPage = (XPage)container;
                String string = (String)xPage.getAttribute("dragInfo", jComponent.getName());
                if (string != null) {
                    XDragManager xDragManager = (XDragManager)((Object)container);
                    XDragInfo xDragInfo = xDragManager.getDragInfo(string);
                    return new XDragInfoTransferable(xDragInfo, this.dataFlavors[2]);
                }
            } else {
                XDataBinding xDataBinding = ((XPage)container).getBinding(jComponent);
                if (xDataBinding != null) {
                    xDataBinding.set();
                    DataFlavor[] dataFlavorArray = new DataFlavor[]{this.dataFlavors[0], this.dataFlavors[1]};
                    return new XModelTransfereable(xDataBinding.getSource(), xDataBinding.getOutput(), dataFlavorArray);
                }
                return new XComponentTransferable(jComponent, this.dataFlavors[1]);
            }
        }
        return null;
    }

    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        if (this.canImport(jComponent, transferable.getTransferDataFlavors())) {
            try {
                if (jComponent instanceof XImage) {
                    XModel[] xModelArray = (XModel[])transferable.getTransferData(this.dataFlavors[0]);
                    XModel xModel = xModelArray[0];
                    String string = xModelArray[1].get().toString();
                    XModel xModel2 = XModelHelper.getFirstChild(xModel, string);
                    ((XImage)jComponent).setAttribute("content", xModel2.getAttribValueAsString(xModel2.getAttribute("image")));
                } else if (jComponent instanceof XList) {
                    XDragInfo xDragInfo = (XDragInfo)transferable.getTransferData(this.dataFlavors[2]);
                    DefaultListModel defaultListModel = (DefaultListModel)((XList)jComponent).getModel();
                    defaultListModel.add(defaultListModel.getSize(), xDragInfo);
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                try {
                    Component component = (Component)transferable.getTransferData(this.dataFlavors[1]);
                    if (component instanceof XImage) {
                        ((XImage)jComponent).setImageName(((XImage)component).getImageName());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            int n = this.dataFlavors.length;
            for (int j = 0; j < n; ++j) {
                if (dataFlavorArray[i] == null || !dataFlavorArray[i].equals(this.dataFlavors[j])) continue;
                return true;
            }
        }
        return false;
    }
}

