/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing.deploy;

import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import javax.jnlp.ServiceManager;
import javax.jnlp.SingleInstanceListener;
import javax.jnlp.SingleInstanceService;
import javax.jnlp.UnavailableServiceException;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.xoetrope.debug.DebugLogger;
import net.xoetrope.swing.XActivation;
import net.xoetrope.xui.XProject;
import org.jdesktop.jdic.tray.SystemTray;
import org.jdesktop.jdic.tray.TrayIcon;

public class XSystemTrayManager
implements ActionListener,
SingleInstanceListener {
    private static XSystemTrayManager instance;
    private static TrayIcon trayIcon;
    private static XProject currentProject;
    private boolean stripSplashArgument = false;

    private XSystemTrayManager() {
        SingleInstanceService singleInstanceService;
        try {
            singleInstanceService = (SingleInstanceService)ServiceManager.lookup((String)"javax.jnlp.SingleInstanceService");
            singleInstanceService.addSingleInstanceListener((SingleInstanceListener)this);
        }
        catch (UnavailableServiceException unavailableServiceException) {
            DebugLogger.logWarning("The JNLP singleton service is not available");
        }
        if (trayIcon == null) {
            singleInstanceService = SystemTray.getDefaultSystemTray();
            trayIcon = new TrayIcon((Icon)currentProject.getIcon("xui_icon.png"), currentProject.getStartupParam("Title"));
            trayIcon.addActionListener((ActionListener)this);
            singleInstanceService.addTrayIcon(trayIcon);
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("Exit");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    currentProject.setStatus(4);
                    currentProject.setStartupParam("ExitOnClose", "true");
                    Window window = currentProject.getAppWindow();
                    if (window != null) {
                        window.dispatchEvent(new WindowEvent(window, 201));
                    }
                    window.dispose();
                    System.gc();
                }
            });
            JMenuItem jMenuItem2 = new JMenuItem("Open");
            jMenuItem2.addActionListener(this);
            jPopupMenu.add(jMenuItem2);
            jPopupMenu.addSeparator();
            jPopupMenu.add(jMenuItem);
            trayIcon.setPopupMenu(jPopupMenu);
        }
    }

    public static XSystemTrayManager getInstance(XProject xProject) {
        currentProject = xProject;
        if (instance == null) {
            instance = new XSystemTrayManager();
        }
        return instance;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Frame frame = currentProject.getAppFrame();
            if (frame != null && frame.isDisplayable()) {
                frame.setState(0);
                frame.toFront();
            } else {
                currentProject.setStatus(6);
                Class<?> clazz = Class.forName(currentProject.getStartupParam("MainClass").trim());
                Method method = clazz.getMethod("main", String[].class);
                String[] stringArray = (String[])currentProject.getObject("StartupArgs");
                method.invoke(null, new Object[]{stringArray});
            }
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Failed to invoke main method");
            internalError.initCause(exception);
            throw internalError;
        }
    }

    public void newActivation(String[] stringArray) {
        if (this.stripSplashArgument) {
            String[] stringArray2 = new String[stringArray.length - 1];
            for (int i = 1; i < stringArray.length; ++i) {
                stringArray2[i - 1] = stringArray[i];
            }
            stringArray = stringArray2;
        }
        currentProject.setObject("StartupArgs", stringArray);
        this.actionPerformed(null);
        this.showActivationEvent();
    }

    public void setStripSplashArgument(boolean bl) {
        this.stripSplashArgument = bl;
    }

    public void showActivationEvent() {
        XActivation xActivation = (XActivation)currentProject.getObject("ActivationObject");
        if (xActivation != null) {
            xActivation.activate();
        }
    }
}

