/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing.app;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.xoetrope.swing.SwingWidgetAdapter;
import net.xoetrope.swing.app.XDockableFrame;
import net.xoetrope.swing.docking.XCardPanel;
import net.xoetrope.swing.docking.XDockable;
import net.xoetrope.swing.docking.XDockingPanel;
import net.xoetrope.swing.docking.XDockingSideBar;
import net.xoetrope.xui.PageSupport;
import net.xoetrope.xui.XApplicationContext;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.XProjectManager;
import net.xoetrope.xui.XStartupObject;
import net.xoetrope.xui.helper.XTranslator;
import net.xoetrope.xui.style.XStyle;
import net.xoetrope.xui.style.XStyleEx;
import net.xoetrope.xui.style.XStyleManager;
import org.jdesktop.swingx.JXMultiSplitPane;
import org.jdesktop.swingx.MultiSplitLayout;
import org.jdesktop.swingx.painter.Painter;

public class XDockingApp
extends JFrame
implements XStartupObject {
    protected XApplicationContext applicationContext;
    protected XCardPanel cardPanel;
    protected JPanel dockingPanel;
    protected JXMultiSplitPane multiSplitPane;
    protected XDockingSideBar leftSidebar;
    protected XDockingSideBar rightSidebar;
    protected XDockingSideBar bottomSidebar;
    protected PageSupport northDecoration;
    protected JMenuBar menuBar;
    protected XProject currentProject = XProjectManager.getCurrentProject(this);
    protected String defaultLayoutDef = "(COLUMN  (ROW name=top weight=0.7    (LEAF name=left weight=0.1)    (LEAF weight=0.8 name=content)    (LEAF name=right weight=0.1) )  (LEAF name=bottom weight=0.3))";
    private boolean exclusiveView;

    public static void main(String[] stringArray) {
        final String[] stringArray2 = stringArray;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                XDockingApp.createAndShowGUI(stringArray2);
            }
        });
    }

    public XDockingApp(String[] stringArray) {
        super("XUI");
        this.dockingPanel = new JPanel();
        this.dockingPanel.setLayout(new BorderLayout());
        Container container = (Container)this.getRootPane().getGlassPane();
        this.leftSidebar = new XDockingSideBar(container, "west");
        this.rightSidebar = new XDockingSideBar(container, "east");
        this.bottomSidebar = new XDockingSideBar(container, "south");
        MultiSplitLayout.Node node = MultiSplitLayout.parseModel((String)this.defaultLayoutDef);
        this.multiSplitPane = new JXMultiSplitPane();
        this.multiSplitPane.setDividerSize(5);
        this.multiSplitPane.getMultiSplitLayout().setModel(node);
        MultiSplitLayout multiSplitLayout = this.multiSplitPane.getMultiSplitLayout();
        multiSplitLayout.setLayoutMode(2);
        multiSplitLayout.layoutByWeight((Container)this.multiSplitPane);
        this.cardPanel = new XCardPanel(this.multiSplitPane);
        this.dockingPanel.add((Component)this.leftSidebar, "West");
        this.dockingPanel.add((Component)this.rightSidebar, "East");
        this.dockingPanel.add((Component)this.bottomSidebar, "South");
        this.dockingPanel.add((Component)this.cardPanel, "Center");
        this.setContentPane(this.dockingPanel);
        SwingWidgetAdapter.getInstance();
        this.applicationContext = new XApplicationContext(this, "net.xoetrope.swing.app.XDockableFrame", stringArray);
        XStyleManager xStyleManager = this.currentProject.getStyleManager();
        if (xStyleManager.hasStyle("dockingApp")) {
            XStyle xStyle = xStyleManager.getStyle("dockingApp");
            this.multiSplitPane.setBackground(xStyle.getStyleAsColor(4));
            XStyleEx xStyleEx = (XStyleEx)xStyle;
            int n = xStyleEx.getStyleIndex("padding");
            if (n > 0) {
                int n2 = new Integer(xStyleEx.getStyleValue(n).toString());
                this.multiSplitPane.setDividerSize(n2);
            }
        }
        this.applyStyles(this.leftSidebar);
        this.applyStyles(this.rightSidebar);
        this.applyStyles(this.bottomSidebar);
    }

    public void applyStyles(XDockingSideBar xDockingSideBar) {
        Color color = SystemColor.control;
        Color color2 = SystemColor.controlText;
        Color color3 = SystemColor.controlText;
        XStyleManager xStyleManager = this.currentProject.getStyleManager();
        if (xStyleManager.hasStyle("dockingSidebar")) {
            XStyle xStyle = xStyleManager.getStyle("dockingSidebar");
            color = xStyle.getStyleAsColor(4);
            color2 = xStyle.getStyleAsColor(5);
            xStyle = xStyleManager.getStyle("dockingSidebar/active");
            color3 = xStyle.getStyleAsColor(5);
        }
        xDockingSideBar.applyStyles(color, color2, color3);
    }

    public void setBackgroundPainter(Painter painter) {
        this.multiSplitPane.setBackgroundPainter(painter);
    }

    public XDockingSideBar getSidebar(String string) {
        String string2 = string.toLowerCase();
        if (string2.equals("south") || string2.equals("bottom")) {
            return this.bottomSidebar;
        }
        if (string2.equals("east") || string2.equals("right")) {
            return this.rightSidebar;
        }
        if (string2.equals("west") || string2.equals("left")) {
            return this.leftSidebar;
        }
        return null;
    }

    public void setDecorationsVisible(boolean bl) {
        this.leftSidebar.setVisible(bl);
        this.rightSidebar.setVisible(bl);
        this.bottomSidebar.setVisible(bl);
        if (this.northDecoration != null) {
            ((Component)((Object)this.northDecoration)).setVisible(bl);
        }
    }

    public Object displayDecoration(PageSupport pageSupport, String string) {
        return this.addDecoration(pageSupport, string);
    }

    public Object addDecoration(PageSupport pageSupport, String string) {
        String string2 = string.toLowerCase();
        if (string2.equals("north") || string2.equals("top")) {
            this.northDecoration = pageSupport;
            this.dockingPanel.add((Component)((Object)pageSupport), "North");
            return pageSupport;
        }
        return null;
    }

    public void setDecorationVisibility(String string, boolean bl) {
        Component component = null;
        String string2 = string.toLowerCase();
        if (string2.equals("north") || string2.equals("top")) {
            component = (Component)((Object)this.northDecoration);
        } else if (string2.equals("south") || string2.equals("bottom")) {
            component = this.bottomSidebar;
        } else if (string2.equals("east") || string2.equals("right")) {
            component = this.leftSidebar;
        } else if (string2.equals("west") || string2.equals("left")) {
            component = this.rightSidebar;
        }
        if (component != null) {
            component.setVisible(bl);
            this.doLayout();
        }
    }

    public void showExclusive(Object object, boolean bl) {
        this.exclusiveView = bl;
        this.setDecorationsVisible(!bl);
        XDockable xDockable = this.findDockable(object);
        if (xDockable != null) {
            xDockable.header.zoomPanel();
            xDockable.header.getParent().setVisible(!bl);
            Object object2 = this.currentProject.getObject("MenuBar");
            XStartupObject xStartupObject = this.currentProject.getStartupObject();
            if (bl) {
                xStartupObject.setApplicationMenuBar(null);
            } else {
                xStartupObject.setApplicationMenuBar(object2);
            }
        }
        this.cardPanel.doLayout();
        this.multiSplitPane.doLayout();
        this.repaint();
    }

    public String getWidgetClassPackage() {
        return "net.xoetrope.swing";
    }

    public String getParameter(String string) {
        return "";
    }

    public Object getContentPaneEx() {
        return this.multiSplitPane;
    }

    public Object getParentObject() {
        return super.getParent();
    }

    public URL getDocumentBase() {
        return null;
    }

    public void setupFrameset(Hashtable hashtable) {
        String string = (String)hashtable.get("config");
        if (string == null || string.length() == 0) {
            string = this.defaultLayoutDef;
        }
        MultiSplitLayout.Node node = MultiSplitLayout.parseModel((String)string);
        MultiSplitLayout multiSplitLayout = this.multiSplitPane.getMultiSplitLayout();
        multiSplitLayout.setModel(node);
        multiSplitLayout.layoutByWeight((Container)this.multiSplitPane);
    }

    public void refresh() {
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void setAppTitle(String string) {
        XTranslator xTranslator = this.currentProject.getTranslator();
        this.setTitle(xTranslator.translate(string));
    }

    public void setIcon(Image image) {
        this.setIconImage(image);
    }

    public void setupWindow(XApplicationContext xApplicationContext, XProject xProject, int n, int n2) {
        xProject.setStartupParam("MainClass", "net.xoetrope.swing.app.XDockingApp");
        this.setSize(n, n2);
        this.addWindowListener(xApplicationContext);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        String string = null;
        try {
            string = xProject.getStartupParam("CenterWin");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string != null && string.compareTo("true") == 0) {
            this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        }
        this.setVisible(true);
        xProject.setApplet(null);
        xProject.setStartupObject(this);
        xProject.setAppFrame(this);
        xProject.setAppWindow(this);
    }

    public Object getApplicationMenuBar() {
        if (this.menuBar == null) {
            this.menuBar = this.getJMenuBar();
        }
        return this.menuBar;
    }

    public void setApplicationMenuBar(Object object) {
        this.setJMenuBar((JMenuBar)object);
    }

    private static void createAndShowGUI(String[] stringArray) {
        XDockingApp xDockingApp = new XDockingApp(stringArray);
        xDockingApp.setDefaultCloseOperation(0);
        xDockingApp.setVisible(true);
    }

    public void saveLayout(OutputStream outputStream) {
        try {
            XMLEncoder xMLEncoder = new XMLEncoder(new BufferedOutputStream(outputStream));
            MultiSplitLayout.Node node = this.multiSplitPane.getMultiSplitLayout().getModel();
            xMLEncoder.writeObject(node);
            xMLEncoder.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadLayout(InputStream inputStream) {
        MultiSplitLayout multiSplitLayout = this.multiSplitPane.getMultiSplitLayout();
        try {
            XMLDecoder xMLDecoder = new XMLDecoder(new BufferedInputStream(inputStream));
            MultiSplitLayout.Node node = (MultiSplitLayout.Node)xMLDecoder.readObject();
            multiSplitLayout.setModel(node);
            multiSplitLayout.setFloatingDividers(false);
            xMLDecoder.close();
            this.multiSplitPane.setPreferredSize(node.getBounds().getSize());
            this.dockHiddenChildren();
        }
        catch (Exception exception) {
            MultiSplitLayout.Node node = MultiSplitLayout.parseModel((String)this.defaultLayoutDef);
            multiSplitLayout.setModel(node);
        }
    }

    public void restoreViews() {
        if (!this.exclusiveView) {
            this.cardPanel.restoreViews();
        }
    }

    public XDockable findDockable(Object object) {
        MultiSplitLayout multiSplitLayout = this.multiSplitPane.getMultiSplitLayout();
        int n = this.multiSplitPane.getComponentCount();
        for (int i = 0; i < n; ++i) {
            XDockable xDockable;
            Component component = this.multiSplitPane.getComponent(i);
            if (!(component instanceof XDockableFrame) || (xDockable = ((XDockableFrame)component).findDockable(object)) == null) continue;
            return xDockable;
        }
        XDockable xDockable = this.cardPanel.getDockable();
        if (xDockable != null && (xDockable.content == object || xDockable.dockedContainer == object || xDockable.header == object)) {
            return xDockable;
        }
        return null;
    }

    private void dockHiddenChildren() {
        MultiSplitLayout multiSplitLayout = this.multiSplitPane.getMultiSplitLayout();
        int n = this.multiSplitPane.getComponentCount();
        for (int i = 0; i < n; ++i) {
            MultiSplitLayout.Node node;
            Component component = this.multiSplitPane.getComponent(i);
            if (!(component instanceof XDockingPanel) || (node = multiSplitLayout.getNodeForComponent(component)).isVisible()) continue;
            ((XDockingPanel)component).dock();
        }
    }
}

