/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import net.xoetrope.swing.app.XDockingApp;
import net.xoetrope.swing.docking.XDockable;
import net.xoetrope.swing.docking.XDockingPanel;
import net.xoetrope.swing.util.XRoundOnTopBorder;
import net.xoetrope.xui.XContentHolder;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.XProjectManager;
import net.xoetrope.xui.helper.XTranslator;
import net.xoetrope.xui.style.XStyle;
import net.xoetrope.xui.style.XStyleEx;
import net.xoetrope.xui.style.XStyleManager;

public class XDockableFrame
extends XDockingPanel
implements XContentHolder {
    private String iconName;
    private String title;
    private String sidebar;
    private boolean minimized;
    private boolean maximized;
    private boolean clearState = true;
    private boolean canClose;
    private boolean canDock;
    private boolean canDrag;
    private boolean canZoom;
    private boolean canMinimize;
    private boolean hasDockingTitle;
    private Dimension preferredSize;
    private Hashtable nextAttributes;
    private XProject currentProject = XProjectManager.getCurrentProject();
    private ArrayList dockables;

    public XDockableFrame() {
        super((String)null);
        XStyleManager xStyleManager = this.currentProject.getStyleManager();
        if (xStyleManager.hasStyle("dockingPanel")) {
            XStyleEx xStyleEx;
            int n;
            XStyle xStyle = xStyleManager.getStyle("dockingPanel");
            if (xStyle instanceof XStyleEx && (n = (xStyleEx = (XStyleEx)xStyle).getStyleIndex("border")) > 0) {
                String string;
                Color color = xStyle.getStyleAsColor(5);
                Object object = xStyleEx.getStyleValue(n);
                if (object != null && "1".equals(string = object.toString())) {
                    this.setBorder(new XRoundOnTopBorder(color));
                }
            }
        } else {
            this.setBorder(new XRoundOnTopBorder(Color.black));
        }
        this.hasDockingTitle = true;
        this.canMinimize = true;
        this.canDrag = true;
        this.canDock = true;
        this.canClose = true;
        this.dockables = new ArrayList();
    }

    public void setContent(String string) {
    }

    public void setNextAttributes(Object object) {
        this.nextAttributes = (Hashtable)object;
    }

    public void setup(String string, int n, int n2, Hashtable hashtable) {
        this.setName(string);
        if (hashtable != null) {
            this.iconName = (String)hashtable.get("icon");
            this.title = (String)hashtable.get("title");
            this.sidebar = (String)hashtable.get("sidebar");
            String string2 = (String)hashtable.get("constraint");
            if (string2 != null) {
                this.setConstraint(string2);
            } else {
                this.setConstraint(string);
            }
            String string3 = (String)hashtable.get("minimized");
            if (string3 != null) {
                this.minimized = string3.equals("true");
            }
            if ((string3 = (String)hashtable.get("maximized")) != null) {
                this.maximized = string3.equals("true");
            }
            if ((string3 = (String)hashtable.get("canClose")) != null) {
                this.canClose = "true".equals(string3);
            }
            if ((string3 = (String)hashtable.get("canDock")) != null) {
                this.canDock = "true".equals(string3);
            }
            if ((string3 = (String)hashtable.get("canDrag")) != null) {
                this.canDrag = "true".equals(string3);
            }
            if ((string3 = (String)hashtable.get("canZoom")) != null) {
                this.canZoom = "true".equals(string3);
            }
            if ((string3 = (String)hashtable.get("canMinimize")) != null) {
                this.canMinimize = "true".equals(string3);
            }
            if ((string3 = (String)hashtable.get("hasDockingTitle")) != null) {
                this.hasDockingTitle = "true".equals(string3);
            }
            if ((string3 = (String)hashtable.get("clearState")) != null) {
                this.clearState = "true".equals(string3);
            }
        } else {
            this.setConstraint(string);
        }
        this.preferredSize = new Dimension(n, n2);
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public Object getChildComponent(int n) {
        return this.contentPane.getComponent(n);
    }

    public void remove(Object object) {
    }

    public Component add(Component component) {
        return component;
    }

    public void add(Object object, Object object2) {
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        if (this.nextAttributes != null) {
            object6 = (String)this.nextAttributes.get("title");
            if (object6 != null) {
                this.title = object6;
            }
            if ((object6 = (String)this.nextAttributes.get("sidebar")) != null) {
                this.sidebar = (String)this.nextAttributes.get("sidebar");
            }
            if ((object6 = (String)this.nextAttributes.get("icon")) != null) {
                this.iconName = object6;
            }
        }
        if ((object6 = this.findDockable(object)) == null) {
            object6 = new XDockable(this.getDockingApp().getSidebar(this.sidebar != null ? this.sidebar : this.getName()), this.title != null ? this.currentProject.getTranslator().translate(this.title) : this.getName());
        }
        this.dockables.add(object6);
        ((XDockable)object6).content = (Container)object;
        boolean bl = true;
        ((XDockable)object6).canClose = this.canClose;
        ((XDockable)object6).canMinimize = this.canMinimize;
        ((XDockable)object6).canDock = this.canDock;
        ((XDockable)object6).canDrag = this.canDrag;
        ((XDockable)object6).canZoom = this.canZoom;
        ((XDockable)object6).hasDockingTitle = this.hasDockingTitle;
        if (this.nextAttributes != null) {
            object5 = (Color[])this.nextAttributes.get("canMinimize");
            if (object5 != null && ((String)object5).length() > 0) {
                ((XDockable)object6).canMinimize = "true".equals(object5);
            }
            if ((object5 = (String)this.nextAttributes.get("canClose")) != null && ((String)object5).length() > 0) {
                ((XDockable)object6).canClose = "true".equals(object5);
            }
            if ((object5 = (String)this.nextAttributes.get("canDock")) != null && ((String)object5).length() > 0) {
                ((XDockable)object6).canDock = "true".equals(object5);
            }
            if ((object5 = (String)this.nextAttributes.get("canDrag")) != null && ((String)object5).length() > 0) {
                ((XDockable)object6).canDrag = "true".equals(object5);
            }
            if ((object5 = (String)this.nextAttributes.get("canZoom")) != null && ((String)object5).length() > 0) {
                ((XDockable)object6).canZoom = "true".equals(object5);
            }
            if ((object5 = (String)this.nextAttributes.get("hasDockingTitle")) != null && ((String)object5).length() > 0) {
                ((XDockable)object6).hasDockingTitle = "true".equals(object5);
            }
            if ((object5 = (String)this.nextAttributes.get("replace")) != null && ((String)object5).length() > 0) {
                bl = "true".equals(object5);
            }
            if ((object5 = (String)this.nextAttributes.get("state")) != null) {
                if (((String)object5).equals("minimized")) {
                    this.minimized = true;
                    this.maximized = false;
                } else if (((String)object5).equals("maximized")) {
                    this.maximized = true;
                    this.minimized = false;
                }
            }
        }
        if (this.iconName != null && this.iconName.length() > 0) {
            ((XDockable)object6).icon = (ImageIcon)this.currentProject.getIcon(this.iconName);
        }
        object5 = new Color[]{SystemColor.control.brighter(), SystemColor.controlText, Color.orange, object5[2], Color.red};
        XTranslator xTranslator = this.currentProject.getTranslator();
        XStyleManager xStyleManager = this.currentProject.getStyleManager();
        if (xStyleManager.hasStyle("dockingHeader")) {
            object4 = xStyleManager.getStyle("dockingHeader");
            object5[0] = ((XStyle)object4).getStyleAsColor(4);
            object5[1] = ((XStyle)object4).getStyleAsColor(5);
            object3 = xStyleManager.getStyle("dockingHeader/active");
            object5[2] = ((XStyle)object3).getStyleAsColor(4);
            object5[3] = ((XStyle)object3).getStyleAsColor(5);
        }
        object4 = new String[]{xTranslator != null ? xTranslator.translate("Minimize") : "Minimize", xTranslator != null ? xTranslator.translate("Zoom/Restore") : "Zoom/Restore", xTranslator != null ? xTranslator.translate("Close") : "Close"};
        super.addDockable((XDockable)object6, (Color[])object5, (String[])object4);
        if (bl && this.contentPane.getComponentCount() > 0) {
            object3 = this.findDockable(this.contentPane.getComponent(0));
            if (object3 != null && object3 != object6) {
                super.removeDockable((XDockable)object3, false);
            } else if (this.minimized) {
                ((XDockable)object6).dockedContainer.setVisible(true);
            }
        }
        object3 = object6;
        SwingUtilities.invokeLater(new Runnable((XDockable)object3){
            final /* synthetic */ XDockable val$thisDockable;
            {
                this.val$thisDockable = xDockable;
            }

            public void run() {
                if (XDockableFrame.this.minimized) {
                    this.val$thisDockable.dockedContainer.removeDockable(this.val$thisDockable, true);
                    if (XDockableFrame.this.clearState) {
                        XDockableFrame.this.minimized = false;
                    }
                } else if (XDockableFrame.this.maximized) {
                    this.val$thisDockable.header.zoomPanel();
                    if (XDockableFrame.this.clearState) {
                        XDockableFrame.this.maximized = false;
                    }
                }
            }
        });
    }

    public XDockable findDockable(Object object) {
        int n = this.dockables.size();
        for (int i = 0; i < n; ++i) {
            XDockable xDockable = (XDockable)this.dockables.get(i);
            if (xDockable.content != object && xDockable.dockedContainer != object && xDockable.header != object) continue;
            return xDockable;
        }
        return null;
    }

    public void zoomDockable(Object object) {
        XDockable xDockable = this.findDockable(object);
        xDockable.header.zoomPanel();
    }

    public XDockingApp getDockingApp() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof XDockingApp); container = container.getParent()) {
        }
        return (XDockingApp)container;
    }

    public boolean isParentOf(Component component) {
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (container != this) continue;
            return true;
        }
        return false;
    }
}

