/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.xoetrope.swing.dnd.XTransferHandlerFactory;
import net.xoetrope.swing.tree.XTreeModelAdapter;
import net.xoetrope.xui.XAttributedComponent;
import net.xoetrope.xui.XProjectManager;
import net.xoetrope.xui.data.XModel;
import net.xoetrope.xui.events.XHandlerInvoker;
import net.xoetrope.xui.events.XListenerHelper;
import net.xoetrope.xui.style.XStyleComponent;

public class XTree
extends JTree
implements XAttributedComponent,
TreeSelectionListener,
XListenerHelper,
XStyleComponent,
MouseListener {
    private XHandlerInvoker invoker;
    private XModel selectedNode;
    private XModel lastSelectedNode;
    private String styleName;

    public XTree() {
        this.setScrollsOnExpand(true);
        this.addTreeSelectionListener(this);
        this.addMouseListener(this);
    }

    public int setAttribute(String string, Object object) {
        String string2 = string.toLowerCase();
        String string3 = (String)object;
        String string4 = null;
        if (object != null) {
            string4 = string3.toLowerCase();
        }
        if (string2.equals("tooltip")) {
            this.setToolTipText(string3);
        } else if (string2.equals("dragenabled")) {
            boolean bl = "true".equals(string4);
            this.setDragEnabled(bl);
        } else {
            return -1;
        }
        return 0;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.invokeSelection();
    }

    private void invokeSelection() {
        this.getSelectedNode();
        if (this.selectedNode != null && this.invoker != null) {
            this.invoker.invoke();
        }
    }

    public XModel getSelectedNode() {
        TreePath treePath = this.getSelectionPath();
        if (treePath != null) {
            Object[] objectArray = treePath.getPath();
            if (objectArray != null && objectArray.length > 0) {
                Object object = objectArray[objectArray.length - 1];
                if (object instanceof XTreeModelAdapter) {
                    XTreeModelAdapter xTreeModelAdapter = (XTreeModelAdapter)objectArray[objectArray.length - 1];
                    this.selectedNode = xTreeModelAdapter.getModel();
                }
            } else {
                this.selectedNode = null;
            }
            return this.selectedNode;
        }
        return null;
    }

    public void addHandler(Object object, String string, String string2) throws NoSuchMethodException {
        this.invoker = new XHandlerInvoker(object, this, string2);
    }

    public void setStyle(String string) {
        this.styleName = string;
    }

    public String getStyleName() {
        return this.styleName;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.lastSelectedNode == this.getSelectedNode()) {
            this.invokeSelection();
        }
        this.lastSelectedNode = this.selectedNode;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void setDragEnabled(boolean bl) {
        TransferHandler transferHandler;
        XTransferHandlerFactory xTransferHandlerFactory;
        if (bl && (xTransferHandlerFactory = XTransferHandlerFactory.getInstance(XProjectManager.getCurrentProject())) != null && (transferHandler = xTransferHandlerFactory.getTransferHandler(this, null)) != null) {
            super.setDragEnabled(true);
            this.setTransferHandler(transferHandler);
            return;
        }
        super.setDragEnabled(false);
    }

    public TreePath findNearestPath(TreePath treePath) {
        Serializable serializable;
        if (treePath == null) {
            return null;
        }
        Object[] objectArray = treePath.getPath();
        Object[] objectArray2 = new Object[objectArray.length];
        TreeModel treeModel = this.getModel();
        Object object = treeModel.getRoot();
        if (object == null) {
            return null;
        }
        int n = 0;
        objectArray2[n++] = object;
        Object object2 = object;
        block0: for (int i = 1; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof XTreeModelAdapter)) continue;
            serializable = (XTreeModelAdapter)objectArray[i];
            XModel xModel = serializable.getModel();
            int n2 = treeModel.getChildCount(object2);
            for (int j = 0; j < n2; ++j) {
                XTreeModelAdapter xTreeModelAdapter;
                XModel xModel2;
                Object object3 = treeModel.getChild(object2, j);
                if (!(object3 instanceof XTreeModelAdapter) || !(xModel2 = (xTreeModelAdapter = (XTreeModelAdapter)object3).getModel()).getId().equals(xModel.getId())) continue;
                objectArray2[n++] = object3;
                object2 = object3;
                continue block0;
            }
        }
        if (n > 0) {
            Object[] objectArray3 = new Object[n];
            System.arraycopy(objectArray2, 0, objectArray3, 0, n);
            serializable = new TreePath(objectArray3);
            this.setSelectionPath((TreePath)serializable);
            this.scrollPathToVisible((TreePath)serializable);
            return serializable;
        }
        return treePath;
    }
}

