/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing;

import java.awt.Color;
import java.awt.Container;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import net.xoetrope.swing.XSwingTableModel;
import net.xoetrope.swing.table.GroupableTableHeader;
import net.xoetrope.xui.XAttributedComponent;
import net.xoetrope.xui.XModelHolder;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.XProjectManager;
import net.xoetrope.xui.data.XModel;
import net.xoetrope.xui.data.XRowSelector;
import net.xoetrope.xui.data.table.XTableModel;
import net.xoetrope.xui.events.XHandlerInvoker;
import net.xoetrope.xui.events.XListenerHelper;
import net.xoetrope.xui.style.XStyle;
import net.xoetrope.xui.style.XStyleComponent;
import net.xoetrope.xui.style.XStyleManager;

public class XTable
extends JTable
implements XAttributedComponent,
XModelHolder,
XStyleComponent,
XRowSelector,
XListenerHelper,
ListSelectionListener {
    protected XProject currentProject = XProjectManager.getCurrentProject();
    protected XModel model;
    protected boolean updateModelSelection = false;
    protected XHandlerInvoker invoker;
    protected int oldRowSelection = -1;
    protected boolean usesDatabase = false;
    protected String headerStyle;

    public XTable() {
        this.setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.getSelectionModel().addListSelectionListener(this);
    }

    protected JTableHeader createDefaultTableHeader() {
        return new GroupableTableHeader(this.columnModel);
    }

    public void update() {
        if (this.dataModel != null) {
            int n = this.getSelectedRow();
            this.updateTable();
            int n2 = this.getSelectedRow();
            if (n2 < 0 && n >= 0) {
                this.setSelectedRow(n);
            }
        }
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.model == null && this.getParent() instanceof JViewport) {
            return true;
        }
        return super.getScrollableTracksViewportHeight();
    }

    public void updateTable() {
        this.tableChanged(new TableModelEvent(this.dataModel));
    }

    public void addHandler(Object object, String string, String string2) throws NoSuchMethodException {
        this.invoker = new XHandlerInvoker(object, this, string2);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n;
        super.valueChanged(listSelectionEvent);
        if (this.model instanceof XRowSelector && (n = this.getSelectedRow()) >= 0) {
            if (this.updateModelSelection) {
                ((XRowSelector)((Object)this.model)).setSelectedRow(n);
            }
            if (this.oldRowSelection != n && this.invoker != null) {
                this.invoker.invoke();
            }
            this.oldRowSelection = n;
        }
    }

    public void setModel(XModel xModel) {
        this.model = xModel;
        if (this.model != null) {
            this.usesDatabase = this.model instanceof XTableModel;
            this.model.get();
            this.setModel(new XSwingTableModel(this.currentProject, this.model));
        }
    }

    public XModel getXModel() {
        return this.model;
    }

    public void setStyle(String string) {
        XStyleManager xStyleManager = this.currentProject.getStyleManager();
        XStyle xStyle = xStyleManager.getStyle(string);
        this.setForeground(xStyle.getStyleAsColor(5));
        this.setBackground(xStyle.getStyleAsColor(4));
        this.setFont(xStyleManager.getFont(xStyle));
    }

    public void setViewportBackground(Color color) {
        Container container = this.getParent();
        if (container instanceof JViewport) {
            container.setBackground(color);
        }
    }

    public void setHeaderStyle(String string) {
        if (string != null) {
            this.headerStyle = string;
            XStyleManager xStyleManager = this.currentProject.getStyleManager();
            XStyle xStyle = xStyleManager.getStyle(string);
            JTableHeader jTableHeader = this.getTableHeader();
            jTableHeader.setForeground(xStyle.getStyleAsColor(5));
            jTableHeader.setBackground(xStyle.getStyleAsColor(4));
            jTableHeader.setFont(xStyleManager.getFont(xStyle));
        }
    }

    public String getHeaderStyle() {
        return this.headerStyle;
    }

    public void setSelectedStyle(String string) {
        XStyle xStyle = this.currentProject.getStyleManager().getStyle(string);
        Color color = xStyle.getStyleAsColor(5);
        if (color != null) {
            this.setSelectionForeground(color);
        }
        if ((color = xStyle.getStyleAsColor(4)) != null) {
            this.setSelectionBackground(color);
        }
    }

    public void setBorderStyle(String string) {
    }

    public boolean isInteractiveTable() {
        return false;
    }

    public void setInteractiveTable(boolean bl) {
    }

    public void setSelectedRow(int n) {
        this.setRowSelectionInterval(n, n);
    }

    public void clearSelection() {
        this.oldRowSelection = -1;
        super.clearSelection();
    }

    public void setTranslated(boolean bl) {
        ((XSwingTableModel)this.getModel()).setTranslated(bl);
    }

    public boolean getTranslated() {
        return ((XSwingTableModel)this.getModel()).getTranslated();
    }

    public void first() {
        if (this.getRowCount() > 0) {
            this.setSelectedRow(0);
        }
    }

    public void prev() {
        int n = this.getSelectedRow() - 1;
        if (n >= 0) {
            this.setSelectedRow(n);
        }
    }

    public void next() {
        int n = this.getSelectedRow() + 1;
        if (n <= this.getRowCount() - 1) {
            this.setSelectedRow(n);
        }
    }

    public void last() {
        this.setSelectedRow(this.model.getNumChildren() - 1);
    }

    public void setUpdateModelSelection(boolean bl) {
        this.updateModelSelection = bl;
    }

    public void setColWidth(final int n, final int n2) {
        if (this.isShowing() && this.isVisible()) {
            DefaultTableColumnModel defaultTableColumnModel = (DefaultTableColumnModel)this.getColumnModel();
            TableColumn tableColumn = defaultTableColumnModel.getColumn(n);
            tableColumn.setMaxWidth(n2);
        } else {
            try {
                int n3 = n2;
                int n4 = n;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DefaultTableColumnModel defaultTableColumnModel = (DefaultTableColumnModel)XTable.this.getColumnModel();
                        TableColumn tableColumn = defaultTableColumnModel.getColumn(n);
                        tableColumn.setMaxWidth(n2);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int setAttribute(String string, Object object) {
        String string2 = string.toLowerCase();
        String string3 = (String)object;
        if (string2.equals("headingstyle") || string2.equals("headerstyle")) {
            this.setHeaderStyle(string3);
        } else if (string2.equals("selectionstyle")) {
            this.setSelectedStyle(string3);
        } else if (string2.equals("borderstyle")) {
            this.setBorderStyle(string3);
        } else if (string2.equals("border")) {
            if ("0".equals(string3)) {
                this.setBorder(new EmptyBorder(0, 0, 0, 0));
            }
        } else if (string2.equals("interactive")) {
            this.setInteractiveTable(string3.equals("true"));
        } else if (string2.equals("updatemodel")) {
            this.setUpdateModelSelection(string3.equals("true"));
        } else if (string2.equals("selectionmode")) {
            this.setSelectionMode(string3);
        } else if (string2.equals("grid")) {
            this.setShowGrid(object.toString().equals("true"));
        } else if (string2.equals("vertlines")) {
            this.setShowVerticalLines(object.toString().equals("true"));
        } else if (string2.equals("horzlines")) {
            this.setShowHorizontalLines(object.toString().equals("true"));
        } else {
            return -1;
        }
        return 0;
    }

    public void setSelectionMode(String string) {
        if (string.equals("multiple")) {
            this.setSelectionMode(2);
        } else if (string.equals("single")) {
            this.setSelectionMode(1);
        } else {
            this.setSelectionMode(0);
        }
    }

    public Object getValue(int n) {
        int n2 = this.getSelectedRow();
        return this.getValue(n2, n);
    }

    public Object getValue(int n, int n2) {
        XModel xModel = this.model.get(n + 0);
        XModel xModel2 = xModel.get(n2);
        if (xModel2 instanceof XModel) {
            return xModel2.get();
        }
        return xModel2;
    }

    public String getFieldValue(int n) {
        return (String)this.getValue(n);
    }

    public String getFieldValue(int n, int n2) {
        return (String)this.getValue(n, n2);
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        XModel xModel;
        String string;
        Object object = this.getValueAt(n, n2);
        if (object instanceof XModel && (string = (xModel = (XModel)object).getAttribValueAsString(xModel.getAttribute("editor"))) == null) {
            return super.getCellEditor(n, n2);
        }
        return null;
    }
}

