/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Hashtable;
import javax.swing.JTabbedPane;
import javax.swing.plaf.TabbedPaneUI;
import net.xoetrope.builder.XuiBuilder;
import net.xoetrope.xui.XAttributedComponent;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.XProjectManager;
import net.xoetrope.xui.helper.XuiUtilities;

public class XTabPanel
extends JTabbedPane
implements XAttributedComponent,
MouseMotionListener {
    private Cursor handCursor;
    private Cursor defaultCursor;
    protected XProject currentProject = XProjectManager.getCurrentProject();

    public XTabPanel() {
        this.defaultCursor = new Cursor(0);
        this.handCursor = new Cursor(12);
    }

    public Component add(Component component) {
        if (component.getClass().getName().indexOf("BasicTabbedPaneUI") >= 0) {
            return super.add(component);
        }
        String string = null;
        try {
            Hashtable hashtable = XuiBuilder.getCurrentAttributes();
            string = XuiUtilities.translate(this.currentProject, (String)hashtable.get("title"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addTab(string, component);
        return component;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.getTabCount();
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            TabbedPaneUI tabbedPaneUI = this.getUI();
            Rectangle rectangle = tabbedPaneUI.getTabBounds(this, i);
            if (n2 <= rectangle.x || n2 >= rectangle.x + rectangle.width || n3 <= rectangle.y || n3 >= rectangle.y + rectangle.height) continue;
            bl = true;
        }
        if (bl) {
            this.setCursor(this.handCursor);
        } else {
            this.setCursor(this.defaultCursor);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public int setAttribute(String string, Object object) {
        String string2 = string.toLowerCase();
        String string3 = (String)object;
        String string4 = null;
        if (object != null) {
            string4 = string3.toLowerCase();
        }
        if (string2.equals("tabcursor")) {
            if (string4.equals("true")) {
                this.addMouseMotionListener(this);
            }
        } else if (string2.equals("placement")) {
            if (string4.equals("top")) {
                this.setTabPlacement(1);
            } else if (string4.equals("bottom")) {
                this.setTabPlacement(3);
            } else if (string4.equals("left")) {
                this.setTabPlacement(2);
            } else if (string4.equals("right")) {
                this.setTabPlacement(4);
            }
        } else {
            return -1;
        }
        return 0;
    }
}

