/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing;

import java.util.Vector;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.data.XBaseModel;
import net.xoetrope.xui.data.XModel;
import net.xoetrope.xui.data.table.XTableModel;
import net.xoetrope.xui.helper.XTranslator;

class XSwingTableModel
implements TableModel {
    private XModel model;
    private Vector listeners;
    private boolean hasHeaderRow;
    private boolean usesDatabase;
    private boolean translateable;
    private XTranslator translator;

    public XSwingTableModel(XProject xProject, XModel xModel) {
        this.model = xModel;
        this.usesDatabase = this.model instanceof XTableModel;
        this.listeners = new Vector();
        this.hasHeaderRow = false;
        this.translateable = false;
        this.translator = xProject.getTranslator();
    }

    public void setTranslated(boolean bl) {
        this.translateable = bl;
    }

    public boolean getTranslated() {
        return this.translateable;
    }

    public int getRowCount() {
        if (this.hasHeaderRow) {
            return this.model.getNumChildren() - 1;
        }
        return this.model.getNumChildren();
    }

    public int getColumnCount() {
        if (this.model.getNumChildren() > 0) {
            XBaseModel xBaseModel;
            if (this.usesDatabase) {
                return this.model.getNumAttributes();
            }
            if (this.model instanceof XBaseModel && (xBaseModel = (XBaseModel)((XBaseModel)this.model).get(0)).getTagName().equals("th")) {
                this.hasHeaderRow = true;
                return xBaseModel.getNumChildren();
            }
        }
        return this.model.getNumAttributes();
    }

    public String getColumnName(int n) {
        if (this.hasHeaderRow && this.model instanceof XBaseModel) {
            XBaseModel xBaseModel = (XBaseModel)((XBaseModel)this.model).get(0);
            return xBaseModel.get(n).getAttribValueAsString(0);
        }
        return this.model.getAttribName(n);
    }

    public Class getColumnClass(int n) {
        return String.class;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public Object getValueAt(int n, int n2) {
        Object object = this.model.get(n + (this.hasHeaderRow ? 1 : 0)).get(n2).get();
        if (object instanceof String && this.translateable) {
            return this.translator.translate((String)object);
        }
        return object;
    }

    public void setValueAt(Object object, int n, int n2) {
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listeners.add(tableModelListener);
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listeners.remove(tableModelListener);
    }
}

