/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import net.xoetrope.swing.painter.XImagePainter;
import net.xoetrope.swing.painter.XTitlePainter;
import net.xoetrope.xui.XAttributedComponent;
import net.xoetrope.xui.XProjectManager;
import net.xoetrope.xui.helper.XuiUtilities;
import net.xoetrope.xui.style.XStyle;
import net.xoetrope.xui.style.XStyleManager;
import org.jdesktop.swingx.painter.Painter;

public class XPanel
extends JPanel
implements XAttributedComponent {
    public static final int BORDER_NONE = 0;
    public static final int BORDER_FLAT = 1;
    public static final int BORDER_BEVEL = 2;
    protected int drawFrame = 0;
    protected boolean usesLaf = false;
    protected boolean translucent = false;
    protected int arc = 0;
    protected int padding = 0;
    private Painter painter;

    public XPanel() {
        this.setLayout(null);
        this.setOpaque(true);
    }

    public void addNotify() {
        super.addNotify();
        this.invalidate();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Insets getInsets() {
        Insets insets = new Insets(this.padding, this.padding, this.padding, this.padding);
        if (this.getBorder() != null) {
            Insets insets2 = this.getBorder().getBorderInsets(this);
            insets = new Insets(insets.top + insets2.top, insets.left + insets2.left, insets.bottom + insets2.bottom, insets.right + insets2.right);
        }
        return insets;
    }

    public void paintComponent(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        Color color = this.getBackground();
        color = this.usesLaf ? color.brighter() : color.darker();
        if (this.isOpaque() || this.translucent) {
            if (this.usesLaf) {
                super.paintComponent(graphics);
            } else if (this.painter != null) {
                this.painter.paint((Graphics2D)graphics, (Object)this, n, n2);
            } else {
                graphics.setColor(this.getBackground());
                Insets insets = this.getInsets();
                if (this.arc <= 0) {
                    graphics.fillRect(0, 0, n, n2);
                } else {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Object object = graphics2D.getRenderingHint(RenderingHints.KEY_RENDERING);
                    graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    graphics2D.fillRoundRect(0, 0, n, n2, this.arc, this.arc);
                    graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, object);
                }
            }
        }
        if (this.drawFrame > 0) {
            if (this.drawFrame == 2) {
                graphics.setColor(Color.white);
                graphics.drawLine(0, 0, n - 1, 0);
                graphics.drawLine(0, 0, 0, n2 - 1);
                graphics.setColor(color);
                graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
                graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
            } else {
                graphics.setColor(color);
                if (this.arc <= 0) {
                    graphics.drawRect(0, 0, n - 1, n2 - 1);
                } else {
                    graphics.drawRoundRect(0, 0, n - 1, n2 - 1, this.arc, this.arc);
                }
            }
        }
    }

    public int getArc() {
        return this.arc;
    }

    public void setArc(int n) {
        this.arc = n;
    }

    public void setPainter(Painter painter) {
        this.painter = painter;
    }

    public Painter getPainter() {
        return this.painter;
    }

    public void setDrawFrame(int n) {
        this.drawFrame = n;
    }

    public void setUsesLaf(boolean bl) {
        this.usesLaf = bl;
    }

    public boolean getUsesLaf() {
        return this.usesLaf;
    }

    public int getDrawFrame() {
        return this.drawFrame;
    }

    public int setAttribute(String string, Object object) {
        String string2 = string.toLowerCase();
        String string3 = (String)object;
        String string4 = null;
        if (object != null) {
            string4 = string3.toLowerCase();
        }
        if (string4 == null) {
            return -1;
        }
        if (string2.equals("border")) {
            this.setDrawFrame(Integer.parseInt(string4));
        } else if (string2.equals("laf")) {
            this.setUsesLaf(string4.equals("true"));
        } else if (string2.equals("opaque")) {
            this.setOpaque(string4.equals("true"));
        } else if (string2.equals("translucent")) {
            this.translucent = string4.equals("true");
        } else if (string2.equals("arc")) {
            this.arc = Integer.parseInt(string3);
        } else if (string2.equals("pad")) {
            this.padding = Integer.parseInt(string3);
        } else if (string2.equals("buffered")) {
            this.setDoubleBuffered(object.equals("true"));
        } else if (string2.equals("tooltip")) {
            this.setToolTipText(string3);
        } else if (string2.equals("imagename")) {
            try {
                XImagePainter xImagePainter = new XImagePainter();
                xImagePainter.setImage(string3);
                this.setPainter(xImagePainter);
            }
            catch (Exception exception) {}
        } else if (string2.equals("painter")) {
            try {
                Painter painter = (Painter)Class.forName(string3.trim()).newInstance();
                this.setPainter(painter);
            }
            catch (Exception exception) {}
        } else if (this.painter != null) {
            if (this.painter instanceof XTitlePainter) {
                if (string2.equals("blend")) {
                    ((XTitlePainter)this.painter).setBlend(string4.equals("true"));
                } else if (string2.equals("title")) {
                    ((XTitlePainter)this.painter).setTitle(string3);
                } else if (string2.equals("titlepos")) {
                    ((XTitlePainter)this.painter).setTitlePosition(Integer.parseInt(string3));
                } else if (string2.equals("titlestyle")) {
                    XStyleManager xStyleManager = XProjectManager.getStyleManager();
                    XStyle xStyle = xStyleManager.getStyle(string3);
                    ((XTitlePainter)this.painter).setTitleColor(xStyle.getStyleAsColor(4));
                    ((XTitlePainter)this.painter).setTitleTextColor(xStyle.getStyleAsColor(5));
                    ((XTitlePainter)this.painter).setTitleFont(xStyleManager.getFont(string3));
                }
            }
        } else {
            return -1;
        }
        return 0;
    }

    public Dimension getPreferredSize() {
        if (this.getLayout() == null) {
            Point point = XuiUtilities.getMaxCoordinates(this);
            Point point2 = this.getLocation();
            point = new Point(point.x - point2.x, point.y - point2.y);
            if (this.getBorder() != null) {
                Insets insets = this.getBorder().getBorderInsets(this);
                point.setLocation(point.getX() + (double)insets.left + (double)insets.right, point.getY() + (double)insets.top + (double)insets.bottom);
            }
            if (point.x <= 0 || point.y <= 0) {
                return new Dimension(0, 0);
            }
            return new Dimension(point.x, point.y);
        }
        Dimension dimension = super.getPreferredSize();
        Insets insets = this.getInsets();
        dimension.setSize(dimension.getWidth() + (double)insets.left + (double)insets.right, dimension.getHeight() + (double)insets.top + (double)insets.bottom);
        return dimension;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n4 >= 0 && n3 >= 0) {
            super.setBounds(n, n2, n3, n4);
        }
    }
}

