/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.ScrollPane;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JPanel;
import net.xoetrope.debug.DebugLogger;
import net.xoetrope.xml.XmlElement;
import net.xoetrope.xml.XmlSource;
import net.xoetrope.xui.XAttributedComponent;
import net.xoetrope.xui.XMetaContentHolder;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.XProjectManager;
import net.xoetrope.xui.helper.XTranslator;
import net.xoetrope.xui.style.XStyle;
import net.xoetrope.xui.style.XStyleComponent;

public class XMetaContent
extends JPanel
implements XMetaContentHolder,
XStyleComponent,
XAttributedComponent {
    private Stack styleStack;
    private XmlElement content;
    private String strContent;
    private String source;
    private boolean usesLaf = false;
    private int currentX;
    private int currentY;
    private int width;
    private int height;
    private int startX;
    private int colStart;
    private XStyle currentStyle;
    private String currentStyleName = "";
    private Font font;
    private FontMetrics fontMetrics;
    private int fontHeight;
    private int contentHeight;
    private int padding;
    protected XTranslator translator;
    protected boolean antiAlias;
    protected static Hashtable methodTable = null;
    private static final int XSTYLE = 1;
    private static final int BR = 2;
    private static final int UL = 3;
    private static final int LI = 4;
    private static final int TABLE = 5;
    private static final int TR = 6;
    private static final int TD = 7;
    protected XProject currentProject = XProjectManager.getCurrentProject();

    public XMetaContent() {
        this.styleStack = new Stack();
        this.currentStyle = new XStyle();
        this.translator = this.currentProject.getTranslator();
        this.fillMethodTable();
    }

    protected void fillMethodTable() {
        if (methodTable == null) {
            methodTable = new Hashtable();
            methodTable.put("xstyle", new Integer(1));
            methodTable.put("br", new Integer(2));
            methodTable.put("ul", new Integer(3));
            methodTable.put("li", new Integer(4));
            methodTable.put("table", new Integer(5));
            methodTable.put("tr", new Integer(6));
            methodTable.put("td", new Integer(7));
        }
    }

    public void setFileName(String string) {
        try {
            if (string != null) {
                XmlElement xmlElement = XmlSource.read(this.currentProject.getBufferedReader(string, null));
                this.setContent(string, xmlElement);
            }
        }
        catch (Exception exception) {
            DebugLogger.logWarning("Unable to load content: " + string);
            DebugLogger.logWarning("Please check the case of the file name");
            exception.printStackTrace();
        }
    }

    public void setContent(String string) {
        if (this.strContent != null && this.strContent.indexOf("<?xml") == 0) {
            XmlElement xmlElement = XmlSource.read(new StringReader(string));
            this.setContent(string, xmlElement);
        } else if (string.indexOf(".xml") > 0) {
            this.setContent(string, null);
        } else {
            this.strContent = string;
            this.content = null;
            this.source = null;
            this.contentHeight = 0;
            this.padding = 2;
            this.calcSize();
            this.repaint();
        }
    }

    public void setContent(String string, XmlElement xmlElement) {
        if (string.indexOf("<?xml") == 0) {
            this.strContent = string;
        } else if (string.indexOf(".xml") > 0) {
            try {
                xmlElement = XmlSource.read(this.currentProject.getBufferedReader(string, null));
            }
            catch (Exception exception) {
                DebugLogger.logWarning("Unable to load content: " + string);
                DebugLogger.logWarning("Please check the case of the file name");
                exception.printStackTrace();
            }
        }
        this.source = string;
        this.content = xmlElement;
        this.contentHeight = 0;
        this.padding = 2;
        this.calcSize();
        this.repaint();
    }

    public String getFileName() {
        return this.source;
    }

    public String getContent() {
        if (this.source != null && this.source.indexOf("<?xml") == 0) {
            return this.source;
        }
        if (this.content != null) {
            return this.content.getName();
        }
        return this.strContent;
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.antiAlias ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.currentY = this.startX = this.padding;
        this.currentX = this.startX;
        this.height = this.getSize().height - 2 * this.padding;
        Color color = this.getBackground();
        color = this.usesLaf ? color.brighter() : color.darker();
        if (this.isOpaque()) {
            if (this.usesLaf) {
                super.paintComponent(graphics);
            } else {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
            }
        }
        try {
            if (this.content != null && this.content.getName().compareTo("XText") == 0) {
                this.font = graphics.getFont();
                if (this.font.getSize() == 0) {
                    this.font = new Font(null, 0, 12);
                }
                graphics.setFont(this.font);
                if (this.contentHeight == 0) {
                    this.calcSize();
                } else {
                    this.render(graphics, this.content);
                }
            } else if (this.content == null && this.strContent != null) {
                this.applyStyle(graphics);
                this.renderText(graphics, this.strContent);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = this.currentY + this.fontHeight + 2 * this.padding;
        if (n != this.contentHeight) {
            Container container = this.getParent();
            this.contentHeight = n;
            if (container instanceof ScrollPane) {
                this.setSize(this.getSize().width - 40, this.contentHeight);
                ((Component)container).doLayout();
            } else {
                this.repaint();
            }
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
    }

    public void setPadding(int n) {
        this.padding = n;
    }

    public void calcSize() {
        this.width = this.getSize().width;
        if (this.contentHeight == 0) {
            this.width -= 20;
        }
        this.contentHeight = -1;
        Image image = this.createImage(1, 1);
        if (image != null) {
            Graphics graphics = image.getGraphics();
            graphics.setClip(0, 0, this.width, this.height);
            this.paint(graphics);
            graphics.dispose();
        }
    }

    private void render(Graphics graphics, XmlElement xmlElement) {
        this.applyStyle(graphics);
        Vector vector = xmlElement.getChildren();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            XmlElement xmlElement2 = (XmlElement)vector.elementAt(i);
            int n2 = 0;
            String string = xmlElement2.getName();
            n2 = (Integer)methodTable.get(string.toLowerCase());
            if (!this.renderItem(graphics, xmlElement2, n2)) {
                this.renderText(graphics, xmlElement2.getContent());
            }
            this.pushStyle();
            this.render(graphics, xmlElement2);
            this.popStyle();
        }
    }

    protected boolean renderItem(Graphics graphics, XmlElement xmlElement, int n) {
        switch (n) {
            case 1: {
                this.setStyle(graphics, xmlElement.getContent(), xmlElement.getAttribute("name"));
                break;
            }
            case 2: {
                this.lineBreak(graphics);
                break;
            }
            case 3: {
                this.renderList(graphics);
                break;
            }
            case 4: {
                this.renderListItem(graphics, xmlElement.getContent());
                break;
            }
            case 5: {
                this.renderTable(graphics);
                break;
            }
            case 6: {
                this.renderTableRecord(graphics);
                break;
            }
            case 7: {
                this.renderTableCell(graphics, xmlElement.getContent(), xmlElement.getAttribute("width").toString());
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public void setStyle(String string) {
        this.currentStyle = XProjectManager.getStyleManager().getStyle(string);
    }

    private void setStyle(Graphics graphics, String string, String string2) {
        if (string2.compareTo(this.currentStyleName) != 0) {
            this.currentStyle = XProjectManager.getStyleManager().getStyle(string2);
            this.currentStyleName = string2;
            this.applyStyle(graphics);
        }
        this.renderText(graphics, string);
    }

    private void applyStyle(Graphics graphics) {
        graphics.setColor(this.currentStyle.getStyleAsColor(5));
        try {
            this.font = XProjectManager.getStyleManager().getFont(this.currentStyle);
        }
        catch (Exception exception) {
            this.font = new Font("Arial", 0, 12);
        }
        if (this.font != null) {
            graphics.setFont(this.font);
        }
        this.fontMetrics = graphics.getFontMetrics();
        this.fontHeight = this.fontMetrics.getHeight();
    }

    private void pushStyle() {
        this.styleStack.push(this.currentStyle.clone());
    }

    private void popStyle() {
        this.currentStyle = (XStyle)this.styleStack.pop();
    }

    private void renderText(Graphics graphics, String string) {
        graphics.setColor(this.currentStyle.getStyleAsColor(4));
        if (string == null) {
            return;
        }
        int n = string.indexOf("${");
        int n2 = string.indexOf("}", n);
        while (n > -1) {
            String string2 = string.substring(n + 2, n2);
            String string3 = string.substring(0, n);
            string3 = string3 + this.translator.translate(string2);
            string = string3 = string3 + string.substring(n2 + 1, string.length());
            n = string.indexOf("${");
            n2 = string.indexOf("}", n);
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        boolean bl = false;
        do {
            String string4;
            boolean bl2 = false;
            if ((n4 = string.indexOf(32, n4 + 1)) > 0) {
                string4 = string.substring(n3, n4);
            } else {
                string4 = string.substring(n3);
                bl2 = true;
            }
            if (this.currentX + this.fontMetrics.stringWidth(string4) > this.width) {
                int n6 = string4.lastIndexOf(32);
                n4 = n3 + n6;
                if (n6 < 0) {
                    n4 += string4.length();
                } else {
                    string4 = n4 >= 0 ? string.substring(n3, n4) : string.substring(n3);
                }
                bl2 = true;
                bl = true;
            }
            if (!bl2) continue;
            graphics.setColor(this.getBackground());
            graphics.fillRect(this.currentX, this.currentY, this.fontMetrics.stringWidth(string4) + 1, this.fontHeight + 1);
            graphics.setColor(this.getForeground());
            graphics.drawString(string4, this.currentX, this.currentY + this.fontMetrics.getAscent());
            this.currentX += this.fontMetrics.stringWidth(string4);
            n3 = n4 + 1;
            ++n5;
            if (!bl) continue;
            this.currentY += this.fontHeight;
            this.currentX = this.startX;
            bl = false;
        } while (n4 >= 0);
        if (n3 == 0 && n5 == 1) {
            graphics.drawString(string, this.currentX, this.fontMetrics.getAscent());
        }
    }

    private void renderList(Graphics graphics) {
        this.lineBreak(graphics);
    }

    private void renderListItem(Graphics graphics, String string) {
        int n = this.startX;
        int n2 = this.fontHeight / 4;
        this.currentY += this.fontHeight / 2;
        this.startX += 2 * this.fontHeight;
        this.lineBreak(graphics);
        graphics.fillOval(this.startX - this.fontHeight / 2, this.currentY + this.fontHeight / 2, n2, n2);
        this.renderText(graphics, string);
        this.startX = n;
    }

    private void renderTable(Graphics graphics) {
        this.startX += 2 * this.fontHeight;
        this.colStart = this.startX;
        this.lineBreak(graphics);
    }

    private void renderTableRecord(Graphics graphics) {
        this.lineBreak(graphics);
        this.currentX = this.startX = this.colStart;
    }

    private void renderTableCell(Graphics graphics, String string, String string2) {
        this.renderText(graphics, string);
        this.startX += Integer.parseInt(string2);
        this.currentX = this.startX;
    }

    private void lineBreak(Graphics graphics) {
        this.currentY += this.fontHeight;
        this.currentX = this.startX;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.doLayout();
        if (n3 != this.width || this.height != n4) {
            this.calcSize();
        }
    }

    public void setUsesLaf(boolean bl) {
        this.usesLaf = bl;
    }

    public int setAttribute(String string, Object object) {
        String string2 = string.toLowerCase();
        String string3 = ((String)object).toLowerCase();
        if (string2.equals("laf")) {
            if (string3 != null) {
                this.setUsesLaf(string3.equals("true"));
            }
        } else if (string2.equals("opaque")) {
            if (string3 != null) {
                this.setOpaque(string3.equals("true"));
            } else if (string2.equals("antialias")) {
                this.antiAlias = object.equals("true");
            }
        } else {
            return -1;
        }
        return 0;
    }
}

