/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JLabel;
import javax.swing.Scrollable;
import javax.swing.text.View;
import net.xoetrope.xui.XAttributedComponentEx;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.XProjectManager;
import net.xoetrope.xui.XTextHolder;
import net.xoetrope.xui.XTextRenderer;

public class XLabel
extends JLabel
implements XTextHolder,
XAttributedComponentEx,
Scrollable {
    private XProject currentProject;
    protected XTextRenderer renderer = new XTextRenderer();
    protected boolean antiAlias;

    public XLabel() {
        this.currentProject = XProjectManager.getCurrentProject();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void addNotify() {
        super.addNotify();
        this.repaint(0L);
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = null;
        object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.antiAlias ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        View view = (View)this.getClientProperty("html");
        if (view != null) {
            Dimension dimension = this.getSize();
            Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
            view.paint(graphics, rectangle);
        } else if (this.renderer != null) {
            this.renderer.setTransparent(!this.isOpaque());
            Insets insets = new Insets(0, 0, 0, 0);
            if (this.getBorder() != null) {
                insets = this.getBorder().getBorderInsets(this);
            }
            this.renderer.paintText(this, graphics, insets, this.getText());
        } else {
            super.paintComponent(graphics);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        super.paintChildren(graphics);
    }

    public int getAlignment() {
        return this.getHorizontalAlignment();
    }

    public void setAlignment(int n) {
        this.setHorizontalAlignment(n);
    }

    public int getHorizontalAlignment() {
        if (this.renderer != null) {
            return this.renderer.getHorizontalAlignment();
        }
        return super.getHorizontalAlignment();
    }

    public void setHorizontalAlignment(int n) {
        if (this.renderer != null) {
            this.renderer.setHorizontalAlignment(n);
        } else {
            super.setHorizontalAlignment(n);
        }
    }

    public int getVerticalAlignment() {
        if (this.renderer != null) {
            return this.renderer.getVerticalAlignment();
        }
        return super.getVerticalAlignment();
    }

    public void setVerticalAlignment(int n) {
        if (this.renderer != null) {
            this.renderer.setVerticalAlignment(n);
        } else {
            super.setVerticalAlignment(n);
        }
    }

    public void setTransparent(boolean bl) {
        this.renderer.setTransparent(bl);
    }

    public int setAttribute(String string, Object object) {
        return this.setAttribute(null, string, object);
    }

    public int setAttribute(XProject xProject, String string, Object object) {
        String string2 = string.toLowerCase();
        String string3 = (String)object;
        String string4 = null;
        if (object != null) {
            string4 = string3.toLowerCase();
        }
        if (string2.equals("align") || string2.equals("alignment")) {
            if (string4.equals("right")) {
                if (this.renderer != null) {
                    this.setAlignment(1);
                } else {
                    super.setHorizontalAlignment(4);
                }
            } else if (string4.equals("center")) {
                if (this.renderer != null) {
                    this.setAlignment(2);
                } else {
                    super.setHorizontalAlignment(0);
                }
            } else if (this.renderer != null) {
                this.setAlignment(0);
            } else {
                super.setHorizontalAlignment(2);
            }
        } else if (string2.equals("buffered")) {
            this.setDoubleBuffered(string4.equals("true"));
        } else if (string2.equals("opaque")) {
            this.setOpaque(object.equals("true"));
        } else if (string2.equals("tooltip")) {
            this.setToolTipText((String)object);
        } else if (string2.equals("antialias")) {
            this.antiAlias = object.equals("true");
        } else if (string2.equals("userenderer")) {
            this.renderer = new XTextRenderer();
        } else if (string2.equals("content")) {
            String string5 = object.toString();
            if (xProject != null) {
                string5 = xProject.getTranslator().translate(string5);
            }
            this.setText(string5);
        } else {
            return -1;
        }
        return 0;
    }

    public Dimension getPreferredSize() {
        String string = this.getText();
        if (string != null && string.length() > 0) {
            return super.getPreferredSize();
        }
        View view = (View)this.getClientProperty("html");
        if (view != null) {
            return super.getPreferredSize();
        }
        Dimension dimension = this.renderer.getPreferredSize(this, string);
        if (this.getBorder() != null) {
            Insets insets = this.getBorder().getBorderInsets(this);
            dimension.setSize(dimension.getWidth() + (double)insets.left + (double)insets.right, dimension.getHeight() + (double)insets.top + (double)insets.bottom);
        }
        return dimension;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 10;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 100;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }
}

