/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.View;
import net.xoetrope.xui.XAttributedComponent;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.XProjectManager;
import net.xoetrope.xui.XTextRenderer;
import net.xoetrope.xui.helper.XuiUtilities;
import org.jdesktop.swingx.painter.Painter;

public class XImageButton
extends JToggleButton
implements XAttributedComponent,
MouseListener {
    private Image image = null;
    private Image pressedImage = null;
    private Image rolloverImage = null;
    private Image disabledImage = null;
    private ImageIcon iconImage = null;
    private String imageName;
    private String rolloverImageName;
    private String pressedImageName;
    private String disabledImageName;
    private String iconName;
    protected boolean antiAlias;
    private boolean vertical;
    protected XTextRenderer textRenderer = null;
    private Painter painter;
    protected XProject currentProject = XProjectManager.getCurrentProject();

    public XImageButton() {
        this.setUI(new BasicButtonUI());
        this.addMouseListener(this);
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setRolloverEnabled(true);
        this.setDoubleBuffered(true);
    }

    public void paintComponent(Graphics graphics) {
        Object object;
        Object object2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object3 = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.antiAlias ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        Color color = this.getBackground();
        graphics.setColor(color);
        Dimension dimension = this.getSize();
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (this.painter != null) {
            this.painter.paint((Graphics2D)graphics, (Object)this, n, n2);
        } else {
            if (this.isOpaque()) {
                graphics.fillRect(0, 0, n, n2);
            }
            if (!(object2 = this.getModel()).isEnabled()) {
                if (this.disabledImage == null) {
                    object = graphics2D.getPaint();
                    graphics2D.setPaint(new Color(color.getRed(), color.getGreen(), color.getBlue(), 128));
                    graphics.drawImage(this.image, 0, 0, dimension.width, dimension.height, null);
                    graphics.fillRect(0, 0, dimension.width, dimension.height);
                    graphics2D.setPaint((Paint)object);
                } else {
                    graphics.drawImage(this.disabledImage, 0, 0, dimension.width, dimension.height, null);
                }
            } else if (object2.isRollover()) {
                if (object2.isPressed() && this.pressedImage != null) {
                    graphics.drawImage(this.pressedImage, 0, 0, dimension.width, dimension.height, null);
                } else if (this.rolloverImage != null) {
                    graphics.drawImage(this.rolloverImage, 0, 0, dimension.width, dimension.height, null);
                }
            } else if (this.image != null) {
                graphics.drawImage(this.image, 0, 0, dimension.width, dimension.height, null);
            }
            if (this.iconImage != null) {
                int n3 = this.iconImage.getImage().getWidth(null);
                int n4 = this.iconImage.getImage().getHeight(null);
                graphics.drawImage(this.iconImage.getImage(), 10, (n2 - n4) / 2, n3, n4, null);
            }
        }
        object2 = this.getText();
        if (object2 != null && ((String)object2).length() > 0) {
            object = Toolkit.getDefaultToolkit().getFontMetrics(graphics.getFont());
            if (this.isEnabled()) {
                graphics.setColor(this.getForeground());
            } else {
                graphics.setColor(this.getBackground().brighter());
            }
            View view = (View)this.getClientProperty("html");
            Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
            Rectangle rectangle2 = new Rectangle(0, 0, dimension.width, dimension.height);
            Rectangle rectangle3 = new Rectangle(0, 0, dimension.width, dimension.height);
            Insets insets = super.getInsets();
            rectangle3.x = insets.left;
            rectangle3.y = insets.top;
            rectangle3.width = this.getWidth() - (insets.right + rectangle3.x);
            rectangle3.height = this.getHeight() - (insets.bottom + rectangle3.y);
            rectangle.height = 0;
            rectangle.width = 0;
            rectangle.y = 0;
            rectangle.x = 0;
            rectangle2.height = 0;
            rectangle2.width = 0;
            rectangle2.y = 0;
            rectangle2.x = 0;
            SwingUtilities.layoutCompoundLabel(this, (FontMetrics)object, (String)object2, null, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), rectangle3, rectangle2, rectangle, object2 == null ? 0 : this.getIconTextGap());
            if (view != null) {
                view.paint(graphics, rectangle);
            } else if (this.textRenderer != null && object2 != null && ((String)object2).length() > 0) {
                this.textRenderer.paintText(this, graphics, insets, (String)object2);
            } else if (!this.vertical) {
                int n5 = (dimension.width - ((FontMetrics)object).stringWidth((String)object2)) / 2;
                int n6 = (dimension.height + ((FontMetrics)object).getAscent() - 2) / 2;
                XImageButton.drawStringUnderlineCharAt(this, (FontMetrics)object, graphics, (String)object2, this.getDisplayedMnemonicIndex(), n5, n6);
            } else {
                int n7 = ((FontMetrics)object).stringWidth((String)object2);
                Dimension dimension2 = new Dimension(n, n7 + 16);
                boolean bl = false;
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.translate(0, dimension2.width - 1);
                graphics2D.rotate(-1.57);
                int n8 = 33;
                Object object4 = this.getClientProperty("verticalOffset");
                if (object4 != null) {
                    n8 = Integer.parseInt(object4.toString());
                }
                graphics2D.drawString((String)object2, (float)bl + ((float)dimension2.width - 8.0f) - (float)n7 - (float)n8, (float)((FontMetrics)object).getHeight() + 2.0f);
                graphics2D.setTransform(affineTransform);
            }
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object3);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.getBorder() != null) {
            Insets insets = this.getBorder().getBorderInsets(this);
            dimension.setSize(dimension.getWidth() + (double)insets.left + (double)insets.right, dimension.getHeight() + (double)insets.top + (double)insets.bottom);
        }
        if (this.vertical) {
            return new Dimension(dimension.height, dimension.width);
        }
        return dimension;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        this.repaint(100L, n2, n3, n4, n5);
        return n != 32;
    }

    public void setAlignment(int n) {
        super.setHorizontalAlignment(n);
        this.textRenderer.setHorizontalAlignment(n);
    }

    public void setImage(Image image) {
        this.image = image;
        this.repaint();
        this.prepareImage(image, this);
    }

    public void setPressedImage(Image image) {
        this.pressedImage = image;
        this.repaint();
        this.prepareImage(image, this);
    }

    public void setDisabledImage(Image image) {
        this.disabledImage = image;
        this.repaint();
        this.prepareImage(image, this);
    }

    public void setRolloverImage(Image image) {
        this.rolloverImage = image;
        this.repaint();
        this.prepareImage(image, this);
    }

    public void setImageName(String string) {
        this.imageName = string;
        this.setImage(this.currentProject.getImage(string));
    }

    public void setPressedImageName(String string) {
        this.pressedImageName = string;
        this.setPressedImage(this.currentProject.getImage(string));
    }

    public void setRolloverImageName(String string) {
        this.rolloverImageName = string;
        this.setRolloverImage(this.currentProject.getImage(string));
    }

    public void setDisabledImageName(String string) {
        this.disabledImageName = string;
        this.setDisabledImage(this.currentProject.getImage(string));
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getRolloverImageName() {
        return this.rolloverImageName;
    }

    public String getPressedImageName() {
        return this.pressedImageName;
    }

    public String getDisabledImageName() {
        return this.disabledImageName;
    }

    public int setAttribute(String string, Object object) {
        String string2 = string.toLowerCase();
        String string3 = (String)object;
        String string4 = null;
        if (object != null) {
            string4 = string3.toLowerCase();
            if (string2.equals("content") || string2.equals("imagename")) {
                Image image = this.currentProject.getImage(string3);
                if (image != null) {
                    this.imageName = string3;
                    this.setImageName(this.imageName);
                } else {
                    this.setText(XuiUtilities.translate(this.currentProject, string3));
                }
            } else if (string2.equals("icon")) {
                Image image = this.currentProject.getImage(string3);
                if (image != null) {
                    this.iconName = string3;
                    this.iconImage = new ImageIcon(image);
                }
            } else if (string2.equals("pressed")) {
                this.pressedImageName = string3;
                this.setPressedImageName(this.pressedImageName);
            } else if (string2.equals("rollover")) {
                this.rolloverImageName = string3;
                this.setRolloverImageName(this.rolloverImageName);
            } else if (string2.equals("disabled")) {
                this.disabledImageName = string3;
                this.setDisabledImageName(this.disabledImageName);
            } else if (string2.equals("border")) {
                this.setBorderPainted(object.equals("true"));
            } else if (string2.compareTo("tooltip") == 0) {
                this.setToolTipText(XuiUtilities.translate(this.currentProject, string3));
            } else if (string2.compareTo("text") == 0) {
                this.setText(XuiUtilities.translate(this.currentProject, string3));
            } else if (string2.equals("antialias")) {
                this.antiAlias = object.equals("true");
            } else if (string2.equals("userenderer")) {
                this.textRenderer = new XTextRenderer();
            } else if (string2.equals("painter")) {
                try {
                    Painter painter = (Painter)Class.forName(string3.trim()).newInstance();
                    this.setPainter(painter);
                }
                catch (Exception exception) {}
            } else {
                return -1;
            }
        }
        return 0;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.model.setPressed(true);
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.model.setPressed(false);
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.model.setRollover(true);
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.model.setRollover(false);
        this.repaint();
    }

    public static void drawStringUnderlineCharAt(JComponent jComponent, FontMetrics fontMetrics, Graphics graphics, String string, int n, int n2, int n3) {
        graphics.drawString(string, n2, n3);
        if (n >= 0 && n < string.length()) {
            int n4 = n2 + fontMetrics.stringWidth(string.substring(0, n));
            int n5 = n3;
            int n6 = fontMetrics.charWidth(string.charAt(n));
            int n7 = 1;
            graphics.fillRect(n4, n5 + 1, n6, n7);
        }
    }

    public void setHorizontalAlignment(int n) {
        if (this.textRenderer != null) {
            this.textRenderer.setHorizontalAlignment(n);
        }
        super.setHorizontalAlignment(n);
    }

    public void setVerticalAlignment(int n) {
        if (this.textRenderer != null) {
            this.textRenderer.setVerticalAlignment(n);
        }
        super.setVerticalAlignment(n);
    }

    public void setPainter(Painter painter) {
        this.painter = painter;
    }

    public Painter getPainter() {
        return this.painter;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean bl) {
        this.vertical = bl;
    }
}

