/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import net.xoetrope.swing.dnd.XTransferHandlerFactory;
import net.xoetrope.swing.util.XGraphicsUtils;
import net.xoetrope.xui.XAttributedComponent;
import net.xoetrope.xui.XImageHolder;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.XProjectManager;
import net.xoetrope.xui.helper.XuiUtilities;
import org.jdesktop.swingx.painter.Painter;

public class XImage
extends JComponent
implements XImageHolder,
XAttributedComponent,
MouseListener,
MouseMotionListener {
    public static final int STRETCH = 0;
    public static final int PRESERVE_ASPECT = 1;
    public static final int NO_SCALE = 2;
    public static final int TILE = 3;
    protected Image image = null;
    protected Image disabledImage = null;
    protected String imageName;
    protected BufferedImage shadow;
    protected boolean drawBorder;
    protected boolean drawShadow;
    protected boolean fillBorder;
    protected boolean dragEnabled = true;
    protected boolean centerImage;
    protected int arc;
    protected int shadowSize = 10;
    protected int distance = -5;
    protected int stretchMode = 0;
    protected Painter painter;
    protected MouseEvent firstMouseEvent;
    protected XProject currentProject = XProjectManager.getCurrentProject();

    public void addNotify() {
        super.addNotify();
        this.repaint(0L);
    }

    public int getShadowSize() {
        return this.shadowSize;
    }

    public void setImage(Image image) {
        this.image = image;
        this.repaint();
        this.prepareImage(image, this);
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String string) {
        this.imageName = string;
        this.setImage(this.currentProject.getImage(this.imageName));
        this.repaint();
    }

    public boolean getDrawShadow() {
        return this.drawShadow;
    }

    public boolean getFillBorder() {
        return this.fillBorder;
    }

    public int getArc() {
        return this.arc;
    }

    public void setArc(int n) {
        this.arc = n;
    }

    public boolean getOpaque() {
        return this.isOpaque();
    }

    public boolean getDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean bl) {
        this.drawBorder = bl;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.image == null ? super.getPreferredSize() : new Dimension(this.image.getWidth(null), this.image.getHeight(null));
        Border border = this.getBorder();
        if (border != null) {
            Insets insets = border.getBorderInsets(this);
            dimension.setSize(dimension.getWidth() + (double)insets.left + (double)insets.right, dimension.getHeight() + (double)insets.top + (double)insets.bottom);
        }
        return dimension;
    }

    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.painter != null) {
            this.painter.paint((Graphics2D)graphics, (Object)this, dimension.width, dimension.height);
        } else if (this.image != null) {
            Object object;
            Object object2;
            Insets insets = new Insets(0, 0, 0, 0);
            Border border = this.getBorder();
            if (border != null) {
                insets = border.getBorderInsets(this);
            }
            Dimension dimension2 = dimension;
            Graphics2D graphics2D = (Graphics2D)graphics;
            RoundRectangle2D.Double double_ = null;
            int n = 0;
            int n2 = this.drawBorder || this.fillBorder ? 8 : 0;
            int n3 = 0;
            if (this.drawShadow) {
                n3 = this.shadowSize;
                if (this.shadow == null) {
                    object2 = new BufferedImage(dimension.width, dimension.height, this.fillBorder ? 10 : 2);
                    object2 = XuiUtilities.createCompatibleImage(graphics2D, (BufferedImage)object2);
                    object = ((BufferedImage)object2).getGraphics();
                    if (this.fillBorder) {
                        RoundRectangle2D.Double double_2 = new RoundRectangle2D.Double(insets.left, insets.top, dimension2.width - insets.left - insets.right, dimension2.height - insets.top - insets.bottom, this.arc, this.arc);
                        ((Graphics)object).setColor(Color.gray);
                        ((Graphics2D)object).fill(double_2);
                    } else {
                        this.drawImage((Graphics2D)object, this.image, insets.left, insets.top, dimension2.width - insets.left - insets.right, dimension2.height - insets.top - insets.bottom, null);
                    }
                    ((Graphics)object).dispose();
                    this.shadow = new XGraphicsUtils().createShadow((BufferedImage)object2, this.shadowSize);
                }
                if (!this.drawBorder) {
                    n = this.shadowSize;
                }
                dimension = new Dimension(dimension2.width - this.shadowSize - n2 - n2 - insets.left - insets.right, dimension2.height - this.shadowSize - n2 - n2 - insets.top - insets.top);
                if (this.fillBorder) {
                    this.drawImage(graphics2D, this.shadow, this.shadowSize, this.shadowSize, dimension2.width - this.shadowSize, dimension2.height - this.shadowSize, null);
                    graphics.setColor(this.getBackground());
                    graphics.fillRoundRect(insets.left, insets.top, dimension2.width - this.shadowSize - insets.left - insets.right, dimension2.height - this.shadowSize - insets.top - insets.bottom, this.arc, this.arc);
                } else {
                    this.drawImage(graphics2D, this.shadow, this.shadowSize + n + n2 + insets.left, this.shadowSize + n + n2 + insets.top, dimension.width, dimension.height, null);
                }
            } else if (this.fillBorder) {
                graphics2D.setColor(this.getBackground());
                graphics2D.fillRoundRect(insets.left, insets.top, dimension2.width - insets.left - insets.right, dimension2.height - insets.top - insets.bottom, this.arc, this.arc);
            }
            object2 = graphics2D.getClip();
            if (this.drawBorder) {
                double_ = new RoundRectangle2D.Double(insets.left, insets.top, dimension2.width - n3 - 1 - insets.left - insets.right, dimension2.height - n3 - 1 - insets.top - insets.bottom, this.arc, this.arc);
                graphics2D.setColor(this.getForeground());
                graphics2D.draw(double_);
                object = new Area(double_);
                ((Area)object).intersect(new Area((Shape)object2));
                graphics2D.setClip((Shape)object);
            }
            if (this.isEnabled()) {
                this.drawImage(graphics2D, this.image, n2, n2, dimension.width, dimension.height, this);
            } else {
                object = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
                this.drawImage(graphics2D, this.image, n2 + insets.left, n2 + insets.top, dimension.width, dimension.height, this);
                graphics2D.setComposite((Composite)object);
            }
            graphics2D.setClip((Shape)object2);
        }
    }

    public void drawImage(Graphics2D graphics2D, Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        int n5 = image.getWidth(imageObserver);
        int n6 = image.getHeight(imageObserver);
        switch (this.stretchMode) {
            case 2: {
                if (this.centerImage) {
                    int n7 = (n5 - n3) / 2;
                    int n8 = (n6 - n4) / 2;
                    graphics2D.drawImage(image, n + n7, n2 + n8, imageObserver);
                    break;
                }
                graphics2D.drawImage(image, n, n2, imageObserver);
                break;
            }
            case 1: {
                if (n5 > n6) {
                    int n9 = n6 * n3 / n5;
                    int n10 = this.centerImage ? (n4 - n9) / 2 : 0;
                    graphics2D.drawImage(image, n, n2 + n10, n3, n9, imageObserver);
                    break;
                }
                int n11 = n5 * n4 / n6;
                int n12 = this.centerImage ? (n3 - n11) / 2 : 0;
                graphics2D.drawImage(image, n + n12, n2, n11, n6, imageObserver);
                break;
            }
            case 3: {
                for (int i = n; i < n3; i += n5) {
                    for (int j = n2; j < n3; j += n5) {
                        graphics2D.drawImage(image, i, j, n5, n6, imageObserver);
                    }
                }
                break;
            }
            default: {
                graphics2D.drawImage(image, n, n2, n3, n4, imageObserver);
            }
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (n == 32) {
            this.repaint(n2, n3, this.getWidth(), this.getHeight());
            return false;
        }
        if (n > 32) {
            return false;
        }
        if (this.drawShadow) {
            this.getParent().repaint();
        }
        this.repaint(n2, n3, this.getWidth(), this.getHeight());
        return true;
    }

    public void setPainter(Painter painter) {
        this.painter = painter;
    }

    public Painter getPainter() {
        return this.painter;
    }

    public int setAttribute(String string, Object object) {
        String string2 = string.toLowerCase();
        String string3 = (String)object;
        String string4 = null;
        if (object != null) {
            string4 = string3.toLowerCase();
        }
        if (string2.equals("content") || string2.equals("imagename")) {
            this.imageName = string3;
            this.setImage(this.currentProject.getImage(this.imageName));
        } else {
            if (object == null) {
                return -1;
            }
            if (string2.equals("tooltip")) {
                this.setToolTipText(string3);
            } else if (string2.equals("opaque")) {
                this.setOpaque(string4.equals("true"));
            } else if (string2.equals("border")) {
                this.drawBorder = string4.equals("true") || string4.equals("1");
            } else if (string2.equals("fill")) {
                this.fillBorder = string4.equals("true") || string4.equals("1");
            } else if (string2.equals("shadow")) {
                this.drawShadow = string4.equals("true") || string4.equals("1");
            } else if (string2.equals("arc")) {
                this.arc = Math.max(0, new Integer(string3));
            } else if (string2.equals("stretch")) {
                this.setStretchMode(Math.max(0, new Integer(string3)));
            } else if (string2.equals("center")) {
                this.setCenterImage(string4.equals("true"));
            } else if (string2.equals("painter")) {
                try {
                    Painter painter = (Painter)Class.forName(string3.trim()).newInstance();
                    this.setPainter(painter);
                }
                catch (Exception exception) {}
            } else if (string2.equals("dragenabled")) {
                TransferHandler transferHandler;
                XTransferHandlerFactory xTransferHandlerFactory;
                boolean bl = "true".equals(string4);
                if (bl && (xTransferHandlerFactory = XTransferHandlerFactory.getInstance(XProjectManager.getCurrentProject())) != null && (transferHandler = xTransferHandlerFactory.getTransferHandler(this, null)) != null) {
                    this.addMouseListener(this);
                    this.addMouseMotionListener(this);
                    this.setTransferHandler(transferHandler);
                    return 0;
                }
            } else {
                return -1;
            }
        }
        return 0;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.imageName == null) {
            return;
        }
        this.firstMouseEvent = mouseEvent;
        mouseEvent.consume();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.imageName == null) {
            return;
        }
        if (this.firstMouseEvent != null) {
            mouseEvent.consume();
            int n = 128;
            int n2 = (mouseEvent.getModifiersEx() & n) == n ? 1 : 2;
            int n3 = Math.abs(mouseEvent.getX() - this.firstMouseEvent.getX());
            int n4 = Math.abs(mouseEvent.getY() - this.firstMouseEvent.getY());
            if (n3 > 5 || n4 > 5) {
                JComponent jComponent = (JComponent)mouseEvent.getSource();
                TransferHandler transferHandler = jComponent.getTransferHandler();
                transferHandler.exportAsDrag(jComponent, this.firstMouseEvent, n2);
                this.firstMouseEvent = null;
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.firstMouseEvent = null;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public int getStretchMode() {
        return this.stretchMode;
    }

    public void setStretchMode(int n) {
        this.stretchMode = n;
        this.repaint();
    }

    public boolean isCenterImage() {
        return this.centerImage;
    }

    public void setCenterImage(boolean bl) {
        this.centerImage = bl;
        this.repaint();
    }
}

