/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.Reader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import net.xoetrope.swing.XImage;
import net.xoetrope.xml.XmlElement;
import net.xoetrope.xml.XmlSource;

public class XHotspotImage
extends XImage
implements MouseMotionListener {
    protected static Cursor handCursor;
    protected static Cursor defaultCursor;
    protected Vector hotspots;
    protected Vector names;

    public XHotspotImage() {
        if (handCursor == null) {
            handCursor = Cursor.getPredefinedCursor(12);
            defaultCursor = Cursor.getPredefinedCursor(0);
        }
        this.hotspots = new Vector();
        this.addMouseMotionListener(this);
    }

    public String getName(int n) {
        if (n != -1) {
            return (String)this.names.elementAt(n);
        }
        return null;
    }

    public void read(Reader reader) {
        this.names = new Vector();
        this.hotspots = new Vector();
        XmlElement xmlElement = XmlSource.read(reader);
        Enumeration enumeration = xmlElement.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            XmlElement xmlElement2 = (XmlElement)enumeration.nextElement();
            if (xmlElement2.getName().compareTo("area") == 0) {
                String string = xmlElement2.getAttribute("name");
                if (string == null) {
                    this.names.addElement("");
                } else {
                    this.names.addElement(xmlElement2.getAttribute("name"));
                }
                this.addHotspot(xmlElement2.getAttribute("coords"));
                continue;
            }
            this.addCustomHotspot(xmlElement2);
        }
    }

    protected void addCustomHotspot(XmlElement xmlElement) {
    }

    private int getNextTokenAsInt(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken().trim();
        return Integer.parseInt(string);
    }

    private void addHotspot(String string) {
        Polygon polygon = new Polygon();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = this.getNextTokenAsInt(stringTokenizer);
        int n2 = this.getNextTokenAsInt(stringTokenizer);
        polygon.addPoint(n, n2);
        while (stringTokenizer.hasMoreTokens()) {
            int n3 = this.getNextTokenAsInt(stringTokenizer);
            int n4 = this.getNextTokenAsInt(stringTokenizer);
            polygon.addPoint(n3, n4);
        }
        polygon.addPoint(n, n2);
        this.hotspots.addElement(polygon);
    }

    public int checkHotspot(Point point) {
        int n = this.hotspots.size();
        for (int i = 0; i < n; ++i) {
            Polygon polygon = (Polygon)this.hotspots.elementAt(i);
            if (!polygon.contains(point)) continue;
            this.setCursor(handCursor);
            return i;
        }
        this.setCursor(defaultCursor);
        return -1;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.checkHotspot(mouseEvent.getPoint());
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }
}

