/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JFormattedTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.MaskFormatter;
import javax.swing.text.NumberFormatter;
import net.xoetrope.swing.XAlignmentHelper;
import net.xoetrope.xui.XAttributedComponent;
import net.xoetrope.xui.XTextHolder;

public class XEdit
extends JFormattedTextField
implements XTextHolder,
XAttributedComponent {
    protected boolean antiAlias;

    public void paintComponent(Graphics graphics) {
        Object object = null;
        Graphics2D graphics2D = (Graphics2D)graphics;
        object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.antiAlias ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        super.paintComponent(graphics);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
    }

    public int setAttribute(String string, Object object) {
        String string2 = string.toLowerCase();
        String string3 = (String)object;
        String string4 = null;
        if (object != null) {
            string4 = string3.toLowerCase();
        }
        if (string2.equals("alignment") || string2.equals("align")) {
            this.setHorizontalAlignment(XAlignmentHelper.getAlignmentOption(string3));
        } else if (string2.equals("border")) {
            if (string4.equals("0")) {
                this.setBorder(new EmptyBorder(0, 0, 0, 0));
            }
        } else if (string2.equals("margin")) {
            int n = new Integer(string4);
            this.setMargin(new Insets(n, n, n, n));
        } else if (string2.equals("tooltip")) {
            this.setToolTipText(string3);
        } else if (string2.equals("editable")) {
            this.setEditable(string3.equals("true"));
        } else if (string2.equals("format")) {
            DefaultFormatter defaultFormatter = null;
            if (string4.equals("integer")) {
                defaultFormatter = new NumberFormatter(NumberFormat.getIntegerInstance());
            } else if (string4.equals("currency")) {
                defaultFormatter = new NumberFormatter(NumberFormat.getCurrencyInstance(Locale.getDefault()));
            } else if (string4.equals("decimal")) {
                defaultFormatter = new NumberFormatter(new DecimalFormat());
            } else if (string4.equals("date")) {
                defaultFormatter = new DateFormatter(DateFormat.getDateInstance());
            } else {
                try {
                    defaultFormatter = new MaskFormatter(string3);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (defaultFormatter != null) {
                this.setFormatter(defaultFormatter);
            }
        } else if (string2.equals("antialias")) {
            this.antiAlias = object.equals("true");
        } else {
            return -1;
        }
        return 0;
    }
}

