/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.MenuComponent;

public class XDialogEventDispatchThread
extends Thread {
    private EventQueue theQueue;
    private boolean doDispatch = true;

    XDialogEventDispatchThread(String string, EventQueue eventQueue) {
        super(string);
        this.theQueue = eventQueue;
    }

    public void stopDispatching(boolean bl) {
        this.doDispatch = false;
        if (bl) {
            this.theQueue.postEvent(new EmptyEvent());
        }
        if (Thread.currentThread() != this) {
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void run() {
        while (this.doDispatch) {
            try {
                AWTEvent aWTEvent = this.theQueue.getNextEvent();
                Object object = aWTEvent.getSource();
                if (aWTEvent instanceof ActiveEvent) {
                    ((ActiveEvent)((Object)aWTEvent)).dispatch();
                }
                if (object instanceof Component) {
                    ((Component)object).dispatchEvent(aWTEvent);
                    continue;
                }
                if (!(object instanceof MenuComponent)) continue;
                ((MenuComponent)object).dispatchEvent(aWTEvent);
            }
            catch (ThreadDeath threadDeath) {
                return;
            }
            catch (Throwable throwable) {
                System.err.println("Exception occurred during event dispatching:");
                throwable.printStackTrace();
            }
        }
    }

    class EmptyEvent
    extends AWTEvent {
        public EmptyEvent() {
            super(XDialogEventDispatchThread.this, 0);
        }

        public void dispatch() {
        }
    }
}

