/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import net.xoetrope.xui.XAttributedComponent;
import net.xoetrope.xui.XListHolder;

public class XComboBox
extends JComboBox
implements XListHolder,
XAttributedComponent {
    private boolean autoComplete;

    public void setDefaultSelection() {
        this.select(0);
    }

    public void addItem(String string) {
        super.addItem(string);
    }

    public void select(int n) {
        super.setSelectedIndex(n);
    }

    public void select(Object object) {
        super.setSelectedItem(object);
    }

    public Object getSelectedObject() {
        return this.getSelectedItem();
    }

    public Object[] getSelectedObjects() {
        Object[] objectArray = new Object[]{this.getSelectedObject()};
        return objectArray;
    }

    public void setSelectedObject(Object object) {
        this.select(object);
    }

    public void setSelectedObjects(Object[] objectArray) {
        this.select(objectArray[0]);
    }

    public void add(String string) {
    }

    public void removeAll() {
        super.removeAllItems();
    }

    public void setBackground(Color color) {
        if (this.isEditable()) {
            this.getEditor().getEditorComponent().setBackground(color);
        }
        super.setBackground(color);
    }

    public void setForeground(Color color) {
        if (this.isEditable()) {
            this.getEditor().getEditorComponent().setForeground(color);
        }
        super.setForeground(color);
    }

    public void setRenderer(ListCellRenderer listCellRenderer) {
        Color color = this.getForeground();
        Color color2 = this.getBackground();
        super.setRenderer(listCellRenderer);
        this.setForeground(color);
        this.setBackground(color2);
    }

    public void setSearchable(boolean bl) {
        this.setKeySelectionManager(new SystemSelectionManager(bl));
    }

    public boolean isSearchable() {
        if (this.getKeySelectionManager() instanceof SystemSelectionManager) {
            return ((SystemSelectionManager)this.getKeySelectionManager()).isSearchable();
        }
        return false;
    }

    public int setAttribute(String string, Object object) {
        String string2 = string.toLowerCase();
        String string3 = (String)object;
        String string4 = null;
        if (object != null) {
            string4 = string3.toLowerCase();
        }
        if (string2.equals("editable")) {
            this.setEditable(string4.equals("true"));
        } else if (string2.equals("search")) {
            this.setSearchable(string4.equals("true"));
        } else if (string2.equals("autocomplete")) {
            this.setAutoComplete(string4.equals("true"));
        } else if (string2.equals("pause")) {
            try {
                long l = new Long(string3);
                JComboBox.KeySelectionManager keySelectionManager = this.getKeySelectionManager();
                if (!(keySelectionManager instanceof SystemSelectionManager)) {
                    this.setSearchable(true);
                    keySelectionManager = this.getKeySelectionManager();
                }
                ((SystemSelectionManager)keySelectionManager).setPause(l);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string2.equals("alphanum")) {
            try {
                JComboBox.KeySelectionManager keySelectionManager = this.getKeySelectionManager();
                if (!(keySelectionManager instanceof SystemSelectionManager)) {
                    this.setSearchable(true);
                    keySelectionManager = this.getKeySelectionManager();
                }
                ((SystemSelectionManager)keySelectionManager).setAlphaNumOnly(new Boolean(string3));
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            return -1;
        }
        return 0;
    }

    public int getSelectionMode() {
        return 0;
    }

    public void setAutoComplete(boolean bl) {
        this.autoComplete = bl;
        if (this.autoComplete) {
            JTextComponent jTextComponent = (JTextComponent)this.getEditor().getEditorComponent();
            jTextComponent.setDocument(new AutoCompleteDocument());
        } else {
            JTextComponent jTextComponent = (JTextComponent)this.getEditor().getEditorComponent();
            jTextComponent.setDocument(new PlainDocument());
        }
    }

    public boolean isAutoComplete() {
        return this.autoComplete;
    }

    private class AutoCompleteDocument
    extends PlainDocument {
        private ComboBoxModel model;
        private JTextComponent textComp;
        private boolean selecting = false;
        private boolean navigating = false;
        private int index = -1;

        public AutoCompleteDocument() {
            this.model = XComboBox.this.getModel();
            this.textComp = (JTextComponent)XComboBox.this.getEditor().getEditorComponent();
            this.textComp.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (!XComboBox.this.isPopupVisible()) {
                        XComboBox.this.setPopupVisible(true);
                    }
                    AutoCompleteDocument.this.updateSelection(keyEvent);
                }
            });
            this.textComp.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    String string = AutoCompleteDocument.this.textComp.getText();
                    int n = AutoCompleteDocument.this.model.getSize();
                    for (int i = 0; i < n; ++i) {
                        String string2 = AutoCompleteDocument.this.model.getElementAt(i).toString();
                        if (!string2.toLowerCase().equals(string.toLowerCase())) continue;
                        AutoCompleteDocument.this.navigating = true;
                        if (i > 0) {
                            AutoCompleteDocument.this.index = i - 1;
                            AutoCompleteDocument.this.setSelectedItem(AutoCompleteDocument.this.model.getElementAt(AutoCompleteDocument.this.index).toString());
                        } else {
                            AutoCompleteDocument.this.index = -1;
                            AutoCompleteDocument.this.setSelectedItem(null);
                        }
                        AutoCompleteDocument.this.navigating = false;
                        break;
                    }
                }

                public void focusLost(FocusEvent focusEvent) {
                }
            });
        }

        public void updateSelection(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            int n2 = XComboBox.this.getItemCount() - 1;
            if (n == 40 && this.index < n2) {
                ++this.index;
                this.navigating = true;
            } else if (n == 38 && this.index > 0) {
                --this.index;
                this.navigating = true;
            }
            if (this.navigating) {
                String string = (String)XComboBox.this.getItemAt(this.index);
                try {
                    this.insertString(0, string, null);
                    this.highLightText(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.navigating = false;
            }
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (this.selecting) {
                return;
            }
            if (this.navigating) {
                super.remove(0, this.getLength());
            }
            super.insertString(n, string, attributeSet);
            Object object = this.lookupItem(this.getText(0, this.getLength()));
            if (object != null) {
                if (!this.navigating) {
                    this.setSelectedItem(object);
                }
                super.remove(0, this.getLength());
                super.insertString(0, object.toString(), attributeSet);
                this.highLightText(n + string.length());
            } else {
                if (XComboBox.this.isPopupVisible()) {
                    XComboBox.this.setPopupVisible(false);
                }
                this.textComp.setSelectionEnd(0);
                this.textComp.setCaretPosition(this.textComp.getText().length());
            }
        }

        public void remove(int n, int n2) throws BadLocationException {
            if (this.selecting) {
                return;
            }
            super.remove(n, n2);
        }

        public void setSelectedItem(Object object) {
            this.selecting = true;
            this.model.setSelectedItem(object);
            this.selecting = false;
        }

        public Object lookupItem(String string) {
            int n = this.model.getSize();
            for (int i = 0; i < n; ++i) {
                String string2 = this.model.getElementAt(i).toString();
                if (!string2.toLowerCase().startsWith(string.toLowerCase())) continue;
                this.index = i;
                return string2;
            }
            return null;
        }

        public void highLightText(int n) {
            this.textComp.setSelectionStart(n);
            this.textComp.setSelectionEnd(this.getLength());
        }
    }

    public class SystemSelectionManager
    implements JComboBox.KeySelectionManager {
        private String searchString = new String();
        private long lastTime;
        private long pause = 1000L;
        private boolean doSearch;
        private boolean alphaNumOnly;

        public SystemSelectionManager(boolean bl) {
            this.doSearch = bl;
            this.alphaNumOnly = true;
        }

        public int selectionForKey(char c, ComboBoxModel comboBoxModel) {
            this.updateSearchString(comboBoxModel, c);
            if (this.searchString.length() == 0) {
                return -1;
            }
            int n = this.getIndex(comboBoxModel, this.getSelectedString(comboBoxModel));
            int n2 = this.search(comboBoxModel, n);
            if (n2 == -1 && n != 0) {
                n2 = this.search(comboBoxModel, 0);
            }
            return n2;
        }

        public boolean isSearchable() {
            return this.doSearch;
        }

        public String getSearchString() {
            return this.searchString;
        }

        private int search(ComboBoxModel comboBoxModel, int n) {
            for (int i = n; i < comboBoxModel.getSize(); ++i) {
                String string = this.getString(comboBoxModel, i);
                int n2 = this.searchString.length();
                if (n2 < 1) {
                    return -1;
                }
                if (!string.regionMatches(true, 0, this.searchString, 0, n2)) continue;
                return i;
            }
            return -1;
        }

        private int getIndex(ComboBoxModel comboBoxModel, String string) {
            int n = comboBoxModel.getSize();
            if (string != null) {
                for (int i = 0; i < n; ++i) {
                    String string2 = this.getString(comboBoxModel, i);
                    if (string2.compareToIgnoreCase(string) != 0) continue;
                    return i == n - 1 ? 0 : i;
                }
            }
            return 0;
        }

        private String getString(ComboBoxModel comboBoxModel, int n) {
            Object e = comboBoxModel.getElementAt(n);
            return e.toString();
        }

        private String getSelectedString(ComboBoxModel comboBoxModel) {
            Object object = comboBoxModel.getSelectedItem();
            if (object == null) {
                return null;
            }
            return object.toString();
        }

        private void updateSearchString(ComboBoxModel comboBoxModel, char c) {
            if (this.doSearch) {
                long l = System.currentTimeMillis();
                if (l - this.lastTime > this.pause) {
                    this.searchString = "";
                }
                this.lastTime = l;
                this.searchString = this.alphaNumOnly && Character.getNumericValue(c) == -1 ? (c != '-' && this.searchString.length() > 0 ? this.searchString.substring(0, this.searchString.length() - 1) : this.searchString + c) : this.searchString + c;
            } else {
                this.searchString = this.searchString + c;
            }
        }

        public void setPause(long l) {
            this.pause = l;
        }

        public void setAlphaNumOnly(boolean bl) {
            this.alphaNumOnly = bl;
        }
    }
}

