/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import net.xoetrope.swing.SwingWidgetAdapter;
import net.xoetrope.xui.PageSupport;
import net.xoetrope.xui.XApplicationContext;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.XStartupObject;

public class XApplet
extends JApplet
implements XStartupObject {
    protected Window appWindow;
    protected JFrame clientFrame;
    protected boolean bUseWindow;
    protected XApplicationContext applicationContext;
    protected Container pageHolder;

    public static void main(String[] stringArray) {
        final String[] stringArray2 = stringArray;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                XApplet.loadUI(stringArray2);
            }
        });
    }

    protected static void loadUI(String[] stringArray) {
        JFrame jFrame = new JFrame();
        XApplet xApplet = new XApplet(stringArray, jFrame);
        jFrame.getContentPane().add(xApplet);
        jFrame.validate();
    }

    public XApplet() {
        this(null, null);
    }

    public XApplet(String[] stringArray, JFrame jFrame) {
        this.clientFrame = jFrame;
        SwingWidgetAdapter.getInstance();
        this.applicationContext = new XApplicationContext(this, stringArray);
    }

    public Object getParentObject() {
        return this.getParent();
    }

    public String getWidgetClassPackage() {
        return "net.xoetrope.swing";
    }

    public void setupFrameset(Hashtable hashtable) {
    }

    public Object displayDecoration(PageSupport pageSupport, String string) {
        if (string.equals("NORTH")) {
            this.pageHolder.add((Component)((Object)pageSupport), "North");
        } else if (string.equals("SOUTH")) {
            this.pageHolder.add((Component)((Object)pageSupport), "South");
        } else if (string.equals("EAST")) {
            this.pageHolder.add((Component)((Object)pageSupport), "East");
        } else if (string.equals("WEST")) {
            this.pageHolder.add((Component)((Object)pageSupport), "West");
        } else if (string.equals("CENTER")) {
            this.pageHolder.add((Component)((Object)pageSupport), "Center");
        } else {
            return null;
        }
        return pageSupport;
    }

    public void refresh() {
        if (this.appWindow != null) {
            this.appWindow.invalidate();
            this.appWindow.validate();
            this.appWindow.repaint();
        }
        this.layout();
    }

    public void restoreViews() {
    }

    public Object getContentPaneEx() {
        return this.pageHolder;
    }

    public void setAppTitle(String string) {
        try {
            if (this.clientFrame != null) {
                this.clientFrame.setTitle(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setIcon(Image image) {
        if (image != null) {
            this.clientFrame.setIconImage(image);
        }
    }

    public void setupWindow(XApplicationContext xApplicationContext, XProject xProject, int n, int n2) {
        Object object;
        xProject.setStartupParam("MainClass", "net.xoetrope.swing.XApplet");
        String string = xProject.getStartupParam("UseWindow");
        this.bUseWindow = "true".equals(string);
        String string2 = xProject.getStartupParam("MaximizeWindow");
        if (string2 != null && string2.equals("true")) {
            object = Toolkit.getDefaultToolkit().getScreenSize();
            n = ((Dimension)object).width;
            n2 = ((Dimension)object).height;
        }
        this.setSize(n, n2);
        if (this.clientFrame != null) {
            this.clientFrame.setSize(n, n2);
        }
        object = xProject.getStartupParam("UndecoratedWin");
        if (this.clientFrame != null && object != null && ((String)object).equals("true")) {
            this.callDecorationMethod(this.clientFrame, true);
        }
        this.appWindow = null;
        if (this.bUseWindow) {
            this.appWindow = new JWindow(this.clientFrame);
            this.appWindow.setSize(n, n2);
            this.appWindow.addWindowListener(xApplicationContext);
            this.clientFrame.addWindowListener(xApplicationContext);
        } else {
            this.appWindow = this.clientFrame;
            if (this.clientFrame != null) {
                this.clientFrame.addWindowListener(xApplicationContext);
            }
        }
        this.clientFrame.setDefaultCloseOperation(0);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (this.bUseWindow) {
            Dimension dimension2 = this.appWindow.getSize();
            this.appWindow.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
            this.appWindow.setVisible(true);
            this.clientFrame.setLocation(dimension.width / 2, dimension.height / 2);
            this.clientFrame.setSize(0, 0);
            this.clientFrame.setVisible(true);
            this.appWindow.setLayout(new BorderLayout());
            this.pageHolder = new JPanel();
            this.appWindow.add((Component)this.pageHolder, "Center");
            this.pageHolder.setVisible(true);
        } else if (this.clientFrame != null) {
            Dimension dimension3 = this.clientFrame.getSize();
            String string3 = null;
            try {
                string3 = xProject.getStartupParam("CenterWin");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ("true".equals(string3)) {
                this.clientFrame.setLocation((dimension.width - dimension3.width) / 2, (dimension.height - dimension3.height) / 2);
            }
            this.clientFrame.setVisible(true);
            this.getContentPane().setLayout(new BorderLayout());
            this.pageHolder = super.getContentPane();
        }
        xProject.setApplet(this);
        xProject.setStartupObject(this);
        xProject.setAppFrame(this.clientFrame);
        xProject.setAppWindow(this.appWindow);
    }

    private boolean callDecorationMethod(Object object, boolean bl) {
        try {
            Class<?> clazz = object.getClass();
            Field field = this.getClass().getField("trueField");
            Class[] classArray = new Class[]{field.getType()};
            Method method = clazz.getMethod("setUndecorated", classArray);
            Object[] objectArray = new Object[]{field.get(this)};
            method.invoke(object, objectArray);
            return true;
        }
        catch (Exception exception) {
            exception.getCause().printStackTrace();
            return false;
        }
    }

    public void init() {
        this.applicationContext.init();
    }

    public JFrame getFrame() {
        if (this.clientFrame != null) {
            return this.clientFrame;
        }
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (container == null || !(container instanceof JFrame)) continue;
            return (JFrame)container;
        }
        return null;
    }

    public void setMenuBar(JMenuBar jMenuBar) {
        this.setJMenuBar(jMenuBar);
    }

    public Object getApplicationMenuBar() {
        return this.getJMenuBar();
    }

    public void setApplicationMenuBar(Object object) {
        this.setJMenuBar((JMenuBar)object);
        ((JMenuBar)object).setVisible(false);
        ((JMenuBar)object).setVisible(true);
    }
}

