/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.registry;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import net.xoetrope.debug.DebugLogger;
import net.xoetrope.xml.XmlElement;
import net.xoetrope.xui.XAttributedComponent;
import net.xoetrope.xui.helper.ReflectionHelper;

public class ComponentAdapter {
    protected Class clazz;
    protected String UI;
    protected String className;
    protected Hashtable setters;
    protected Hashtable getters;

    public ComponentAdapter(Class clazz, String string) {
        this.UI = string;
        this.className = clazz.getName();
        this.getters = new Hashtable();
        this.setters = new Hashtable();
        this.clazz = clazz;
    }

    public ComponentAdapter(String string, String string2) throws ClassNotFoundException {
        this.UI = string2;
        this.className = string;
        this.getters = new Hashtable();
        this.setters = new Hashtable();
        try {
            this.clazz = Class.forName(this.className.trim());
        }
        catch (Throwable throwable) {
            DebugLogger.logError("Cannot load the registered component's class:" + string);
        }
    }

    public ComponentAdapter(ClassLoader classLoader, String string, String string2) throws ClassNotFoundException {
        this.UI = string2;
        this.className = string;
        this.getters = new Hashtable();
        this.setters = new Hashtable();
        try {
            this.clazz = classLoader.loadClass(this.className);
        }
        catch (Throwable throwable) {
            DebugLogger.logError("Cannot load the registered component's class:" + string);
        }
    }

    public Class getAdapterClass() {
        return this.clazz;
    }

    public String getAdapterClassName() {
        return this.className;
    }

    public int setProperty(Object object, String string, String string2, String string3) {
        try {
            if (this.setters != null) {
                Method method;
                String string4 = string.substring(0, 1).toUpperCase() + string.substring(1);
                Object v = this.setters.get(string4);
                if (v == null) {
                    method = this.addProperty("set", string4, "set" + string4, string3, false, false, null);
                } else if (v instanceof Method) {
                    method = (Method)v;
                } else {
                    return -1;
                }
                if (method != null) {
                    Object[] objectArray = new Object[1];
                    if (string3 == null) {
                        string3 = method.getParameterTypes()[0].toString();
                    }
                    if (string3 != null) {
                        objectArray[0] = ReflectionHelper.getObject(string3, string2);
                    }
                    method.invoke(object, objectArray);
                    return 0;
                }
                this.setters.put(string, "setAttribute");
            }
        }
        catch (Throwable throwable) {
            throwable.getCause().printStackTrace();
        }
        return -1;
    }

    public Object getProperty(Object object, String string) {
        try {
            if (this.setters != null) {
                Object object2;
                Method method = (Method)this.getters.get(string);
                if (method == null) {
                    object2 = string.substring(0, 1).toUpperCase() + string.substring(1);
                    method = this.addProperty("get", string, "get" + (String)object2, null, false, true, null);
                }
                if (method != null) {
                    object2 = new Object[]{};
                    return method.invoke(object, object2);
                }
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return null;
    }

    public Method addProperty(String string, String string2, String string3, String string4, boolean bl, boolean bl2, XmlElement xmlElement) {
        if (this.clazz == null) {
            DebugLogger.logWarning("Component class unavailable, property cannot be added: " + string2);
            return null;
        }
        Method method = null;
        try {
            boolean bl3 = string.compareTo("set") == 0;
            boolean bl4 = string.compareTo("get") == 0;
            Class[] classArray = new Class[bl3 ? 1 : 0];
            if (bl3 && !bl) {
                classArray[0] = ReflectionHelper.getParamClass(string4);
                if (classArray[0] != XAttributedComponent.class) {
                    try {
                        method = this.clazz.getMethod(string3, classArray);
                        this.setters.put(string2, method);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (bl4) {
                method = this.clazz.getMethod(string3, classArray);
                this.getters.put(string2, method);
            }
        }
        catch (Throwable throwable) {
            DebugLogger.logError("Unable to add method " + string3 + " for class " + this.clazz.getName());
        }
        return method;
    }

    public String getUI() {
        return this.UI;
    }
}

