/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.debug;

import java.util.Date;
import java.util.Hashtable;
import net.xoetrope.debug.XLogListener;
import net.xoetrope.debug.XLogWriter;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.data.XModel;

public class DebugLogger {
    public static final int SILENT = -1;
    public static final int NORMAL = 0;
    public static final int DEBUG = 1;
    public static final int VERBOSE = 2;
    public static final int PARANOID = 3;
    private static int numErrors;
    private static int numWarnings;
    private static DebugLogger logger;
    private static int level;
    private static boolean logMessageTime;
    private static XLogListener logListener;
    private static XLogWriter outputWriter;
    private static XLogWriter errorWriter;
    private static Hashtable zones;

    protected DebugLogger() {
    }

    public static void exitApplication() {
        System.exit(0);
        zones.clear();
    }

    public static void dump() {
    }

    public static DebugLogger getInstance() {
        if (logger == null) {
            logger = new DebugLogger();
        }
        return logger;
    }

    public static void logError(String string, String string2) {
        if (level > -1 && DebugLogger.isZoneEnabled(string)) {
            DebugLogger.getInstance();
            DebugLogger.writeErrorLine("ERROR: " + string2);
            ++numErrors;
        }
    }

    public static void logError(String string) {
        DebugLogger.logError(null, string);
    }

    public static void logWarning(String string, String string2) {
    }

    public static void logWarning(String string) {
        DebugLogger.logWarning(null, string);
    }

    public static void log(String string) {
        DebugLogger.getInstance();
        DebugLogger.writeLine(string);
    }

    public static void trace(String string, String string2) {
    }

    public static void trace(String string) {
        DebugLogger.trace(null, string);
    }

    public static void trace(String string, double d) {
    }

    public static void trace(XProject xProject, XModel xModel) {
    }

    public static void dumpModel(XModel xModel) {
    }

    public static void setDebugLevel(int n) {
        level = n;
    }

    public static void setDebugLevel(String string) {
        try {
            if (string != null) {
                level = new Integer(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            DebugLogger.logError("Unable to set the logging level, invalid value: " + string);
        }
    }

    public static boolean isZoneEnabled(String string) {
        if (string == null) {
            return true;
        }
        return zones.get(string) == null;
    }

    public static void enableZone(String string, boolean bl) {
        if (zones.get(string) == null) {
            if (bl) {
                zones.remove(string);
            } else {
                zones.put(string, string);
            }
        }
    }

    protected static void writeLine(String string) {
        String string2 = string;
        if (logMessageTime) {
            string2 = new Date().toString() + " " + string2;
        }
        if (logListener != null) {
            logListener.addMessage(string2);
        }
        if (outputWriter != null) {
            outputWriter.writeLine(string2);
        } else {
            System.out.println(string2);
        }
    }

    protected static void writeErrorLine(String string) {
        String string2 = string;
        if (logMessageTime) {
            string2 = new Date().toString() + " " + string2;
        }
        if (logListener != null) {
            logListener.addError(string2);
        }
        if (outputWriter != null) {
            errorWriter.writeLine(string2);
        } else {
            System.err.println(string2);
        }
    }

    public static void setLogListener(XLogListener xLogListener) {
        logListener = xLogListener;
    }

    public static void setOutputWriter(XLogWriter xLogWriter) {
        outputWriter = xLogWriter;
    }

    public static void setErrorWriter(XLogWriter xLogWriter) {
        errorWriter = xLogWriter;
    }

    public static void setLogMessageTime(boolean bl) {
        logMessageTime = bl;
    }

    public static void readLoggerZones(XProject xProject) {
    }

    static {
        level = 0;
        zones = new Hashtable();
    }
}

