/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.data;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import net.xoetrope.xml.XmlElement;
import net.xoetrope.xml.XmlParserFactory;
import net.xoetrope.xml.XmlSource;
import net.xoetrope.xml.nanoxml.NanoXmlWriter;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.data.XModel;

public class XDataSource {
    private static int nextId = 0;
    private static boolean useValueAsId = false;
    protected XProject currentProject;

    public XDataSource(XProject xProject) {
        this.currentProject = xProject;
    }

    public void read(Reader reader) {
        XmlElement xmlElement = XmlSource.read(reader);
        this.read(xmlElement);
    }

    public void read(XmlElement xmlElement) {
        Vector vector = xmlElement.getChildren();
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                try {
                    XmlElement xmlElement2 = (XmlElement)vector.elementAt(i);
                    String string = xmlElement2.getAttribute("filename");
                    if (string == null) continue;
                    this.readDataSource(string, xmlElement2);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    protected void readDataSource(String string, XmlElement xmlElement) {
        try {
            BufferedReader bufferedReader = this.currentProject.getBufferedReader(string, null);
            XmlElement xmlElement2 = XmlSource.read(bufferedReader);
            String string2 = xmlElement.getAttribute("type");
            if (string2 == null || string2.length() == 0) {
                this.loadTable(xmlElement2, this.currentProject.getModel());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadTable(XmlElement xmlElement, XModel xModel) {
        Object object;
        xModel.setTagName(xmlElement.getName());
        Vector vector = xmlElement.getChildren();
        Enumeration enumeration = xmlElement.enumerateAttributeNames();
        boolean bl = false;
        int n = vector.size();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++n2;
        }
        xModel.setNumAttributes(n2);
        enumeration = xmlElement.enumerateAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            object = xmlElement.getAttribute(string);
            xModel.setAttribValue(xModel.getAttribute(string), object);
        }
        if (useValueAsId && xmlElement.getAttribute("value") == null) {
            xModel.setAttribValue(xModel.getAttribute("value"), xmlElement.getAttribute("id"));
        }
        for (int i = 0; i < n; ++i) {
            object = (XmlElement)vector.elementAt(i);
            String string = object.getAttribute("id");
            if (string == null || string.toString().length() == 0) {
                if (useValueAsId) {
                    string = object.getAttribute("value");
                } else {
                    string = String.valueOf(this.getNextId());
                    bl = true;
                }
            }
            XModel xModel2 = (XModel)xModel.get(string);
            xModel2.hasAutoId(bl);
            xModel2.setNumChildren(Math.max(xModel2.getNumChildren(), object.getChildren().size()));
            this.loadTable((XmlElement)object, xModel2);
        }
    }

    private int getNextId() {
        return nextId++;
    }

    public void write(Writer writer) {
        this.write(writer, this.currentProject.getModel());
    }

    public void write(Writer writer, XModel xModel) {
        try {
            XDataSource.outputModel(writer, xModel);
            writer.flush();
            writer.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void outputModel(Writer writer, XModel xModel) {
        try {
            XmlElement xmlElement = XmlParserFactory.getInstance().createXmlElement(xModel.getTagName());
            XDataSource.outputModel(xmlElement, xModel);
            NanoXmlWriter nanoXmlWriter = new NanoXmlWriter(writer);
            nanoXmlWriter.write(xmlElement, true, 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void outputModel(XmlElement xmlElement, XModel xModel) {
        Object object;
        Object object2;
        int n;
        for (n = 0; n < xModel.getNumAttributes(); ++n) {
            object2 = xModel.getAttribValue(n);
            object = xModel.getAttribName(n);
            if (object2 == null || object2.toString().length() <= 0) continue;
            String string = object2.toString();
            if (((String)object).compareTo("name") == 0 && xModel.hasAutoId()) continue;
            xmlElement.setAttribute((String)object, string);
        }
        for (n = 0; n < xModel.getNumChildren(); ++n) {
            object2 = xModel.get(n);
            object = xmlElement.createElement(((XModel)object2).getTagName());
            xmlElement.addChild((XmlElement)object);
            XDataSource.outputModel((XmlElement)object, (XModel)object2);
        }
    }

    public void outputModel(String string, XModel xModel) {
        if (string != null) {
            try {
                if (string.length() > 1) {
                    FileOutputStream fileOutputStream = new FileOutputStream(string);
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
                    BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
                    XDataSource.outputModel(bufferedWriter, this.currentProject.getModel());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setUseValueAsId(boolean bl) {
        useValueAsId = bl;
    }
}

