/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.builder.w3c.html.tags;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import net.xoetrope.builder.w3c.html.XHtmlBuilder;
import net.xoetrope.builder.w3c.html.XHtmlFormLayout;
import net.xoetrope.builder.w3c.html.XHtmlStyle;
import net.xoetrope.xui.XComponentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XHtmlTagHandler {
    protected XHtmlTagHandler parent;
    protected JComponent comp;
    protected MutableAttributeSet attribSet;
    protected String content = "";
    protected ArrayList<XHtmlTagHandler> children;
    protected Container parentComponent;
    protected XHtmlBuilder builder;
    protected XHtmlStyle style;

    public String getComponentName() {
        if (this.attribSet != null) {
            Object object = this.getAttribute(HTML.Attribute.ID);
            if (object == null) {
                object = this.getAttribute(HTML.Attribute.NAME);
            }
            return object.toString();
        }
        return null;
    }

    public void startProcessing(XHtmlBuilder xHtmlBuilder, XComponentFactory xComponentFactory, MutableAttributeSet mutableAttributeSet) {
        this.attribSet = (MutableAttributeSet)((SimpleAttributeSet)mutableAttributeSet).clone();
        this.parentComponent = (Container)xComponentFactory.getParentComponent();
        this.builder = xHtmlBuilder;
    }

    public void endProcessing(XComponentFactory xComponentFactory) {
        if (this.comp != null) {
            this.builder.setComponentAttribute(Integer.toString(this.comp.hashCode()), "tagHandler", this);
        }
    }

    public void processComment(String string) {
    }

    public void processText(XComponentFactory xComponentFactory, String string) {
        this.content = this.content + string;
    }

    public void processCommonAttributes(String string, Object object) {
        if (string != null) {
            if (this.comp != null) {
                if (string.equals("id") || string.equals("name")) {
                    this.comp.setName((String)object);
                } else if (string.equals("alt")) {
                    this.comp.setToolTipText((String)object);
                } else if (string.equals("bgcolor")) {
                    this.comp.setOpaque(true);
                    this.comp.setBackground(XHtmlBuilder.getColor((String)object));
                } else if (string.equals("class")) {
                    this.builder.setClass(this.comp, object.toString());
                } else if (string.equals("disabled")) {
                    this.comp.setEnabled(false);
                }
            }
            if (string.equals("style")) {
                this.applyStyle((String)object);
            } else if (string.equals("align")) {
                this.applyAlignment((String)object);
            } else if (string.startsWith("on")) {
                this.builder.processEvent(this, string, (String)object);
            }
        }
    }

    public boolean addElement(XHtmlTagHandler xHtmlTagHandler) {
        return false;
    }

    public abstract XHtmlTagHandler newInstance(XHtmlBuilder var1, XHtmlTagHandler var2);

    public void setParent(XHtmlTagHandler xHtmlTagHandler) {
        this.parent = xHtmlTagHandler;
    }

    public XHtmlTagHandler getParent() {
        return this.parent;
    }

    public void setBuilder(XHtmlBuilder xHtmlBuilder) {
        this.builder = xHtmlBuilder;
    }

    public ArrayList<XHtmlTagHandler> getChildren() {
        return this.children;
    }

    public void addChild(XHtmlTagHandler xHtmlTagHandler) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(xHtmlTagHandler);
    }

    public Object getAttribute(HTML.Attribute attribute) {
        return this.attribSet.getAttribute(attribute);
    }

    public JComponent getComponent() {
        return this.comp;
    }

    public void setComponent(JComponent jComponent) {
        this.comp = jComponent;
    }

    public boolean decorateAttribute(Object object) {
        if (this.parent != null) {
            this.parent.decorateAttribute(object);
        }
        return false;
    }

    public void applyStyle(String string) {
        this.style = new XHtmlStyle(null);
        this.style.parse(string);
        Color color = this.style.getForeground(false);
        if (color != null) {
            this.comp.setForeground(color);
        }
        if ((color = this.style.getBackground(false)) != null) {
            this.comp.setBackground(color);
            this.comp.setOpaque(true);
        }
        this.comp.setFont(this.style.getFont());
        String string2 = this.style.getAttribute("text-align");
        LayoutManager layoutManager = this.comp.getLayout();
        if (layoutManager instanceof XHtmlFormLayout) {
            ((XHtmlFormLayout)layoutManager).setAlignment(string2);
        } else if (string2 != null && this.comp instanceof JTextArea) {
            ((JTextArea)this.comp).setText("<p align=\"" + string2 + "\"s>" + ((JTextArea)this.comp).getText() + "</p>");
        }
    }

    public void applyAlignment(String string) {
        LayoutManager layoutManager;
        if (this.comp != null && (layoutManager = this.comp.getLayout()) instanceof XHtmlFormLayout) {
            ((XHtmlFormLayout)layoutManager).setAlignment(string);
        }
    }

    public double getLength(String string) {
        if (string == null) {
            return 0.0;
        }
        int n = string.indexOf(37);
        if (n > 0) {
            return (double)Integer.parseInt(string.substring(0, n)) / 100.0;
        }
        if (string.equals("1")) {
            return 1.000001;
        }
        return Double.parseDouble(string);
    }

    public int getWidth(Dimension dimension) {
        double d;
        String string = (String)this.attribSet.getAttribute(HTML.Attribute.WIDTH);
        if (string == null && this.style != null) {
            string = this.style.getAttribute("width");
        }
        if ((d = this.getLength(string)) < 1.0E-4) {
            return 0;
        }
        return this.getWidth(dimension, d);
    }

    public int getWidth(Dimension dimension, double d) {
        if (d <= 1.0) {
            return (int)((double)dimension.width * d);
        }
        return (int)d;
    }

    public int getHeight(Dimension dimension) {
        String string = (String)this.attribSet.getAttribute(HTML.Attribute.HEIGHT);
        double d = this.getLength(string);
        if (d < 1.0E-4) {
            return 0;
        }
        return this.getHeight(dimension, d);
    }

    public int getHeight(Dimension dimension, double d) {
        if (d <= 1.0) {
            return (int)((double)dimension.height * d);
        }
        return (int)d;
    }

    public String getContent() {
        return this.content;
    }

    public String getTextStyleAttributes(JComponent jComponent, boolean bl) {
        String string = bl ? "<" : "</";
        Enumeration<?> enumeration = this.attribSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            String string2 = obj.toString();
            Object object = this.attribSet.getAttribute(obj);
            if (object == null || !string2.equals("align")) continue;
            if (object.toString().equals("center")) {
                return string + "center>";
            }
            if (!object.toString().equals("right")) continue;
            return string + "p" + (bl ? " align=\"right\">" : ">");
        }
        return "";
    }

    public boolean breaksFlow() {
        return false;
    }
}

