/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.builder.w3c.html.tags;

import info.clearthought.layout.TableLayout;
import info.clearthought.layout.TableLayoutConstraints;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.border.LineBorder;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import net.xoetrope.builder.w3c.html.XHtmlBuilder;
import net.xoetrope.builder.w3c.html.tags.Col;
import net.xoetrope.builder.w3c.html.tags.Td;
import net.xoetrope.builder.w3c.html.tags.XHtmlTagHandler;
import net.xoetrope.swing.XPanel;
import net.xoetrope.xui.XComponentFactory;

public class Table
extends XHtmlTagHandler {
    protected String alignment = "left";
    protected double cellSpacing = 0.0;
    protected double cellPadding = 0.0;
    protected double width = 1.0;
    protected int numRows;
    protected int numCols;
    protected int border;

    public XHtmlTagHandler newInstance(XHtmlBuilder xHtmlBuilder, XHtmlTagHandler xHtmlTagHandler) {
        Table table = new Table();
        table.setParent(xHtmlTagHandler);
        table.setBuilder(xHtmlBuilder);
        return table;
    }

    public void startProcessing(XHtmlBuilder xHtmlBuilder, XComponentFactory xComponentFactory, MutableAttributeSet mutableAttributeSet) {
        super.startProcessing(xHtmlBuilder, xComponentFactory, mutableAttributeSet);
        this.comp = (JComponent)xComponentFactory.addComponent("panel", null, "");
        this.comp.setOpaque(false);
        xComponentFactory.setParentComponent(this.comp);
    }

    public void endProcessing(XComponentFactory xComponentFactory) {
        int n;
        Object object;
        Object object2;
        super.endProcessing(xComponentFactory);
        this.numCols = 0;
        this.numRows = 0;
        this.numCols = Math.max(1, this.getNumCols(this));
        this.numRows = Math.max(1, this.getNumRows());
        Enumeration<?> enumeration = this.attribSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            String string = object2.toString();
            Object object3 = this.attribSet.getAttribute(object2);
            if (object3 == null) continue;
            if (string.equals("align")) {
                this.alignment = (String)object3;
                continue;
            }
            if (string.equals("width")) {
                this.width = this.getLength((String)object3);
                continue;
            }
            if (string.equals("cellspacing")) {
                this.cellSpacing = this.getLength((String)object3);
                continue;
            }
            if (string.equals("cellspacing")) {
                this.cellPadding = this.getLength((String)object3);
                continue;
            }
            if (string.equals("border")) {
                this.border = Integer.parseInt((String)object3);
                if (this.border <= 0) continue;
                object = Color.darkGray;
                Object object4 = this.attribSet.getAttribute("bordercolor");
                if (object4 != null) {
                    object = XHtmlBuilder.getColor((String)object4);
                }
                this.comp.setBorder(new LineBorder((Color)object, this.border));
                continue;
            }
            this.processCommonAttributes(string, object3);
        }
        object2 = new TableLayout();
        int n2 = this.getWidth(this.comp.getSize(), this.cellSpacing);
        object2.setHGap(n2);
        object2.setVGap(n2);
        for (n = 0; n < this.numRows; ++n) {
            object2.insertRow(n, -2.0);
        }
        for (n = 0; n < this.numCols; ++n) {
            object2.insertColumn(n, -1.0);
        }
        this.comp.setLayout((LayoutManager)object2);
        object = new int[this.numCols];
        this.addChildren((XPanel)this.comp, (TableLayout)object2, (int[])object);
        int n3 = this.comp.getComponentCount();
        for (n = 0; n < n3; ++n) {
            JComponent jComponent = (JComponent)this.comp.getComponent(n);
            TableLayoutConstraints tableLayoutConstraints = object2.getConstraints((Component)jComponent);
            int n4 = jComponent.getComponentCount();
            if (n4 <= 1) continue;
            object2.setColumn(tableLayoutConstraints.col1, -1.0);
        }
        if (XHtmlBuilder.isDebugLayout()) {
            this.comp.setBorder(new LineBorder(Color.blue, 2));
        }
        xComponentFactory.setParentComponent(this.parentComponent);
    }

    protected int getNumCols(XHtmlTagHandler xHtmlTagHandler) {
        int n = 0;
        ArrayList<XHtmlTagHandler> arrayList = xHtmlTagHandler.getChildren();
        if (arrayList != null) {
            for (XHtmlTagHandler xHtmlTagHandler2 : arrayList) {
                if (!(xHtmlTagHandler2 instanceof Col)) continue;
                Col col = (Col)xHtmlTagHandler2;
                if (col.tag.equals("col")) {
                    n += col.getNumCols();
                    continue;
                }
                int n2 = this.getNumCols(col);
                if (n2 == 0) {
                    n2 = col.getNumCols();
                }
                n += n2;
            }
            if (n == 0) {
                for (XHtmlTagHandler xHtmlTagHandler2 : arrayList) {
                    if (!(xHtmlTagHandler2 instanceof Td)) continue;
                    n = Math.max(n, ((Td)xHtmlTagHandler2).getNumCols());
                }
            }
        }
        return Math.max(1, n);
    }

    protected int getNumRows() {
        ArrayList arrayList = this.children;
        if (arrayList != null) {
            for (XHtmlTagHandler xHtmlTagHandler : arrayList) {
                if (!(xHtmlTagHandler instanceof Td)) continue;
                Td td = (Td)xHtmlTagHandler;
                if ("thtr".indexOf(td.tag.toString()) < 0) continue;
                ++this.numRows;
            }
        }
        return this.numRows;
    }

    public int getHorizontalPadding() {
        return this.getWidth(this.comp.getSize(), this.cellPadding);
    }

    public int getVerticalPadding() {
        return this.getHeight(this.comp.getSize(), this.cellPadding);
    }

    public int getBorderWidth() {
        return this.border;
    }

    protected void addChildren(XPanel xPanel, TableLayout tableLayout, int[] nArray) {
        int n = 0;
        ArrayList arrayList = this.children;
        if (arrayList != null) {
            for (XHtmlTagHandler xHtmlTagHandler : arrayList) {
                if (!(xHtmlTagHandler instanceof Td)) continue;
                Td td = (Td)xHtmlTagHandler;
                if ("thtr".indexOf(td.tag.toString()) < 0) continue;
                td.addChildren(xPanel, tableLayout, nArray, n++);
            }
        }
    }

    public boolean breaksFlow() {
        return HTML.Tag.TABLE.breaksFlow();
    }
}

