/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.builder.w3c.html;

import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import java.util.StringTokenizer;
import net.xoetrope.builder.w3c.html.XHtmlBuilder;

public class XHtmlStyle {
    protected String className;
    protected Hashtable<String, String> attributes;
    protected Hashtable<String, Object> objects;

    public XHtmlStyle(String string) {
        this.className = string;
        this.attributes = new Hashtable();
        this.objects = new Hashtable();
    }

    public String getAttribute(String string) {
        return this.attributes.get(string);
    }

    public Font getFont() {
        Font font = (Font)this.objects.get("font");
        if (font == null) {
            String string;
            int n = 0;
            String string2 = this.attributes.get("font-style");
            if (string2 != null && string2.equals("italic")) {
                n |= 2;
            }
            if ((string2 = this.attributes.get("font-weight")) != null && string2.equals("bold")) {
                n |= 1;
            }
            int n2 = 12;
            string2 = this.attributes.get("font-size");
            if (string2 != null) {
                if (string2.endsWith("pt")) {
                    string2 = string2.substring(0, string2.length() - 2);
                }
                n2 = Integer.parseInt(string2);
            }
            if ((string = this.attributes.get("font-family")) == null) {
                string = "Helvetica";
            }
            font = new Font(string, n, n2);
        }
        return font;
    }

    public Color getForeground(boolean bl) {
        String string = this.attributes.get("color");
        if (string != null) {
            return XHtmlBuilder.getColor(string);
        }
        return bl ? Color.black : null;
    }

    public Color getBackground(boolean bl) {
        String string = this.attributes.get("background-color");
        if (string == null) {
            string = this.attributes.get("background");
        }
        if (string != null) {
            return XHtmlBuilder.getColor(string);
        }
        return bl ? Color.white : null;
    }

    public void parse(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n = string2.indexOf(58);
            String string3 = string2.substring(0, n);
            this.attributes.put(string3, string2.substring(n + 1).trim());
        }
    }
}

