/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.builder.w3c.html;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import net.xoetrope.builder.XuiBuilder;
import net.xoetrope.builder.w3c.html.XHtmlComponentFactory;
import net.xoetrope.builder.w3c.html.XHtmlFormLayout;
import net.xoetrope.builder.w3c.html.XHtmlStyle;
import net.xoetrope.builder.w3c.html.tags.A;
import net.xoetrope.builder.w3c.html.tags.Address;
import net.xoetrope.builder.w3c.html.tags.BaseFont;
import net.xoetrope.builder.w3c.html.tags.BlockQuote;
import net.xoetrope.builder.w3c.html.tags.Br;
import net.xoetrope.builder.w3c.html.tags.Col;
import net.xoetrope.builder.w3c.html.tags.Div;
import net.xoetrope.builder.w3c.html.tags.Font;
import net.xoetrope.builder.w3c.html.tags.Form;
import net.xoetrope.builder.w3c.html.tags.Hr;
import net.xoetrope.builder.w3c.html.tags.Img;
import net.xoetrope.builder.w3c.html.tags.Input;
import net.xoetrope.builder.w3c.html.tags.Map;
import net.xoetrope.builder.w3c.html.tags.P;
import net.xoetrope.builder.w3c.html.tags.Script;
import net.xoetrope.builder.w3c.html.tags.Select;
import net.xoetrope.builder.w3c.html.tags.Span;
import net.xoetrope.builder.w3c.html.tags.Style;
import net.xoetrope.builder.w3c.html.tags.Table;
import net.xoetrope.builder.w3c.html.tags.Td;
import net.xoetrope.builder.w3c.html.tags.TextArea;
import net.xoetrope.builder.w3c.html.tags.XDataTagHandler;
import net.xoetrope.builder.w3c.html.tags.XDefaultTagHandler;
import net.xoetrope.builder.w3c.html.tags.XFormatTagHandler;
import net.xoetrope.builder.w3c.html.tags.XHeadingTag;
import net.xoetrope.builder.w3c.html.tags.XHtmlTagHandler;
import net.xoetrope.builder.w3c.html.tags.XObjectTagHandler;
import net.xoetrope.builder.w3c.html.tags.XStructuralTagHandler;
import net.xoetrope.xui.PageSupport;
import net.xoetrope.xui.XComponentConstructor;
import net.xoetrope.xui.XComponentFactory;
import net.xoetrope.xui.XPage;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.XProjectManager;

public class XHtmlBuilder
extends XuiBuilder {
    protected static boolean debugLayout = false;
    private static Hashtable swingConstants;
    private static Hashtable<Object, XHtmlTagHandler> htmlTags;
    private Hashtable<String, XHtmlStyle> styles;
    protected String packageName;
    protected String selectStyle = "RadioButton";
    protected XHtmlComponentFactory htmlFactory;
    protected XHtmlTagHandler lastHandler;
    protected static URL documentUrl;

    public XHtmlBuilder(XProject xProject) {
        super(xProject, "net.xoetrope.swing");
        this.setupHtmlTags();
        this.styles = new Hashtable();
        Hashtable hashtable = XComponentFactory.getFactories();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            XComponentConstructor xComponentConstructor = (XComponentConstructor)hashtable.get(enumeration.nextElement());
            if (!(xComponentConstructor instanceof XHtmlComponentFactory)) continue;
            this.htmlFactory = (XHtmlComponentFactory)xComponentConstructor;
            break;
        }
    }

    public static boolean isDebugLayout() {
        return debugLayout;
    }

    public static void setDebugLayout(boolean bl) {
        debugLayout = bl;
    }

    protected InputStream getUrlInputStream(String string) {
        try {
            documentUrl = new URL(string);
            URLConnection uRLConnection = documentUrl.openConnection();
            uRLConnection.setDefaultUseCaches(false);
            uRLConnection.setIfModifiedSince(0L);
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(false);
            uRLConnection.setUseCaches(false);
            uRLConnection.connect();
            InputStream inputStream = uRLConnection.getInputStream();
            return inputStream;
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageSupport loadPage(String string, String string2, boolean bl) {
        Object object;
        this.packageName = string;
        Reader reader = null;
        try {
            object = this.getUrlInputStream(string2);
            if (object != null) {
                reader = new BufferedReader(new InputStreamReader((InputStream)object));
            } else {
                String string3 = string2;
                if (string2.indexOf(".htm") < 0) {
                    string3 = string3 + ".html";
                }
                reader = this.currentProject.getBufferedReader(string3, null);
                documentUrl = this.currentProject.findResource(string3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (reader == null || !reader.ready()) {
                object = null;
                return object;
            }
            object = this.readPage(reader, string2, ".html", bl);
            return object;
        }
        catch (Exception exception) {
        }
        finally {
            if (!bl) {
                this.rootPage = null;
            }
        }
        return null;
    }

    public PageSupport readPage(Reader reader, String string, String string2, boolean bl) {
        try {
            this.setupPage(string, string2, bl);
            HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
            HTMLDocument hTMLDocument = (HTMLDocument)hTMLEditorKit.createDefaultDocument();
            XHtmlBuilderParserCallback xHtmlBuilderParserCallback = new XHtmlBuilderParserCallback(this);
            ParserDelegator parserDelegator = new ParserDelegator();
            hTMLDocument.setPreservesUnknownTags(true);
            hTMLDocument.setParser(parserDelegator);
            hTMLDocument.setPreservesUnknownTags(true);
            parserDelegator.parse(reader, xHtmlBuilderParserCallback, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.page;
    }

    protected void setupPage(String string, String string2, boolean bl) {
        XProjectManager.setCurrentProject(this.currentProject);
        String string3 = "net.xoetrope.xui.XPage";
        if (!bl) {
            if (string3.indexOf(46) <= 0 && this.packageName.length() > 1) {
                string3 = this.packageName + string3;
            }
            try {
                this.page = this.loadClass(string3);
            }
            catch (Exception exception) {
                this.page = new XPage();
            }
            this.setPageName(string);
            this.setPageExtension(string2);
            this.page.setLayout(new XHtmlFormLayout(this));
            this.componentFactory.setParentComponent((Container)((Object)this.page));
        }
        this.rootPage = (XPage)this.page;
    }

    public static URL findResource(String string) {
        try {
            return new URL(documentUrl, string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setComponentAttribute(String string, String string2, Object object) {
        this.page.setAttribute(string, string2, object);
    }

    public Object getComponentAttribute(String string, String string2) {
        return this.page.getAttribute(string, string2);
    }

    public void addScript(String string, String string2, String string3, String string4) {
    }

    public void processEvent(XHtmlTagHandler xHtmlTagHandler, String string, String string2) {
    }

    protected void setupHtmlTags() {
        if (htmlTags == null) {
            htmlTags = new Hashtable();
            htmlTags.put(HTML.Tag.A, new A());
            htmlTags.put(HTML.Tag.ADDRESS, new Address());
            htmlTags.put(HTML.Tag.APPLET, new XObjectTagHandler(HTML.Tag.APPLET));
            htmlTags.put(HTML.Tag.AREA, new XDataTagHandler(HTML.Tag.AREA));
            htmlTags.put(HTML.Tag.B, new XFormatTagHandler(HTML.Tag.B));
            htmlTags.put(HTML.Tag.BASEFONT, new BaseFont());
            htmlTags.put(HTML.Tag.BIG, new XFormatTagHandler(HTML.Tag.BIG));
            htmlTags.put(HTML.Tag.BLOCKQUOTE, new BlockQuote());
            htmlTags.put(HTML.Tag.BODY, new XStructuralTagHandler(HTML.Tag.BODY));
            htmlTags.put(HTML.Tag.BR, new Br());
            htmlTags.put(HTML.Tag.CAPTION, new XDataTagHandler(HTML.Tag.CAPTION));
            htmlTags.put(HTML.Tag.CENTER, new Div(HTML.Tag.CENTER));
            htmlTags.put(HTML.Tag.CITE, new XFormatTagHandler(HTML.Tag.CITE));
            htmlTags.put(HTML.Tag.CODE, new XFormatTagHandler(HTML.Tag.CODE));
            htmlTags.put("col", new Col("col"));
            htmlTags.put("colgroup", new Col("colgroup"));
            htmlTags.put(HTML.Tag.DD, new XDataTagHandler(HTML.Tag.DD));
            htmlTags.put(HTML.Tag.DFN, new XFormatTagHandler(HTML.Tag.DFN));
            htmlTags.put(HTML.Tag.DIV, new Div(HTML.Tag.DIV));
            htmlTags.put(HTML.Tag.DL, new XDataTagHandler(HTML.Tag.DL));
            htmlTags.put(HTML.Tag.DT, new XDataTagHandler(HTML.Tag.DT));
            htmlTags.put(HTML.Tag.EM, new XFormatTagHandler(HTML.Tag.EM));
            htmlTags.put(HTML.Tag.FONT, new Font());
            htmlTags.put(HTML.Tag.FORM, new Form());
            htmlTags.put(HTML.Tag.H1, new XHeadingTag(HTML.Tag.H1));
            htmlTags.put(HTML.Tag.H2, new XHeadingTag(HTML.Tag.H2));
            htmlTags.put(HTML.Tag.H3, new XHeadingTag(HTML.Tag.H3));
            htmlTags.put(HTML.Tag.H4, new XHeadingTag(HTML.Tag.H4));
            htmlTags.put(HTML.Tag.H5, new XHeadingTag(HTML.Tag.H5));
            htmlTags.put(HTML.Tag.H6, new XHeadingTag(HTML.Tag.H6));
            htmlTags.put(HTML.Tag.HEAD, new XStructuralTagHandler(HTML.Tag.HEAD));
            htmlTags.put(HTML.Tag.HR, new Hr());
            htmlTags.put(HTML.Tag.HTML, new XStructuralTagHandler(HTML.Tag.HTML));
            htmlTags.put(HTML.Tag.I, new XFormatTagHandler(HTML.Tag.I));
            htmlTags.put(HTML.Tag.IMG, new Img());
            htmlTags.put(HTML.Tag.INPUT, new Input());
            htmlTags.put(HTML.Tag.KBD, new XFormatTagHandler(HTML.Tag.KBD));
            htmlTags.put(HTML.Tag.LI, new XDataTagHandler(HTML.Tag.LI));
            htmlTags.put(HTML.Tag.LINK, new XDataTagHandler(HTML.Tag.LINK));
            htmlTags.put(HTML.Tag.MAP, new Map());
            htmlTags.put(HTML.Tag.META, new XDataTagHandler(HTML.Tag.META));
            htmlTags.put(HTML.Tag.OBJECT, new XFormatTagHandler(HTML.Tag.OBJECT));
            htmlTags.put(HTML.Tag.OL, new XDataTagHandler(HTML.Tag.OL));
            htmlTags.put(HTML.Tag.OPTION, new XDataTagHandler(HTML.Tag.OPTION));
            htmlTags.put(HTML.Tag.P, new P());
            htmlTags.put(HTML.Tag.PARAM, new XDataTagHandler(HTML.Tag.PARAM));
            htmlTags.put(HTML.Tag.PRE, new XFormatTagHandler(HTML.Tag.PRE));
            htmlTags.put(HTML.Tag.SAMP, new XFormatTagHandler(HTML.Tag.SAMP));
            htmlTags.put(HTML.Tag.SCRIPT, new Script());
            htmlTags.put(HTML.Tag.SELECT, new Select());
            htmlTags.put(HTML.Tag.SMALL, new XFormatTagHandler(HTML.Tag.SMALL));
            htmlTags.put(HTML.Tag.SPAN, new Span());
            htmlTags.put(HTML.Tag.STRIKE, new XFormatTagHandler(HTML.Tag.STRIKE));
            htmlTags.put(HTML.Tag.S, new XFormatTagHandler(HTML.Tag.S));
            htmlTags.put(HTML.Tag.STRONG, new XFormatTagHandler(HTML.Tag.STRONG));
            htmlTags.put(HTML.Tag.STYLE, new Style());
            htmlTags.put(HTML.Tag.SUB, new XFormatTagHandler(HTML.Tag.SUB));
            htmlTags.put(HTML.Tag.SUP, new XFormatTagHandler(HTML.Tag.SUP));
            htmlTags.put(HTML.Tag.TABLE, new Table());
            htmlTags.put(HTML.Tag.TD, new Td(HTML.Tag.TD));
            htmlTags.put(HTML.Tag.TEXTAREA, new TextArea());
            htmlTags.put(HTML.Tag.TH, new Td(HTML.Tag.TH));
            htmlTags.put(HTML.Tag.TITLE, new XDataTagHandler(HTML.Tag.TITLE));
            htmlTags.put(HTML.Tag.TR, new Td(HTML.Tag.TR));
            htmlTags.put(HTML.Tag.TT, new XFormatTagHandler(HTML.Tag.TT));
            htmlTags.put(HTML.Tag.U, new XFormatTagHandler(HTML.Tag.U));
            htmlTags.put(HTML.Tag.UL, new XDataTagHandler(HTML.Tag.UL));
            htmlTags.put(HTML.Tag.VAR, new XDataTagHandler(HTML.Tag.VAR));
        }
    }

    public XHtmlTagHandler getTagHandler(HTML.Tag tag) {
        XHtmlTagHandler xHtmlTagHandler = htmlTags.get(tag);
        if (xHtmlTagHandler != null) {
            xHtmlTagHandler = xHtmlTagHandler.newInstance(this, this.lastHandler);
        } else {
            xHtmlTagHandler = new XDefaultTagHandler(tag);
            xHtmlTagHandler.setParent(this.lastHandler);
        }
        return xHtmlTagHandler;
    }

    public void setClass(Component component, String string) {
        XHtmlStyle xHtmlStyle = this.styles.get(string);
        if (xHtmlStyle == null) {
            xHtmlStyle = new XHtmlStyle(string);
            this.styles.put(string, xHtmlStyle);
        }
        component.setForeground(xHtmlStyle.getForeground(false));
        component.setBackground(xHtmlStyle.getBackground(false));
        component.setFont(xHtmlStyle.getFont());
    }

    public void setupStyle(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "}");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() == 0) continue;
            int n = string2.indexOf(123);
            String string3 = string2.substring(0, n - 1).trim();
            if (string3.charAt(0) == '.') {
                string3 = string3.substring(1);
            }
            String string4 = string2.substring(n + 1);
            XHtmlStyle xHtmlStyle = this.styles.get(string3);
            if (xHtmlStyle == null) {
                xHtmlStyle = new XHtmlStyle(string3);
                this.styles.put(string3, xHtmlStyle);
            }
            xHtmlStyle.parse(string4);
        }
    }

    public static Color getColor(String string) {
        String string2 = string.toLowerCase();
        if (string2.equals("black")) {
            return Color.black;
        }
        if (string2.equals("silver")) {
            return new Color(192, 192, 192);
        }
        if (string2.equals("gray")) {
            return new Color(128, 128, 128);
        }
        if (string2.equals("white")) {
            return Color.white;
        }
        if (string2.equals("maroon")) {
            return new Color(128, 0, 0);
        }
        if (string2.equals("red")) {
            return Color.red;
        }
        if (string2.equals("purple")) {
            return new Color(128, 0, 128);
        }
        if (string2.equals("fuchsia")) {
            return new Color(255, 0, 255);
        }
        if (string2.equals("green")) {
            return new Color(0, 128, 0);
        }
        if (string2.equals("lime")) {
            return new Color(0, 255, 0);
        }
        if (string2.equals("olive")) {
            return new Color(128, 128, 0);
        }
        if (string2.equals("yellow")) {
            return Color.yellow;
        }
        if (string2.equals("navy")) {
            return new Color(0, 0, 128);
        }
        if (string2.equals("blue")) {
            return Color.blue;
        }
        if (string2.equals("teal")) {
            return new Color(0, 128, 128);
        }
        if (string2.equals("aqua")) {
            return new Color(0, 255, 255);
        }
        if (string2.startsWith("rgb")) {
            string2 = string2.substring(string2.indexOf(40) + 1);
            int n = string2.indexOf(",");
            int n2 = Integer.parseInt(string2.substring(0, n++).trim());
            int n3 = string2.indexOf(",", n);
            int n4 = Integer.parseInt(string2.substring(n, n3).trim());
            int n5 = Integer.parseInt(string2.substring(++n3, string2.indexOf(")")).trim());
            return new Color(n2, n4, n5);
        }
        int n = Integer.parseInt(string2.substring(1, 3), 16);
        int n6 = Integer.parseInt(string2.substring(3, 5), 16);
        int n7 = Integer.parseInt(string2.substring(5, 7), 16);
        return new Color(n, n6, n7);
    }

    public static int getSwingConstant(String string) {
        String string2 = string.toUpperCase();
        if (swingConstants == null) {
            swingConstants = new Hashtable();
            swingConstants.put("CENTER", new Integer(0));
            swingConstants.put("TOP", new Integer(1));
            swingConstants.put("LEFT", new Integer(2));
            swingConstants.put("BOTTOM", new Integer(3));
            swingConstants.put("RIGHT", new Integer(4));
            swingConstants.put("NORTH", new Integer(1));
            swingConstants.put("NORTH_EAST", new Integer(2));
            swingConstants.put("EAST", new Integer(3));
            swingConstants.put("SOUTH_EAST", new Integer(4));
            swingConstants.put("SOUTH", new Integer(5));
            swingConstants.put("SOUTH_WEST", new Integer(6));
            swingConstants.put("WEST", new Integer(7));
            swingConstants.put("NORTH_WEST", new Integer(8));
            swingConstants.put("HORIZONTAL", new Integer(0));
            swingConstants.put("VERTICAL", new Integer(1));
            swingConstants.put("LEADING", new Integer(10));
            swingConstants.put("TRAILING", new Integer(11));
            swingConstants.put("NEXT", new Integer(12));
            swingConstants.put("PREVIOUS", new Integer(13));
        }
        return (Integer)swingConstants.get(string2);
    }

    static {
        htmlTags = null;
    }

    private class XHtmlBuilderParserCallback
    extends HTMLEditorKit.ParserCallback {
        private HTML.Tag lastTag;
        private XHtmlBuilder builder;

        public XHtmlBuilderParserCallback(XHtmlBuilder xHtmlBuilder2) {
            this.builder = xHtmlBuilder2;
        }

        public void handleText(char[] cArray, int n) {
            super.handleText(cArray, n);
            XHtmlBuilder.this.lastHandler.processText(XHtmlBuilder.this.componentFactory, new String(cArray));
        }

        public void handleComment(char[] cArray, int n) {
            super.handleComment(cArray, n);
            XHtmlBuilder.this.lastHandler.processComment(new String(cArray));
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            super.handleStartTag(tag, mutableAttributeSet, n);
            this.lastTag = tag;
            XHtmlTagHandler xHtmlTagHandler = XHtmlBuilder.this.getTagHandler(tag);
            xHtmlTagHandler.startProcessing(this.builder, XHtmlBuilder.this.componentFactory, mutableAttributeSet);
            XHtmlBuilder.this.lastHandler = xHtmlTagHandler;
        }

        public void handleEndTag(HTML.Tag tag, int n) {
            super.handleEndTag(tag, n);
            if (XHtmlBuilder.this.lastHandler != null) {
                XHtmlBuilder.this.lastHandler.endProcessing(XHtmlBuilder.this.componentFactory);
                XHtmlTagHandler xHtmlTagHandler = XHtmlBuilder.this.lastHandler.getParent();
                if (xHtmlTagHandler != null) {
                    xHtmlTagHandler.addChild(XHtmlBuilder.this.lastHandler);
                }
                XHtmlBuilder.this.lastHandler = xHtmlTagHandler;
            }
        }

        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            super.handleSimpleTag(tag, mutableAttributeSet, n);
            this.lastTag = tag;
            XHtmlTagHandler xHtmlTagHandler = XHtmlBuilder.this.getTagHandler(tag);
            xHtmlTagHandler.startProcessing(this.builder, XHtmlBuilder.this.componentFactory, mutableAttributeSet);
            XHtmlBuilder.this.lastHandler = xHtmlTagHandler;
            if (XHtmlBuilder.this.lastHandler != null) {
                XHtmlBuilder.this.lastHandler.endProcessing(XHtmlBuilder.this.componentFactory);
                XHtmlTagHandler xHtmlTagHandler2 = XHtmlBuilder.this.lastHandler.getParent();
                if (xHtmlTagHandler2 != null) {
                    xHtmlTagHandler2.addChild(XHtmlBuilder.this.lastHandler);
                }
                XHtmlBuilder.this.lastHandler = xHtmlTagHandler2;
            }
        }

        public void handleError(String string, int n) {
            super.handleError(string, n);
        }
    }
}

