/*
 * Decompiled with CFR 0.152.
 */
package net.xoetrope.builder;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.xoetrope.builder.BuilderSupport;
import net.xoetrope.debug.DebugLogger;
import net.xoetrope.registry.ComponentAdapter;
import net.xoetrope.registry.ComponentCustomizer;
import net.xoetrope.xml.XmlElement;
import net.xoetrope.xml.XmlSource;
import net.xoetrope.xui.PageSupport;
import net.xoetrope.xui.WidgetAdapter;
import net.xoetrope.xui.XAppender;
import net.xoetrope.xui.XAttributedComponent;
import net.xoetrope.xui.XAttributedComponentEx;
import net.xoetrope.xui.XContentHolder;
import net.xoetrope.xui.XContentPane;
import net.xoetrope.xui.XMultiAttributedComponent;
import net.xoetrope.xui.XPageDisplay;
import net.xoetrope.xui.XPageLoader;
import net.xoetrope.xui.XProject;
import net.xoetrope.xui.XProjectManager;
import net.xoetrope.xui.XRadioButtonGroup;
import net.xoetrope.xui.XTextHolder;
import net.xoetrope.xui.data.XBasicDataBindingFactory;
import net.xoetrope.xui.data.XDataBinding;
import net.xoetrope.xui.data.XDataBindingFactory;
import net.xoetrope.xui.data.XRegisteredDataBindingFactory;
import net.xoetrope.xui.evaluator.XAttributeEvaluator;
import net.xoetrope.xui.evaluator.XDefaultAttributeEvaluator;
import net.xoetrope.xui.events.XuiEventHandler;
import net.xoetrope.xui.helper.ReflectionHelper;
import net.xoetrope.xui.helper.XAttributedComponentHelper;
import net.xoetrope.xui.helper.XLayoutHelper;
import net.xoetrope.xui.style.XStyle;
import net.xoetrope.xui.style.XStyleFactory;
import net.xoetrope.xui.validation.XValidationFactory;

public class XuiBuilder
implements XPageLoader {
    protected String packageName;
    protected XStyleFactory componentFactory;
    protected Object checkBoxGroup;
    protected PageSupport page;
    protected PageSupport rootPage;
    protected XAppender menuBar;
    protected Hashtable validationFactories;
    protected Hashtable attributeSets;
    protected static Hashtable currentAttributes;
    protected XLayoutHelper layoutHelper;
    private static int nextChildId;
    protected XProject currentProject;
    protected WidgetAdapter adapter;
    protected ComponentCustomizer customizer;
    protected XAttributeEvaluator evaluator;
    protected XuiEventHandler eventHandler;
    protected ClassLoader secondaryClassloader;
    protected String includeFileName;
    public static final String DEFAULT_PAGE_CLASS = "net.xoetrope.xui.XPage";

    public XuiBuilder(XProject xProject) {
        this.currentProject = xProject;
        this.init("net.xoetrope.awt");
    }

    public XuiBuilder(XProject xProject, String string) {
        this.currentProject = xProject;
        this.init(string);
    }

    protected void init(String string) {
        Object object = this.currentProject.getObject("Builder");
        if (object == null) {
            this.currentProject.setObject("Builder", this);
        }
        this.adapter = WidgetAdapter.getInstance();
        if (string == null) {
            string = "net.xoetrope.awt";
        }
        this.validationFactories = new Hashtable(2);
        this.componentFactory = new XStyleFactory(this.currentProject, string);
        this.layoutHelper = (XLayoutHelper)this.currentProject.getObject("LayoutHelper");
        XBasicDataBindingFactory.register(this.currentProject);
        XRegisteredDataBindingFactory.register(this.currentProject);
        this.evaluator = (XDefaultAttributeEvaluator)this.currentProject.getObject("DefaultAttributeEvaluator");
        if (this.evaluator == null) {
            this.evaluator = new XDefaultAttributeEvaluator(this.currentProject);
            this.evaluator.setCurrentProject(this.currentProject);
            this.currentProject.setObject("DefaultAttributeEvaluator", this.evaluator);
        }
        this.customizer = (ComponentCustomizer)this.currentProject.getObject("ComponentCustomizer");
        if (this.customizer == null) {
            this.customizer = new ComponentCustomizer(this.currentProject);
            this.currentProject.setObject("ComponentCustomizer", this.customizer);
            try {
                BufferedReader bufferedReader = this.currentProject.getBufferedReader("customizations.xml");
                if (bufferedReader != null) {
                    this.customizer.read(bufferedReader);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.secondaryClassloader = classLoader;
    }

    public void setPackageName(String string) {
        this.packageName = string == null ? "net.xoetrope.awt" : string;
        this.componentFactory = new XStyleFactory(this.currentProject, this.packageName);
    }

    public void setPage(PageSupport pageSupport) {
        this.page = pageSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageSupport loadPage(String string, String string2, boolean bl) {
        this.packageName = string;
        Reader reader = null;
        try {
            reader = this.currentProject.getBufferedReader(string2 + ".xml", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (reader == null || !reader.ready()) {
                PageSupport pageSupport = null;
                return pageSupport;
            }
            PageSupport pageSupport = this.readPage(reader, string2, ".xml", bl);
            return pageSupport;
        }
        catch (Exception exception) {
        }
        finally {
            if (!bl) {
                this.rootPage = null;
            }
        }
        return null;
    }

    public boolean loadFrames(String string, String string2, XPageDisplay xPageDisplay, boolean bl) {
        if (!bl) {
            this.loadSingleTarget(xPageDisplay);
            return true;
        }
        boolean bl2 = xPageDisplay.getNumTargets() == 0;
        this.packageName = string;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = this.currentProject.getBufferedReader(string2 + ".xml", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bufferedReader == null) {
            this.loadSingleTarget(xPageDisplay);
            return true;
        }
        XmlElement xmlElement = XmlSource.read(bufferedReader);
        Vector vector = xmlElement.getChildren();
        int n = vector.size();
        if (n == 0) {
            if (!"NONE".equals(this.currentProject.getStartupParam("DefaultTarget"))) {
                this.loadSingleTarget(xPageDisplay);
            }
            return true;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration enumeration = xmlElement.enumerateAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            hashtable.put(string3, xmlElement.getAttribute(string3));
        }
        xPageDisplay.setupFrameset(hashtable);
        for (int i = 0; i < n; ++i) {
            Object object;
            XmlElement xmlElement2 = (XmlElement)vector.elementAt(i);
            String string4 = xmlElement2.getName();
            String string5 = xmlElement2.getAttribute("name");
            String string6 = xmlElement2.getAttribute("content");
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            Enumeration enumeration2 = xmlElement2.enumerateAttributeNames();
            while (enumeration2.hasMoreElements()) {
                object = (String)enumeration2.nextElement();
                hashtable2.put((String)object, xmlElement2.getAttribute((String)object));
            }
            if (string4.equals("Frame")) {
                try {
                    XContentHolder xContentHolder;
                    object = this.layoutHelper.getConstraint(xmlElement2.getAttribute("constraint"));
                    int n2 = new Integer(xmlElement2.getAttribute("width"));
                    int n3 = new Integer(xmlElement2.getAttribute("height"));
                    if (bl2) {
                        xContentHolder = xPageDisplay.addTarget(string5, object, n2, n3, hashtable2);
                    } else {
                        xContentHolder = (XContentHolder)xPageDisplay.findTarget(string5);
                        xContentHolder.setup(string5, n2, n3, hashtable2);
                    }
                    if (string6 == null) continue;
                    xContentHolder.setContent(string6);
                    PageSupport pageSupport = this.currentProject.getPageManager().loadPage(string6);
                    xPageDisplay.displayPage(pageSupport, string5);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
                continue;
            }
            if (!string4.equals("Toolbar")) continue;
            object = xmlElement2.getAttribute("constraint");
            PageSupport pageSupport = this.currentProject.getPageManager().loadPage(string6);
            xPageDisplay.displayDecoration(pageSupport, (String)object);
        }
        xPageDisplay.doLayout();
        return true;
    }

    protected void loadSingleTarget(XPageDisplay xPageDisplay) {
        int n = 640;
        int n2 = 480;
        String string = this.currentProject.getStartupParam("ClientWidth");
        if (string != null) {
            n = Integer.parseInt(string);
        }
        if ((string = this.currentProject.getStartupParam("ClientHeight")) != null) {
            n2 = Integer.parseInt(string);
        }
        xPageDisplay.addTarget("content", "Center", n, n2, null);
    }

    public PageSupport readPage(Reader reader, String string, String string2, boolean bl) {
        XmlElement xmlElement = XmlSource.read(reader);
        this.setupPage(xmlElement, string, string2, bl);
        this.eventHandler = this.page.getEventHandler();
        XmlElement xmlElement2 = null;
        XmlElement xmlElement3 = null;
        XmlElement xmlElement4 = null;
        XmlElement xmlElement5 = null;
        XmlElement xmlElement6 = null;
        XmlElement xmlElement7 = null;
        Vector vector = xmlElement.getChildren();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            XmlElement xmlElement8 = (XmlElement)vector.elementAt(i);
            String string3 = xmlElement8.getName().toLowerCase();
            if (string3.equals("components")) {
                xmlElement2 = xmlElement8;
                continue;
            }
            if (string3.equals("events")) {
                xmlElement3 = xmlElement8;
                continue;
            }
            if (string3.equals("data")) {
                xmlElement4 = xmlElement8;
                continue;
            }
            if (string3.equals("validations")) {
                xmlElement6 = xmlElement8;
                continue;
            }
            if (string3.equals("menubar")) {
                xmlElement5 = xmlElement8;
                continue;
            }
            if (string3.equals("attributes")) {
                this.loadAttributeSet(xmlElement8);
                continue;
            }
            if (string3.equals("include")) {
                this.loadPage(this.packageName, xmlElement8.getAttribute("file"), true);
                this.componentFactory.setParentComponent(this.page);
                continue;
            }
            if (string3.equals("scripts")) {
                xmlElement7 = xmlElement8;
                continue;
            }
            this.loadOtherElement(this.page, xmlElement8);
        }
        if (xmlElement2 != null) {
            this.addComponents(bl ? this.componentFactory.getParentComponent() : this.page, xmlElement2);
        }
        if (xmlElement5 != null) {
            this.addMenu(this.page, xmlElement5);
        }
        if (xmlElement4 != null) {
            this.addBindings(this.page, xmlElement4);
        }
        if (xmlElement3 != null) {
            this.addEvents(this.page, xmlElement3);
        }
        if (xmlElement6 != null) {
            this.addValidations(this.page, xmlElement6);
        }
        if (xmlElement7 != null) {
            this.addScripts(this.page, xmlElement7);
        }
        this.page.validate();
        return this.page;
    }

    protected PageSupport loadClass(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        XProjectManager.setCurrentProject(this.currentProject);
        if (this.secondaryClassloader != null) {
            try {
                return (PageSupport)ReflectionHelper.constructViaReflection(this.secondaryClassloader, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (PageSupport)ReflectionHelper.constructViaReflection(null, string);
    }

    protected void loadOtherElement(PageSupport pageSupport, XmlElement xmlElement) {
        if (xmlElement.getName().toLowerCase().equals("guides")) {
            try {
                Object object = ReflectionHelper.constructViaReflection("net.xoetrope.optional.layout.GuideSupport", XProject.class, this.currentProject);
                BuilderSupport builderSupport = (BuilderSupport)object;
                String string = xmlElement.getAttribute("include");
                if (string != null && string.length() > 0) {
                    builderSupport.read(string);
                } else {
                    builderSupport.read(xmlElement);
                }
                pageSupport.setAttribute("guides", "guidesupport", object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void setupPage(XmlElement xmlElement, String string, String string2, boolean bl) {
        String string3;
        XProjectManager.setCurrentProject(this.currentProject);
        String string4 = xmlElement.getAttribute("class");
        if (string4 == null || string4.length() == 0) {
            try {
                string4 = this.currentProject.getStartupParam("DefaultClass");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string4 == null) {
                string4 = DEFAULT_PAGE_CLASS;
            }
        }
        if (!bl) {
            if (string4.indexOf(46) <= 0 && this.packageName.length() > 1) {
                string4 = this.packageName + (this.packageName.endsWith(".") ? "" : ".") + string4;
            }
            try {
                this.page = this.loadClass(string4);
            }
            catch (Exception exception) {
                try {
                    this.page = (PageSupport)ReflectionHelper.constructViaReflection(null, DEFAULT_PAGE_CLASS);
                }
                catch (Exception exception2) {
                    exception.printStackTrace();
                }
            }
            try {
                string3 = xmlElement.getAttribute("Validations");
                if (string3 == null || string3.length() == 0) {
                    string3 = this.currentProject.getStartupParam("Validations");
                }
                if (string3 != null) {
                    this.page.setValidationFactory(this.getValidationFactory(string3));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.page instanceof XContentPane) {
                this.componentFactory.setParentComponent(((XContentPane)((Object)this.page)).getContentPane());
            } else {
                this.componentFactory.setParentComponent(this.page);
            }
            string3 = xmlElement.getAttribute("style");
            if (string3 != null) {
                this.componentFactory.applyStyle((Object)this.page, string3);
            }
        }
        if (!bl) {
            this.setPageName(string);
            this.setPageExtension(string2);
        }
        string3 = null;
        Hashtable<String, String> hashtable = null;
        Enumeration enumeration = xmlElement.enumerateAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string5 = (String)enumeration.nextElement();
            String string6 = xmlElement.getAttribute(string5);
            String string7 = string5.toLowerCase();
            if (!string7.equals("class") && !string7.equals("resource")) {
                if (string7.equals("layout")) {
                    XmlElement xmlElement2;
                    if (string6 != null) {
                        string3 = string6;
                    }
                    if ((xmlElement2 = xmlElement.getFirstChildNamed("Layout")) != null) {
                        hashtable = new Hashtable<String, String>();
                        Enumeration enumeration2 = xmlElement2.enumerateAttributeNames();
                        while (enumeration2.hasMoreElements()) {
                            String string8 = (String)enumeration2.nextElement();
                            String string9 = xmlElement2.getAttribute(string8);
                            hashtable.put(string8, string9);
                        }
                    } else {
                        hashtable = currentAttributes;
                    }
                } else {
                    this.page.setAttribute(string5, null, this.evaluateAttribute(this.page, string6));
                }
            }
            this.setPageAttribute(this.page, string5, string6);
        }
        this.setResourceBundle(this.page, xmlElement.getAttribute("resource"));
        if (string3 != null) {
            this.componentFactory.addLayout(bl ? this.componentFactory.getParentComponent() : this.page, this.layoutHelper.getLayoutType(string3), hashtable);
        }
        this.rootPage = this.page;
    }

    protected void setResourceBundle(PageSupport pageSupport, String string) {
        String string2 = string != null && string.length() > 0 ? pageSupport.evaluatePath(string) : this.currentProject.getStartupParam("Language");
        this.componentFactory.setResourceBundle(string2);
        pageSupport.getComponentFactory().setResourceBundle(string2);
    }

    public void setPageAttribute(Object object, String string, String string2) {
    }

    public void loadAttributeSet(XmlElement xmlElement) {
        if (this.attributeSets == null) {
            this.attributeSets = new Hashtable();
        }
        String string = xmlElement.getAttribute("name");
        Vector<Object[]> vector = new Vector<Object[]>();
        Enumeration enumeration = xmlElement.enumerateAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.equals("name")) {
                string = xmlElement.getAttribute("name");
                continue;
            }
            Object[] objectArray = new Object[]{string2, xmlElement.getAttribute(string2)};
            vector.add(objectArray);
        }
        if (string != null && string.length() > 0) {
            this.attributeSets.put(string, vector);
        }
    }

    public void insertAttributes(XmlElement xmlElement) {
        String string = xmlElement.getAttribute("attributes");
        if (string != null && string.length() > 0) {
            Vector vector = (Vector)this.attributeSets.get(string);
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                Object[] objectArray = (Object[])vector.elementAt(i);
                xmlElement.setAttribute((String)objectArray[0], (String)objectArray[1]);
            }
        }
    }

    public void setAttributeEvaluator(XAttributeEvaluator xAttributeEvaluator) {
        this.evaluator = xAttributeEvaluator;
    }

    public Object evaluateAttribute(PageSupport pageSupport, String string) {
        if (string == null) {
            return null;
        }
        if (this.evaluator != null) {
            return this.evaluator.evaluateAttribute(pageSupport, string);
        }
        return pageSupport.evaluateAttribute(string);
    }

    public String evaluateAttributeAsString(PageSupport pageSupport, String string) {
        Object object = this.evaluateAttribute(pageSupport, string);
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    protected void addComponents(Object object, XmlElement xmlElement) {
        Vector vector = xmlElement.getChildren();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            XmlElement xmlElement2 = (XmlElement)vector.elementAt(i);
            String string = xmlElement2.getName();
            if (string == null) continue;
            if (!"Repeat".equalsIgnoreCase(string)) {
                this.addComponent(xmlElement2);
                continue;
            }
            String string2 = xmlElement2.getAttribute("while");
            this.pushRepeatReference(string2);
            boolean bl = (Boolean)this.rootPage.evaluateAttribute(string2);
            if (bl) {
                --i;
                this.addComponents(object, xmlElement2);
            }
            this.popRepeatReference(string2);
        }
    }

    protected void addEvents(PageSupport pageSupport, XmlElement xmlElement) {
        Vector vector = xmlElement.getChildren();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            XmlElement xmlElement2 = (XmlElement)vector.elementAt(i);
            if (xmlElement2.getName().compareTo("Repeat") != 0) {
                this.addEvent(xmlElement2);
                continue;
            }
            String string = xmlElement2.getAttribute("while");
            this.pushRepeatReference(string);
            boolean bl = (Boolean)this.rootPage.evaluateAttribute(string);
            if (bl) {
                --i;
                this.addEvents(pageSupport, xmlElement2);
            }
            this.popRepeatReference(string);
        }
    }

    protected void addEvent(XmlElement xmlElement) {
        String string = "";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            Object object;
            Enumeration enumeration = xmlElement.enumerateAttributeNames();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                String string5 = xmlElement.getAttribute((String)object);
                if ("type".equals(object)) {
                    string4 = this.evaluateAttributeAsString(this.rootPage, string5);
                    continue;
                }
                if ("method".equals(object)) {
                    string3 = string5;
                    continue;
                }
                if ("target".equals(object)) {
                    string2 = this.evaluateAttributeAsString(this.rootPage, string5);
                    continue;
                }
                if ("cursor".equals(object)) {
                    string = this.evaluateAttributeAsString(this.rootPage, string5);
                    continue;
                }
                this.page.setAttribute((String)object, string2, this.evaluateAttribute(this.page, string5));
            }
            if ("MenuHandler".equals(string4)) {
                this.addHandler(this.page, this.getMenuItem(string2), "MenuHandler", string3);
            } else {
                object = this.page.findComponent(string2);
                this.addHandler(this.page, object, string4, string3);
                if (string.equals("true")) {
                    this.adapter.setCursor(object, Cursor.getPredefinedCursor(12));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addHandler(PageSupport pageSupport, Object object, String string, String string2) {
        this.eventHandler.addHandler(pageSupport, object, string, string2);
    }

    protected void addBindings(PageSupport pageSupport, XmlElement xmlElement) {
        if (xmlElement == null) {
            return;
        }
        Vector vector = xmlElement.getChildren();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            XmlElement xmlElement2 = (XmlElement)vector.elementAt(i);
            if (xmlElement2.getName().compareTo("Repeat") != 0) {
                this.addBinding(xmlElement2);
                continue;
            }
            String string = xmlElement2.getAttribute("while");
            this.pushRepeatReference(string);
            boolean bl = (Boolean)this.rootPage.evaluateAttribute(string);
            if (bl) {
                --i;
                this.addBindings(pageSupport, xmlElement2);
            }
            this.popRepeatReference(string);
        }
    }

    protected void addBinding(XmlElement xmlElement) {
        String string = null;
        try {
            Object object;
            Object object2;
            String string2;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            Enumeration enumeration = xmlElement.enumerateAttributeNames();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                object2 = xmlElement.getAttribute(string2);
                hashtable.put(string2, this.evaluateAttribute(this.page, (String)object2));
            }
            hashtable.put("sourcePath", xmlElement.getAttribute("source"));
            string2 = xmlElement.getAttribute("output");
            if (string2 != null) {
                hashtable.put("outputPath", string2);
            }
            string = xmlElement.getAttribute("target");
            string = this.evaluateAttributeAsString(this.rootPage, string);
            object2 = this.page.findComponent(string);
            String string3 = (String)hashtable.get("type");
            if (string3 != null && string3.equals("custom")) {
                object = (String)hashtable.get("class");
                try {
                    XDataBinding xDataBinding = (XDataBinding)Class.forName(((String)object).trim()).newInstance();
                    xDataBinding.setup(this.currentProject, object2, null, hashtable);
                    this.page.addBinding(xDataBinding);
                    return;
                }
                catch (Exception exception) {
                    System.out.println("could not load binding class - " + (String)object);
                }
            }
            if ((object = this.getFactoryBinding(this.page, object2, hashtable)) != null) {
                this.page.addBinding((XDataBinding)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public XDataBinding getFactoryBinding(PageSupport pageSupport, Object object, Hashtable hashtable) {
        XDataBinding xDataBinding = null;
        Vector vector = pageSupport.getProject().getBindingsFactories();
        for (int i = 0; i < vector.size(); ++i) {
            xDataBinding = ((XDataBindingFactory)vector.elementAt(i)).getBinding(pageSupport, object, hashtable);
            if (xDataBinding == null) continue;
            return xDataBinding;
        }
        return null;
    }

    protected void setPageName(String string) {
        this.page.setName(string);
    }

    protected void setPageExtension(String string) {
        this.page.setExtension(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object addComponent(XmlElement xmlElement) {
        String string = null;
        Object object = null;
        String string2 = xmlElement.getName();
        if (string2.equals("Layout")) {
            return null;
        }
        try {
            Object object2;
            Hashtable<Object, String> hashtable;
            Hashtable<Object, String> hashtable2;
            String string3;
            String string4;
            block49: {
                int n = 0;
                int n2 = 0;
                int n3 = 30;
                int n4 = 20;
                string4 = null;
                String string5 = null;
                string3 = null;
                String string6 = null;
                String string7 = null;
                String string8 = null;
                String string9 = null;
                string = null;
                String string10 = "0";
                String string11 = "0";
                string8 = "-1";
                string9 = "-1";
                hashtable2 = null;
                currentAttributes = hashtable = new Hashtable<Object, String>();
                this.insertAttributes(xmlElement);
                Enumeration enumeration = xmlElement.enumerateAttributeNames();
                while (enumeration.hasMoreElements()) {
                    object2 = (String)enumeration.nextElement();
                    String string12 = xmlElement.getAttribute((String)object2);
                    string12 = this.evaluateAttributeAsString(this.rootPage, string12);
                    if (((String)object2).equals("x")) {
                        string11 = string12;
                        continue;
                    }
                    if (((String)object2).equals("y")) {
                        string10 = string12;
                        continue;
                    }
                    if (((String)object2).equals("w")) {
                        string9 = string12;
                        continue;
                    }
                    if (((String)object2).equals("h")) {
                        string8 = string12;
                        continue;
                    }
                    if (((String)object2).equals("eager")) {
                        string4 = string12;
                        continue;
                    }
                    if (((String)object2).equals("attributes")) continue;
                    if (((String)object2).equals("name")) {
                        string = string12;
                        continue;
                    }
                    if (((String)object2).equals("layout")) {
                        string3 = string12;
                        XmlElement xmlElement2 = xmlElement.getFirstChildNamed("Layout");
                        if (xmlElement2 != null) {
                            hashtable2 = new Hashtable();
                            Enumeration enumeration2 = xmlElement2.enumerateAttributeNames();
                            while (enumeration2.hasMoreElements()) {
                                String string13 = (String)enumeration2.nextElement();
                                String string14 = xmlElement2.getAttribute(string13);
                                hashtable2.put(string13, string14);
                            }
                            continue;
                        }
                        hashtable2 = hashtable;
                        continue;
                    }
                    if (((String)object2).equals("constraint")) {
                        string5 = string12;
                        continue;
                    }
                    if (((String)object2).equals("content")) {
                        string7 = string12;
                    } else if (((String)object2).equals("key")) {
                        string7 = string12;
                    } else if (((String)object2).equals("style")) {
                        string6 = string12;
                    } else {
                        if (string == null && (string = xmlElement.getAttribute("name")) == null) {
                            string = "child" + new Integer(++nextChildId).toString();
                        }
                        this.rootPage.setAttribute((String)object2, string, this.evaluateAttribute(this.rootPage, string12));
                    }
                    hashtable.put(object2, string12);
                }
                n4 = -1;
                n3 = -1;
                n2 = -1;
                n = -1;
                n = this.getInt(string11, n);
                n2 = this.getInt(string10, n2);
                n3 = this.getInt(string9, n3);
                n4 = this.getInt(string8, n4);
                if (this.includeFileName != null) {
                    if (string == null || string.length() == 0) {
                        string = this.includeFileName;
                    }
                    this.page.setAttribute("Include", string, this.evaluateAttribute(this.page, this.includeFileName));
                    this.includeFileName = null;
                }
                if (string2.equalsIgnoreCase("include")) {
                    object2 = this.componentFactory.getParentComponent();
                    this.includeFileName = this.evaluateAttributeAsString(this.page, xmlElement.getAttribute("file"));
                    this.pushIncludeReference(this.includeFileName);
                    this.loadPage(this.packageName, this.includeFileName, true);
                    this.popIncludeReference(this.includeFileName);
                    this.componentFactory.setParentComponent(object2);
                    return null;
                }
                if (string2.equalsIgnoreCase("attributes")) {
                    this.loadAttributeSet(xmlElement);
                    return null;
                }
                try {
                    block48: {
                        try {
                            if (string5 == null) {
                                object = this.componentFactory.addComponent(string2, n, n2, n3, n4, string7, string6);
                                break block48;
                            }
                            object = this.componentFactory.addComponent(string2, this.layoutHelper.getConstraint(string5), string7, string6);
                            if (n >= 0 || n2 >= 0) {
                                this.adapter.setLocation(object, n, n2);
                            }
                            if (n3 <= 0 && n4 <= 0) break block48;
                            this.adapter.setSize(object, Math.max(2, n3), Math.max(2, n4));
                        }
                        catch (Exception exception) {
                            object = null;
                            Object var28_30 = null;
                            if (object != null) break block49;
                            hashtable.put("x", string11);
                            hashtable.put("y", string10);
                            hashtable.put("w", string9);
                            hashtable.put("h", string8);
                            Object object3 = this.componentFactory.addElement(string2, string, string7, hashtable);
                            if (object3 == null) {
                                String string15 = (String)hashtable.get("class");
                                if (string15 != null) {
                                    object = this.componentFactory.addComponent(string15, n, n2, n3, n4, string7, string6);
                                }
                                if (object == null) {
                                    object = this.componentFactory.addComponent("Unknown", n, n2, n3, n4, string7, string6);
                                }
                                hashtable.put("type", string2);
                            }
                            break block49;
                        }
                    }
                    Object var28_29 = null;
                    if (object != null) break block49;
                    hashtable.put("x", string11);
                }
                catch (Throwable throwable) {
                    Object var28_31 = null;
                    if (object != null) throw throwable;
                    hashtable.put("x", string11);
                    hashtable.put("y", string10);
                    hashtable.put("w", string9);
                    hashtable.put("h", string8);
                    Object object4 = this.componentFactory.addElement(string2, string, string7, hashtable);
                    if (object4 != null) throw throwable;
                    String string16 = (String)hashtable.get("class");
                    if (string16 != null) {
                        object = this.componentFactory.addComponent(string16, n, n2, n3, n4, string7, string6);
                    }
                    if (object == null) {
                        object = this.componentFactory.addComponent("Unknown", n, n2, n3, n4, string7, string6);
                    }
                    hashtable.put("type", string2);
                    throw throwable;
                }
                hashtable.put("y", string10);
                hashtable.put("w", string9);
                hashtable.put("h", string8);
                Object object5 = this.componentFactory.addElement(string2, string, string7, hashtable);
                if (object5 == null) {
                    String string17 = (String)hashtable.get("class");
                    if (string17 != null) {
                        object = this.componentFactory.addComponent(string17, n, n2, n3, n4, string7, string6);
                    }
                    if (object == null) {
                        object = this.componentFactory.addComponent("Unknown", n, n2, n3, n4, string7, string6);
                    }
                    hashtable.put("type", string2);
                }
            }
            if (object == null) {
                return null;
            }
            if (this.adapter.isContainer(object) && string3 != null) {
                this.componentFactory.addLayout(object, this.layoutHelper.getLayoutType(string3), hashtable2);
            }
            this.adapter.setName(object, string);
            if (this.adapter.isContainer(object)) {
                object2 = this.componentFactory.getParentComponent();
                this.componentFactory.setParentComponent(object);
                if ("true".equals(string4)) {
                    this.setComponentAttributes(string2, object, hashtable);
                }
                this.addComponents(object, xmlElement);
                currentAttributes = hashtable;
                this.componentFactory.setParentComponent(object2);
                this.adapter.doLayout(object);
            }
            if (object instanceof XRadioButtonGroup) {
                object2 = (XRadioButtonGroup)object;
                if (this.checkBoxGroup == null) {
                    this.checkBoxGroup = object2.getRadioButtonGroup() == null ? object2.createGroup() : object2.getRadioButtonGroup();
                } else {
                    object2.setRadioButtonGroup(this.checkBoxGroup);
                }
            } else {
                this.checkBoxGroup = null;
            }
            object2 = xmlElement.getAttribute("customizer");
            if (object2 != null && ((String)object2).length() > 0) {
                this.customizer.customize(object, (String)object2, 0);
            }
            if ("true".equals(string4)) return object;
            this.setComponentAttributes(string2, object, hashtable);
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object;
    }

    protected void addMenu(PageSupport pageSupport, XmlElement xmlElement) {
        Object object = this.componentFactory.getParentComponent();
        this.componentFactory.setParentComponent(pageSupport);
        String string = this.currentProject.getWidgetPackageName() + ".X";
        WidgetAdapter widgetAdapter = WidgetAdapter.getInstance();
        try {
            this.menuBar = (XAppender)Class.forName(string + "MenuBar").newInstance();
            this.menuBar.setName(pageSupport.getName());
            XStyle xStyle = null;
            String string2 = xmlElement.getAttribute("style");
            Color color = null;
            Color color2 = null;
            Font font = null;
            if (string2 != null && string2.length() > 0) {
                xStyle = this.currentProject.getStyleManager().getStyle(string2);
                color = xStyle.getStyleAsColor(4);
                color2 = xStyle.getStyleAsColor(5);
                font = this.currentProject.getStyleManager().getFont(string2);
                widgetAdapter.setBackground(this.menuBar, color);
                widgetAdapter.setForeground(this.menuBar, color2);
                widgetAdapter.setFont(this.menuBar, font);
            }
            Vector vector = xmlElement.getChildren();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                XmlElement xmlElement2 = (XmlElement)vector.elementAt(i);
                this.addMenu(this.menuBar, xmlElement2, string, xStyle, color, color2, font);
            }
            this.menuBar.setup();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.componentFactory.setParentComponent(object);
    }

    private void addMenu(XAppender xAppender, XmlElement xmlElement, String string, XStyle xStyle, Color color, Color color2, Font font) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object object;
        XAppender xAppender2 = null;
        if (this.adapter.requiresParent()) {
            object = new Object[]{xAppender};
            xAppender2 = (XAppender)ReflectionHelper.constructViaReflection(string + "Menu", (Object[])object);
        } else {
            xAppender2 = (XAppender)Class.forName(string + "Menu").newInstance();
        }
        ((XTextHolder)((Object)xAppender2)).setText(this.componentFactory.translate(xmlElement.getAttribute("content")));
        if (xStyle != null) {
            this.adapter.setBackground(xAppender2, color);
            this.adapter.setForeground(xAppender2, color2);
            this.adapter.setFont(xAppender2, font);
        }
        this.addMenuItems(xAppender2, xmlElement, string, xStyle, color, color2, font);
        object = xmlElement.getAttribute("enabled");
        if (object != null && ((String)object).equals("false")) {
            this.adapter.setEnabled(xAppender2, false);
        }
        if ((object = xmlElement.getAttribute("visible")) != null && ((String)object).equals("false")) {
            this.adapter.setVisible(xAppender2, false);
        }
        xAppender.append(xAppender2, xmlElement.getAttribute("name"));
    }

    private void addMenuItems(XAppender xAppender, XmlElement xmlElement, String string, XStyle xStyle, Color color, Color color2, Font font) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        int n = xmlElement.getChildren().size();
        for (int i = 0; i < n; ++i) {
            XmlElement xmlElement2 = xmlElement.elementAt(i);
            if (xmlElement2.getName().equalsIgnoreCase("Menu")) {
                this.addMenu(xAppender, xmlElement2, string, xStyle, color, color2, font);
                continue;
            }
            String string2 = xmlElement2.getAttribute("content");
            if (string2 != null) {
                Object object;
                Object object2 = null;
                if (this.adapter.requiresParent()) {
                    object = new Object[]{xAppender};
                    object2 = ReflectionHelper.constructViaReflection(string + "MenuItem", (Object[])object);
                } else {
                    object2 = Class.forName(string + "MenuItem").newInstance();
                }
                if (xStyle != null) {
                    this.adapter.setBackground(object2, color);
                    this.adapter.setForeground(object2, color2);
                    this.adapter.setFont(object2, font);
                }
                ((XTextHolder)object2).setText(this.componentFactory.translate(string2));
                if (object2 instanceof XAttributedComponent) {
                    ((XAttributedComponent)object2).setAttribute("image", this.componentFactory.translate(xmlElement2.getAttribute("image")));
                    ((XAttributedComponent)object2).setAttribute("name", this.componentFactory.translate(xmlElement2.getAttribute("name")));
                }
                xAppender.append(object2, xmlElement2.getAttribute("name"));
                object = xmlElement2.getAttribute("enabled");
                if (object != null && ((String)object).equals("false")) {
                    this.adapter.setEnabled(object2, false);
                }
                if ((object = xmlElement2.getAttribute("visible")) == null || !((String)object).equals("false")) continue;
                this.adapter.setVisible(object2, false);
                continue;
            }
            xAppender.addSeparator();
        }
    }

    protected void addValidations(PageSupport pageSupport, XmlElement xmlElement) {
        Vector vector = xmlElement.getChildren();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            XmlElement xmlElement2 = (XmlElement)vector.elementAt(i);
            Object object = pageSupport.findComponent(xmlElement2.getAttribute("target"));
            String string = xmlElement2.getAttribute("when");
            int n2 = 1005;
            if (string != null && string.toLowerCase().compareTo("mouseclicked") == 0) {
                n2 = 500;
            }
            try {
                pageSupport.addValidation(object, xmlElement2.getAttribute("rule"), xmlElement2.getAttribute("method"), n2, xmlElement2);
                continue;
            }
            catch (Exception exception) {
                DebugLogger.logError("BUILDER", "Could not create the validation - " + xmlElement2.getAttribute("rule"));
            }
        }
    }

    public void addScripts(PageSupport pageSupport, XmlElement xmlElement) {
        pageSupport.setAttribute("source", "scripts", xmlElement.getContent().trim());
    }

    protected void setComponentAttributes(String string, Object object, Hashtable hashtable) {
        String string2 = this.page.getComponentName(object);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            try {
                String string3 = (String)enumeration.nextElement();
                String string4 = (String)hashtable.get(string3);
                Object object2 = this.evaluateAttribute(this.page, string4);
                this.page.setAttribute(string3, string2, object2);
                if (string3.compareTo("visible") == 0) {
                    this.adapter.setVisible(object, string4.equals("true"));
                    continue;
                }
                if (string3.compareTo("enabled") == 0) {
                    this.adapter.setEnabled(object, string4.equals("true"));
                    continue;
                }
                int n = -1;
                ComponentAdapter componentAdapter = this.componentFactory.getComponentAdapter(string);
                if (componentAdapter != null) {
                    n = componentAdapter.setProperty(object, string3, string4, null);
                }
                if (n < 0 && object instanceof XAttributedComponent && (n = object instanceof XAttributedComponentEx ? ((XAttributedComponentEx)object).setAttribute(this.currentProject, string3, object2) : ((XAttributedComponent)object).setAttribute(string3, object2)) < 0) {
                    n = XAttributedComponentHelper.setAttribute(this.currentProject, object, string3.toLowerCase(), object2);
                }
                if (n == 0) continue;
                try {
                    ReflectionHelper.setViaReflection("set" + string3.substring(0, 1).toUpperCase() + string3.substring(1), object, object2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (object instanceof XMultiAttributedComponent) {
            ((XMultiAttributedComponent)object).allAttributesSet();
        }
    }

    protected Object getMenuItem(String string) {
        return this.menuBar.getObject(string);
    }

    protected XValidationFactory getValidationFactory(String string) {
        if (string != null && string.length() > 0) {
            try {
                XValidationFactory xValidationFactory = (XValidationFactory)this.validationFactories.get(string);
                if (xValidationFactory == null) {
                    String string2 = this.currentProject.getStartupParam("ValidationFactory");
                    if (string2 != null && string2.length() > 0) {
                        Object[] objectArray = new Object[]{this.currentProject};
                        xValidationFactory = (XValidationFactory)ReflectionHelper.constructViaReflection(string2, objectArray);
                    } else {
                        xValidationFactory = new XValidationFactory(this.currentProject);
                    }
                    XValidationFactory.addConfigFile("Project", string, true);
                    this.validationFactories.put(string, xValidationFactory);
                }
                return xValidationFactory;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected int getInt(String string, int n) {
        try {
            return new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static Hashtable getCurrentAttributes() {
        return currentAttributes;
    }

    public void pushIncludeReference(String string) {
    }

    public void popIncludeReference(String string) {
    }

    public void pushRepeatReference(String string) {
    }

    public void popRepeatReference(String string) {
    }

    public String getType() {
        return "xui";
    }
}

