/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.Reader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import net.n3.nanoxml.CDATAReader;
import net.n3.nanoxml.ContentReader;
import net.n3.nanoxml.IXMLBuilder;
import net.n3.nanoxml.IXMLEntityResolver;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.IXMLValidator;
import net.n3.nanoxml.PIReader;
import net.n3.nanoxml.XMLEntityResolver;
import net.n3.nanoxml.XMLException;
import net.n3.nanoxml.XMLUtil;

public class StdXMLParser
implements IXMLParser {
    private IXMLBuilder builder = null;
    private IXMLReader reader = null;
    private IXMLEntityResolver entityResolver = new XMLEntityResolver();
    private IXMLValidator validator = null;

    protected void finalize() throws Throwable {
        this.builder = null;
        this.reader = null;
        this.entityResolver = null;
        this.validator = null;
        super.finalize();
    }

    public void setBuilder(IXMLBuilder iXMLBuilder) {
        this.builder = iXMLBuilder;
    }

    public IXMLBuilder getBuilder() {
        return this.builder;
    }

    public void setValidator(IXMLValidator iXMLValidator) {
        this.validator = iXMLValidator;
    }

    public IXMLValidator getValidator() {
        return this.validator;
    }

    public void setResolver(IXMLEntityResolver iXMLEntityResolver) {
        this.entityResolver = iXMLEntityResolver;
    }

    public IXMLEntityResolver getResolver() {
        return this.entityResolver;
    }

    public void setReader(IXMLReader iXMLReader) {
        this.reader = iXMLReader;
    }

    public IXMLReader getReader() {
        return this.reader;
    }

    public Object parse() throws XMLException {
        try {
            this.builder.startBuilding(this.reader.getSystemID(), this.reader.getLineNr());
            this.scanData();
            return this.builder.getResult();
        }
        catch (XMLException xMLException) {
            throw xMLException;
        }
        catch (Exception exception) {
            throw new XMLException(exception);
        }
    }

    protected void scanData() throws Exception {
        block4: while (!this.reader.atEOF() && this.builder.getResult() == null) {
            String string = XMLUtil.read(this.reader, '&');
            char c = string.charAt(0);
            if (c == '&') {
                XMLUtil.processEntity(string, this.reader, this.entityResolver);
                continue;
            }
            switch (c) {
                case '<': {
                    this.scanSomeTag(false, null, new Properties());
                    continue block4;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block4;
                }
            }
            XMLUtil.errorInvalidInput(this.reader.getSystemID(), this.reader.getLineNr(), "`" + c + "' (0x" + Integer.toHexString(c) + ')');
        }
    }

    protected void scanSomeTag(boolean bl, String string, Properties properties) throws Exception {
        String string2 = XMLUtil.read(this.reader, '&');
        char c = string2.charAt(0);
        if (c == '&') {
            XMLUtil.errorUnexpectedEntity(this.reader.getSystemID(), this.reader.getLineNr(), string2);
        }
        switch (c) {
            case '?': {
                this.processPI();
                break;
            }
            case '!': {
                this.processSpecialTag(bl);
                break;
            }
            default: {
                this.reader.unread(c);
                this.processElement(string, properties);
            }
        }
    }

    protected void processPI() throws Exception {
        XMLUtil.skipWhitespace(this.reader, null);
        String string = XMLUtil.scanIdentifier(this.reader);
        XMLUtil.skipWhitespace(this.reader, null);
        PIReader pIReader = new PIReader(this.reader);
        if (!string.equalsIgnoreCase("xml")) {
            this.builder.newProcessingInstruction(string, pIReader);
        }
        ((Reader)pIReader).close();
    }

    protected void processSpecialTag(boolean bl) throws Exception {
        String string = XMLUtil.read(this.reader, '&');
        char c = string.charAt(0);
        if (c == '&') {
            XMLUtil.errorUnexpectedEntity(this.reader.getSystemID(), this.reader.getLineNr(), string);
        }
        switch (c) {
            case '[': {
                if (bl) {
                    this.processCDATA();
                } else {
                    XMLUtil.errorUnexpectedCDATA(this.reader.getSystemID(), this.reader.getLineNr());
                }
                return;
            }
            case 'D': {
                this.processDocType();
                return;
            }
            case '-': {
                XMLUtil.skipComment(this.reader);
                return;
            }
        }
    }

    protected void processCDATA() throws Exception {
        if (!XMLUtil.checkLiteral(this.reader, "CDATA[")) {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "<![[CDATA[");
        }
        this.validator.PCDataAdded(this.reader.getSystemID(), this.reader.getLineNr());
        CDATAReader cDATAReader = new CDATAReader(this.reader);
        this.builder.addPCData(cDATAReader, this.reader.getSystemID(), this.reader.getLineNr());
        ((Reader)cDATAReader).close();
    }

    protected void processDocType() throws Exception {
        if (!XMLUtil.checkLiteral(this.reader, "OCTYPE")) {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "<!DOCTYPE");
            return;
        }
        XMLUtil.skipWhitespace(this.reader, null);
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        XMLUtil.scanIdentifier(this.reader);
        XMLUtil.skipWhitespace(this.reader, null);
        char c = this.reader.read();
        if (c == 'P') {
            string = XMLUtil.scanPublicID(stringBuffer, this.reader);
            XMLUtil.skipWhitespace(this.reader, null);
            c = this.reader.read();
        } else if (c == 'S') {
            string = XMLUtil.scanSystemID(this.reader);
            XMLUtil.skipWhitespace(this.reader, null);
            c = this.reader.read();
        }
        if (c == '[') {
            this.validator.parseDTD(stringBuffer.toString(), this.reader, this.entityResolver, false);
            XMLUtil.skipWhitespace(this.reader, null);
            c = this.reader.read();
        }
        if (c != '>') {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "`>'");
        }
        if (string != null) {
            Reader reader = this.reader.openStream(stringBuffer.toString(), string);
            this.reader.startNewStream(reader);
            this.reader.setSystemID(string);
            this.reader.setPublicID(stringBuffer.toString());
            this.validator.parseDTD(stringBuffer.toString(), this.reader, this.entityResolver, true);
        }
    }

    protected void processElement(String string, Properties properties) throws Exception {
        Object object;
        int n;
        String string2;
        char c;
        String string3;
        String string4 = string3 = XMLUtil.scanIdentifier(this.reader);
        XMLUtil.skipWhitespace(this.reader, null);
        String string5 = null;
        int n2 = string4.indexOf(58);
        if (n2 > 0) {
            string5 = string4.substring(0, n2);
            string4 = string4.substring(n2 + 1);
        }
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        this.validator.elementStarted(string3, this.reader.getSystemID(), this.reader.getLineNr());
        while ((c = this.reader.read()) != '/' && c != '>') {
            this.reader.unread(c);
            this.processAttribute(vector, vector2, vector3);
            XMLUtil.skipWhitespace(this.reader, null);
        }
        Properties properties2 = new Properties();
        this.validator.elementAttributesProcessed(string3, properties2, this.reader.getSystemID(), this.reader.getLineNr());
        Enumeration<Object> enumeration = properties2.keys();
        while (enumeration.hasMoreElements()) {
            String string6 = (String)enumeration.nextElement();
            string2 = properties2.getProperty(string6);
            vector.addElement(string6);
            vector2.addElement(string2);
            vector3.addElement("CDATA");
        }
        for (n = 0; n < vector.size(); ++n) {
            string2 = (String)vector.elementAt(n);
            object = (String)vector2.elementAt(n);
            if (string2.equals("xmlns")) {
                string = object;
                continue;
            }
            if (!string2.startsWith("xmlns:")) continue;
            properties.put(string2.substring(6), object);
        }
        if (string5 == null) {
            this.builder.startElement(string4, string5, string, this.reader.getSystemID(), this.reader.getLineNr());
        } else {
            this.builder.startElement(string4, string5, properties.getProperty(string5), this.reader.getSystemID(), this.reader.getLineNr());
        }
        for (n = 0; n < vector.size(); ++n) {
            string2 = (String)vector.elementAt(n);
            if (string2.startsWith("xmlns")) continue;
            object = (String)vector2.elementAt(n);
            String string7 = (String)vector3.elementAt(n);
            n2 = string2.indexOf(58);
            if (n2 > 0) {
                String string8 = string2.substring(0, n2);
                string2 = string2.substring(n2 + 1);
                this.builder.addAttribute(string2, string8, properties.getProperty(string8), (String)object, string7);
                continue;
            }
            this.builder.addAttribute(string2, null, null, (String)object, string7);
        }
        if (string5 == null) {
            this.builder.elementAttributesProcessed(string4, string5, string);
        } else {
            this.builder.elementAttributesProcessed(string4, string5, properties.getProperty(string5));
        }
        if (c == '/') {
            if (this.reader.read() != '>') {
                XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "`>'");
            }
            this.validator.elementEnded(string4, this.reader.getSystemID(), this.reader.getLineNr());
            if (string5 == null) {
                this.builder.endElement(string4, string5, string);
            } else {
                this.builder.endElement(string4, string5, properties.getProperty(string5));
            }
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(16);
        while (true) {
            stringBuffer.setLength(0);
            while (true) {
                XMLUtil.skipWhitespace(this.reader, stringBuffer);
                string2 = XMLUtil.read(this.reader, '&');
                if (string2.charAt(0) != '&' || string2.charAt(1) == '#') break;
                XMLUtil.processEntity(string2, this.reader, this.entityResolver);
            }
            if (string2.charAt(0) == '<') {
                string2 = XMLUtil.read(this.reader, '\u0000');
                if (string2.charAt(0) == '/') {
                    XMLUtil.skipWhitespace(this.reader, null);
                    string2 = XMLUtil.scanIdentifier(this.reader);
                    if (!string2.equals(string3)) {
                        XMLUtil.errorWrongClosingTag(this.reader.getSystemID(), this.reader.getLineNr(), string4, string2);
                    }
                    XMLUtil.skipWhitespace(this.reader, null);
                    if (this.reader.read() != '>') {
                        XMLUtil.errorClosingTagNotEmpty(this.reader.getSystemID(), this.reader.getLineNr());
                    }
                    this.validator.elementEnded(string3, this.reader.getSystemID(), this.reader.getLineNr());
                    if (string5 == null) {
                        this.builder.endElement(string4, string5, string);
                        break;
                    }
                    this.builder.endElement(string4, string5, properties.getProperty(string5));
                    break;
                }
                this.reader.unread(string2.charAt(0));
                this.scanSomeTag(true, string, (Properties)properties.clone());
                continue;
            }
            if (string2.charAt(0) == '&') {
                c = XMLUtil.processCharLiteral(string2);
                stringBuffer.append(c);
            } else {
                this.reader.unread(string2.charAt(0));
            }
            this.validator.PCDataAdded(this.reader.getSystemID(), this.reader.getLineNr());
            object = new ContentReader(this.reader, this.entityResolver, stringBuffer.toString());
            this.builder.addPCData((Reader)object, this.reader.getSystemID(), this.reader.getLineNr());
            ((Reader)object).close();
        }
    }

    protected void processAttribute(Vector vector, Vector vector2, Vector vector3) throws Exception {
        String string = XMLUtil.scanIdentifier(this.reader);
        XMLUtil.skipWhitespace(this.reader, null);
        if (!XMLUtil.read(this.reader, '&').equals("=")) {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "`='");
        }
        XMLUtil.skipWhitespace(this.reader, null);
        String string2 = XMLUtil.scanString(this.reader, '&', this.entityResolver);
        vector.addElement(string);
        vector2.addElement(string2);
        vector3.addElement("CDATA");
        this.validator.attributeAdded(string, string2, this.reader.getSystemID(), this.reader.getLineNr());
    }
}

