/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.web;

import com.google.checkout.CheckoutException;
import com.google.checkout.CheckoutSystemException;
import com.google.checkout.MerchantInfo;
import com.google.checkout.util.Utils;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConfigurationListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
        String fileName;
        ServletContext context = sce.getServletContext();
        InputStream is = context.getResourceAsStream(fileName = context.getInitParameter("checkout-config-file"));
        if (is == null) {
            fileName = "/WEB-INF/checkout-config.xml";
            is = context.getResourceAsStream(fileName);
        }
        if (is == null) {
            throw new IllegalArgumentException("web.xml must have <checkout-config-file> init parameter!");
        }
        try {
            Document doc = Utils.newDocumentFromInputStream(is);
            context.setAttribute("merchant-info", (Object)this.extractMerchantInfo(doc));
        }
        catch (CheckoutException ex) {
            throw new CheckoutSystemException("Could not initialize context.");
        }
    }

    private MerchantInfo extractMerchantInfo(Document doc) {
        NodeList elements = doc.getElementsByTagName("merchant-info");
        if (elements.getLength() != 1) {
            throw new IllegalArgumentException("checkout-config.xml must have exactly one <merchant-info> element!");
        }
        Element miElement = (Element)elements.item(0);
        String merchantId = Utils.getElementStringValue(doc, miElement, "merchant-id").trim();
        String merchantKey = Utils.getElementStringValue(doc, miElement, "merchant-key").trim();
        String env = Utils.getElementStringValue(doc, miElement, "env").trim();
        String currencyCode = Utils.getElementStringValue(doc, miElement, "currency-code").trim();
        String sandboxRoot = Utils.getElementStringValue(doc, miElement, "sandbox-root").trim();
        String productionRoot = Utils.getElementStringValue(doc, miElement, "production-root").trim();
        String checkoutCommand = Utils.getElementStringValue(doc, miElement, "checkout-command").trim();
        String merchantCheckoutCommand = Utils.getElementStringValue(doc, miElement, "merchant-checkout-command").trim();
        String requestCommand = Utils.getElementStringValue(doc, miElement, "request-command").trim();
        String checkoutUrl = "";
        String merchantCheckoutUrl = "";
        String requestUrl = "";
        if ("Sandbox".equals(env)) {
            checkoutUrl = sandboxRoot + "/" + checkoutCommand + "/Merchant/" + merchantId;
            merchantCheckoutUrl = sandboxRoot + "/" + merchantCheckoutCommand + "/Merchant/" + merchantId;
            requestUrl = sandboxRoot + "/" + requestCommand + "/Merchant/" + merchantId;
        } else if ("Production".equals(env)) {
            checkoutUrl = productionRoot + "/" + checkoutCommand + "/Merchant/" + merchantId;
            merchantCheckoutUrl = productionRoot + "/" + merchantCheckoutCommand + "/Merchant/" + merchantId;
            requestUrl = productionRoot + "/" + requestCommand + "/Merchant/" + merchantId;
        } else {
            throw new CheckoutSystemException("Env must be one of Sandbox or Production.");
        }
        return new MerchantInfo(merchantId, merchantKey, env, currencyCode, checkoutUrl, merchantCheckoutUrl, requestUrl);
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

