/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.web;

import com.google.checkout.CheckoutException;
import com.google.checkout.CheckoutSystemException;
import com.google.checkout.MerchantInfo;
import com.google.checkout.handlers.MessageHandler;
import com.google.checkout.util.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CheckoutMessageHandlerServlet
extends HttpServlet {
    private static final String DEFAULT_HANDLER_TYPE = "notification-handler";
    private final HashMap mhTable = new HashMap();

    public void init(ServletConfig config) throws ServletException {
        String fileName;
        ServletContext context;
        InputStream is;
        super.init(config);
        String handlerType = config.getInitParameter("handler-type");
        if (handlerType == null) {
            handlerType = DEFAULT_HANDLER_TYPE;
        }
        if ((is = (context = config.getServletContext()).getResourceAsStream(fileName = context.getInitParameter("checkout-config-file"))) == null) {
            fileName = "/WEB-INF/checkout-config.xml";
            is = context.getResourceAsStream(fileName);
        }
        if (is == null) {
            throw new IllegalArgumentException("web.xml must have <checkout-config-file> init parameter!");
        }
        try {
            Document doc = Utils.newDocumentFromInputStream(is);
            this.readAndConfigureHandlers(doc, handlerType);
        }
        catch (CheckoutException ex) {
            throw new CheckoutSystemException("Unable to initialize servlet.");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(405, "This REST Web service accepts request only through the HTTP POST method. Your request was denied because it was sent through HTTP GET!");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String auth = request.getHeader("Authorization");
            MerchantInfo mi = (MerchantInfo)this.getServletContext().getAttribute("merchant-info");
            if (auth == null || !auth.equals("Basic " + mi.getHttpAuth())) {
                response.sendError(401, "Authentication Failed.");
                return;
            }
            String notification = this.getNotificationBody((InputStream)request.getInputStream());
            String ret = this.dispatch(mi, notification);
            PrintWriter out = response.getWriter();
            out.print(ret);
        }
        catch (CheckoutException ex) {
            ex.printStackTrace();
            response.sendError(500, ex.getMessage());
        }
    }

    protected String dispatch(MerchantInfo mi, String message) throws CheckoutException {
        MessageHandler mh = this.getMessageHandler(message);
        if (mh != null) {
            return mh.process(mi, message);
        }
        return null;
    }

    private MessageHandler getMessageHandler(String message) {
        for (String key : this.mhTable.keySet()) {
            if (message.indexOf(key) <= -1) continue;
            return (MessageHandler)this.mhTable.get(key);
        }
        return null;
    }

    private void readAndConfigureHandlers(Document doc, String handlerType) throws CheckoutException {
        NodeList elements = doc.getElementsByTagName(handlerType);
        String errorMsg = "";
        for (int i = 0; i < elements.getLength(); ++i) {
            try {
                Element element = (Element)elements.item(i);
                String className = Utils.getElementStringValue(doc, element, "handler-class").trim();
                String target = Utils.getElementStringValue(doc, element, "message-type").trim();
                Class<?> c = Class.forName(className);
                Object obj = c.newInstance();
                this.mhTable.put(target, obj);
                continue;
            }
            catch (ClassNotFoundException ex) {
                errorMsg = ex.getMessage();
                continue;
            }
            catch (SecurityException ex) {
                errorMsg = ex.getMessage();
                continue;
            }
            catch (InstantiationException ex) {
                errorMsg = ex.getMessage();
                continue;
            }
            catch (IllegalAccessException ex) {
                errorMsg = ex.getMessage();
                continue;
            }
            catch (IllegalArgumentException ex) {
                errorMsg = ex.getMessage();
            }
        }
        if (!errorMsg.equals("")) {
            throw new CheckoutException(errorMsg);
        }
    }

    private String getNotificationBody(InputStream inputStream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer xml = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            xml.append(line + "\n");
        }
        reader.close();
        return xml.toString();
    }
}

