/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.util;

import com.google.checkout.CheckoutException;
import com.google.checkout.CheckoutSystemException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Utils {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public static Document newEmptyDocument() {
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        try {
            factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new CheckoutSystemException("Could not create new empty document.");
        }
        Document ret = builder.newDocument();
        return ret;
    }

    public static Element findElementOrContainer(Document document, Element parent, String element) {
        NodeList nl = parent.getElementsByTagName(element);
        if (nl.getLength() == 0) {
            return null;
        }
        return (Element)nl.item(0);
    }

    public static Element findContainerElseCreate(Document document, Element parent, String child) {
        NodeList nl = parent.getElementsByTagName(child);
        if (nl.getLength() == 0) {
            parent.appendChild(document.createElement(child));
        }
        return (Element)parent.getElementsByTagName(child).item(0);
    }

    public static Element createNewContainer(Document document, Element parent, String childElement) {
        Element child = document.createElement(childElement);
        parent.appendChild(child);
        return child;
    }

    public static Element findElementElseCreateAndSet(Document document, Element parent, String child, String value) {
        Element ret = null;
        NodeList nl = parent.getElementsByTagName(child);
        if (nl.getLength() == 0) {
            parent.appendChild(document.createElement(child));
            ret = (Element)parent.getElementsByTagName(child).item(0);
            ret.appendChild(document.createTextNode(value));
        }
        return ret;
    }

    public static Element findElementElseCreateAndSet(Document document, Element parent, String child, boolean value) {
        return Utils.findElementElseCreateAndSet(document, parent, child, value + "");
    }

    public static Element findElementAndSetElseCreateAndSet(Document document, Element parent, String child, String value) {
        Element ret;
        NodeList nl = parent.getElementsByTagName(child);
        if (nl.getLength() == 0) {
            parent.appendChild(document.createElement(child));
        }
        if ((ret = (Element)parent.getElementsByTagName(child).item(0)).getFirstChild() != null) {
            ret.removeChild(ret.getFirstChild());
        }
        ret.appendChild(document.createTextNode(value));
        return ret;
    }

    public static Element findElementAndSetElseCreateAndSet(Document document, Element parent, String child, boolean value) {
        return Utils.findElementAndSetElseCreateAndSet(document, parent, child, "" + value);
    }

    public static Element findElementAndSetElseCreateAndSet(Document document, Element parent, String child, float value) {
        return Utils.findElementAndSetElseCreateAndSet(document, parent, child, "" + value);
    }

    public static Element findElementAndSetElseCreateAndSet(Document document, Element parent, String child, int value) {
        return Utils.findElementAndSetElseCreateAndSet(document, parent, child, "" + value);
    }

    public static Element createNewElementAndSet(Document document, Element parent, String childElement, String childValue) {
        Element child = document.createElement(childElement);
        parent.appendChild(child);
        child.setNodeValue(childValue);
        child.appendChild(document.createTextNode(childValue));
        return child;
    }

    public static Element createNewElementAndSetAndAttribute(Document document, Element parent, String childElement, String childValue, String attributeName, String attributeValue) {
        Element child = Utils.createNewElementAndSet(document, parent, childElement, childValue);
        child.setAttribute(attributeName, attributeValue);
        return child;
    }

    public static Element createNewElementAndSet(Document document, Element parent, String childElement, float childValue) {
        return Utils.createNewElementAndSet(document, parent, childElement, "" + childValue);
    }

    public static Element createNewElementAndSet(Document document, Element parent, String childElement, int childValue) {
        return Utils.createNewElementAndSet(document, parent, childElement, "" + childValue);
    }

    public static Element createNewElementAndSet(Document document, Element parent, String childElement, boolean childValue) {
        return Utils.createNewElementAndSet(document, parent, childElement, "" + childValue);
    }

    public static Element createNewElementAndSet(Document document, Element parent, String childElement, double childValue) {
        return Utils.createNewElementAndSet(document, parent, childElement, "" + childValue);
    }

    public static String getElementStringValue(Document document, Element parent, String element) {
        NodeList nl = parent.getElementsByTagName(element);
        if (nl.getLength() == 0) {
            return "";
        }
        Node n = nl.item(0).getFirstChild();
        if (n == null) {
            return "";
        }
        return n.getNodeValue();
    }

    public static boolean getElementBooleanValue(Document document, Element parent, String element) {
        return Boolean.valueOf(Utils.getElementStringValue(document, parent, element));
    }

    public static float getElementFloatValue(Document document, Element parent, String element) {
        return Float.parseFloat(Utils.getElementStringValue(document, parent, element));
    }

    public static void importElements(Document document, Element parent, Element[] children) {
        for (int i = 0; i < children.length; ++i) {
            parent.appendChild(document.importNode(children[i], true));
        }
    }

    public static Date getElementDateValue(Document document, Element parent, String string) throws CheckoutException {
        return Utils.parseDate(Utils.getElementStringValue(document, parent, string));
    }

    public static long getElementLongValue(Document document, Element parent, String string) {
        return Long.parseLong(Utils.getElementStringValue(document, parent, string));
    }

    public static int getElementIntValue(Document document, Element parent, String string) {
        return Integer.parseInt(Utils.getElementStringValue(document, parent, string));
    }

    public static Element findElementAndSetElseCreateAndSet(Document document, Element parent, String element, Date date) {
        return Utils.findElementAndSetElseCreateAndSet(document, parent, element, Utils.getDateString(date));
    }

    public static Element[] getElements(Document document, Element parent) {
        if (parent == null) {
            return new Element[0];
        }
        NodeList nl = parent.getChildNodes();
        ArrayList<Node> al = new ArrayList<Node>();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element)) continue;
            al.add(nl.item(i));
        }
        Element[] ret = new Element[al.size()];
        Iterator it = al.iterator();
        int i = 0;
        while (it.hasNext()) {
            ret[i] = (Element)it.next();
            ++i;
        }
        return ret;
    }

    public static Element findContainerWithAttributeValueElseCreate(Document document, Element parent, String element, String attributeName, String attributeValue) {
        Element e;
        NodeList nl = parent.getElementsByTagName(element);
        for (int i = 0; i < nl.getLength(); ++i) {
            e = (Element)nl.item(i);
            if (!e.getAttribute(attributeName).equals(attributeValue)) continue;
            return e;
        }
        e = document.createElement(element);
        parent.appendChild(e);
        e.setAttribute(attributeName, attributeValue);
        return e;
    }

    public static Element findContainerWithAttributeValueElseCreateAndSet(Document document, Element parent, String element, String value, String attributeName, String attributeValue) {
        Element e = Utils.findContainerWithAttributeValueElseCreate(document, parent, element, attributeName, attributeValue);
        e.appendChild(document.createTextNode(value));
        return e;
    }

    public static Element findElementElseCreateAndAttribute(Document document, Element parent, String element, String attributeName, String attributeValue) {
        NodeList nl = parent.getElementsByTagName(element);
        Element e = null;
        if (nl.getLength() == 0) {
            parent.appendChild(document.createElement(element));
            e = (Element)parent.getElementsByTagName(element).item(0);
            e.setAttribute(attributeName, attributeValue);
        }
        return e;
    }

    public static Element findElementElseCreateAndSetAndAttribute(Document document, Element parent, String element, String value, String attributeName, String attributeValue) {
        Element e = Utils.findElementElseCreateAndAttribute(document, parent, element, attributeName, attributeValue);
        if (e != null) {
            e.appendChild(document.createTextNode(value));
        }
        return e;
    }

    public static String nodeToString(Node node) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer trans = tf.newTransformer();
            StringWriter sw = new StringWriter();
            trans.transform(new DOMSource(node), new StreamResult(sw));
            return sw.toString();
        }
        catch (TransformerException ex) {
            throw new CheckoutSystemException("Unable to convert document to string");
        }
    }

    public static String documentToString(Document document) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer trans = tf.newTransformer();
            StringWriter sw = new StringWriter();
            trans.transform(new DOMSource(document), new StreamResult(sw));
            return sw.toString();
        }
        catch (TransformerException ex) {
            throw new CheckoutSystemException("Unable to convert document to string");
        }
    }

    public static String documentToStringPretty(Document document) {
        try {
            StreamSource stylesource = new StreamSource(Utils.class.getResourceAsStream("indent.xsl"));
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer trans = tf.newTransformer(stylesource);
            StringWriter sw = new StringWriter();
            trans.transform(new DOMSource(document), new StreamResult(sw));
            return sw.toString();
        }
        catch (TransformerException ex) {
            throw new CheckoutSystemException("Unable to convert document to string");
        }
    }

    public static Document newDocumentFromString(String xmlString) throws CheckoutException {
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        Document ret = null;
        try {
            factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new CheckoutSystemException(ex.getMessage());
        }
        try {
            ret = builder.parse(new InputSource(new StringReader(xmlString)));
        }
        catch (SAXException ex) {
            throw new CheckoutException("Got the following error when attempting to create new document from the given xml string. Error message: " + ex.getMessage());
        }
        catch (IOException ex) {
            throw new CheckoutSystemException("Error creating new document from the specified string. Error message: " + ex.getMessage());
        }
        return ret;
    }

    public static Document newDocumentFromInputStream(InputStream in) throws CheckoutException {
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        Document ret = null;
        try {
            factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new CheckoutSystemException(ex.getMessage());
        }
        try {
            ret = builder.parse(new InputSource(in));
        }
        catch (SAXException ex) {
            throw new CheckoutException("Got the following error when attempting to create new document from input stream. Error message: " + ex.getMessage());
        }
        catch (IOException ex) {
            throw new CheckoutSystemException("Error creating new document from the specified input stream. Error message: " + ex.getMessage());
        }
        return ret;
    }

    public static Date parseDate(String date) throws CheckoutException {
        try {
            if (date.endsWith("Z")) {
                date = date.substring(0, date.length() - 1) + "+00:00";
            }
            if (":".equals(date.substring(date.length() - 3, date.length() - 2))) {
                date = date.substring(0, date.length() - 3) + date.substring(date.length() - 2, date.length());
            }
            return sdf.parse(date);
        }
        catch (ParseException ex) {
            throw new CheckoutException("Could not parse date: " + date + ". The expected format is " + sdf.toPattern());
        }
    }

    public static String getDateString(Date date) {
        if (date == null) {
            return "null";
        }
        TimeZone tz = TimeZone.getTimeZone("UTC");
        sdf.setTimeZone(tz);
        String ret = sdf.format(date);
        return ret.substring(0, ret.length() - 5) + "Z";
    }
}

