/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.util;

import com.google.checkout.CheckoutException;
import com.google.checkout.MerchantInfo;
import com.google.checkout.handlers.CheckoutHandlerException;
import com.google.checkout.handlers.MessageHandler;
import com.google.checkout.handlers.NotificationAcknowledgment;
import com.google.checkout.handlers.NotificationHandler;
import com.google.checkout.notification.CheckoutNotification;
import com.google.checkout.notification.CheckoutParserException;
import com.google.checkout.notification.NotificationParser;
import com.google.checkout.util.CheckoutXmlProcessor;
import com.google.checkout.util.CheckoutXmlProcessorException;
import com.google.checkout.util.Utils;
import java.util.HashMap;
import org.w3c.dom.Document;

public class NotificationXmlProcessor
implements CheckoutXmlProcessor {
    private NotificationParser parser;
    private NotificationHandler handler;
    private MerchantInfo merchantInfo;
    private HashMap oldTypeNotificationHandlers;

    public NotificationXmlProcessor(MerchantInfo merchantInfo, NotificationParser parser, NotificationHandler handler, HashMap oldTypeNotificationHandlers) {
        this.merchantInfo = merchantInfo;
        this.parser = parser;
        this.handler = handler;
        this.oldTypeNotificationHandlers = oldTypeNotificationHandlers;
    }

    public Document process(Document xmlDocument) throws CheckoutXmlProcessorException {
        Document resultDocument;
        try {
            CheckoutNotification notification = this.parser.parse(xmlDocument);
            if (this.oldTypeNotificationHandlers != null) {
                MessageHandler oldTypeHandler = (MessageHandler)this.oldTypeNotificationHandlers.get(notification.getType());
                if (oldTypeHandler != null) {
                    oldTypeHandler.process(this.merchantInfo, Utils.documentToString(xmlDocument));
                }
            } else if (this.handler != null) {
                this.handler.handle(this.merchantInfo, notification);
            }
            resultDocument = Utils.newDocumentFromString(NotificationAcknowledgment.getAckString());
        }
        catch (CheckoutHandlerException ex) {
            throw new CheckoutXmlProcessorException(ex);
        }
        catch (CheckoutParserException ex) {
            throw new CheckoutXmlProcessorException(ex);
        }
        catch (CheckoutException ex) {
            throw new CheckoutXmlProcessorException(ex);
        }
        return resultDocument;
    }
}

