/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.util;

import com.google.checkout.CheckoutException;
import com.google.checkout.MerchantInfo;
import com.google.checkout.handlers.CheckoutHandlerException;
import com.google.checkout.handlers.MerchantCallbackHandler;
import com.google.checkout.handlers.MessageHandler;
import com.google.checkout.merchantcalculation.MerchantCalculationCallback;
import com.google.checkout.merchantcalculation.MerchantCalculationResults;
import com.google.checkout.util.CheckoutXmlProcessor;
import com.google.checkout.util.CheckoutXmlProcessorException;
import com.google.checkout.util.Utils;
import java.util.HashMap;
import org.w3c.dom.Document;

public class CallbackXmlProcessor
implements CheckoutXmlProcessor {
    private MerchantCallbackHandler handler;
    private MerchantInfo merchantInfo;
    private HashMap oldTypeCallbackHandlers;

    public CallbackXmlProcessor(MerchantInfo merchantInfo, MerchantCallbackHandler handler, HashMap oldTypeCallbackHandlers) {
        this.merchantInfo = merchantInfo;
        this.handler = handler;
        this.oldTypeCallbackHandlers = oldTypeCallbackHandlers;
    }

    public Document process(Document xmlDocument) throws CheckoutXmlProcessorException {
        Document resultDocument = null;
        try {
            MerchantCalculationCallback callback = new MerchantCalculationCallback(xmlDocument);
            if (this.oldTypeCallbackHandlers != null) {
                MessageHandler oldTypeHandler = (MessageHandler)this.oldTypeCallbackHandlers.get(callback.getType());
                if (oldTypeHandler != null) {
                    oldTypeHandler.process(this.merchantInfo, Utils.documentToString(xmlDocument));
                }
            } else if (this.handler != null) {
                MerchantCalculationResults results = this.handler.handle(this.merchantInfo, callback);
                resultDocument = Utils.newDocumentFromString(results.getXml());
            }
        }
        catch (CheckoutHandlerException ex) {
            throw new CheckoutXmlProcessorException(ex);
        }
        catch (CheckoutException ex) {
            throw new CheckoutXmlProcessorException(ex);
        }
        return resultDocument;
    }
}

