/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.orderprocessing.lineitem;

import com.google.checkout.CheckoutException;
import com.google.checkout.MerchantInfo;
import com.google.checkout.orderprocessing.AbstractOrderProcessingRequest;
import com.google.checkout.orderprocessing.lineitem.TrackingData;
import com.google.checkout.util.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ShipItemsRequest
extends AbstractOrderProcessingRequest {
    public ShipItemsRequest(MerchantInfo merchantInfo) {
        super(merchantInfo, "ship-items");
    }

    public ShipItemsRequest(MerchantInfo merchantInfo, String googleOrderNumber) throws CheckoutException {
        this(merchantInfo);
        this.setGoogleOrderNumber(googleOrderNumber);
    }

    public boolean isSendEmail() {
        return Utils.getElementBooleanValue(this.getDocument(), this.getRoot(), "send-email");
    }

    public void setSendEmail(boolean sendEmail) {
        Utils.findElementAndSetElseCreateAndSet(this.getDocument(), this.getRoot(), "send-email", sendEmail);
    }

    public void addItemShippingInformation(String merchantItemId, String carrier, String trackingNumber) {
        this.addItemShippingInformation(merchantItemId, new TrackingData[]{new TrackingData(carrier, trackingNumber)});
    }

    public void addItemShippingInformation(String merchantItemId, TrackingData[] trackingData) {
        Document document = this.getDocument();
        Element root = this.getRoot();
        Element listTag = Utils.findContainerElseCreate(document, root, "item-shipping-information-list");
        Element itemTag = Utils.createNewContainer(document, listTag, "item-shipping-information");
        Element idTag = Utils.createNewContainer(document, itemTag, "item-id");
        Utils.createNewElementAndSet(document, idTag, "merchant-item-id", merchantItemId);
        Element trackListTag = Utils.createNewContainer(document, itemTag, "tracking-data-list");
        for (int i = 0; i < trackingData.length; ++i) {
            Element trackTag = Utils.createNewContainer(document, trackListTag, "tracking-data");
            Utils.createNewElementAndSet(document, trackTag, "carrier", trackingData[i].getCarrier());
            Utils.createNewElementAndSet(document, trackTag, "tracking-number", trackingData[i].getTrackingNumber());
        }
    }
}

