/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.orderprocessing.lineitem;

import com.google.checkout.MerchantInfo;
import com.google.checkout.orderprocessing.AbstractOrderProcessingRequest;
import com.google.checkout.util.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CancelItemsRequest
extends AbstractOrderProcessingRequest {
    public static final int CANCEL_STRING_LIMIT = 140;
    public static final String CANCEL_ERROR_STRING = "The cancel string limits have been exceeded. The reason and comment cannot exceed 140characters.";

    public CancelItemsRequest(MerchantInfo merchantInfo) {
        super(merchantInfo, "cancel-items");
    }

    public CancelItemsRequest(MerchantInfo merchantInfo, String googleOrderNumber) {
        this(merchantInfo);
        this.setGoogleOrderNumber(googleOrderNumber);
    }

    public CancelItemsRequest(MerchantInfo merchantInfo, String googleOrderNumber, String reason) {
        this(merchantInfo);
        this.setGoogleOrderNumber(googleOrderNumber);
        this.setReason(reason);
    }

    public CancelItemsRequest(MerchantInfo merchantInfo, String googleOrderNo, String reason, String comment) {
        this(merchantInfo);
        this.setGoogleOrderNumber(googleOrderNo);
        this.setReason(reason);
        this.setComment(comment);
    }

    public boolean isSendEmail() {
        return Utils.getElementBooleanValue(this.getDocument(), this.getRoot(), "send-email");
    }

    public void setSendEmail(boolean sendEmail) {
        Utils.findElementAndSetElseCreateAndSet(this.getDocument(), this.getRoot(), "send-email", sendEmail);
    }

    public void addItem(String merchantItemId) {
        Document document = this.getDocument();
        Element root = this.getRoot();
        Element idsTag = Utils.findContainerElseCreate(document, root, "item-ids");
        Element idTag = Utils.createNewContainer(document, idsTag, "item-id");
        Utils.createNewElementAndSet(document, idTag, "merchant-item-id", merchantItemId);
    }

    public String getComment() {
        return Utils.getElementStringValue(this.getDocument(), this.getRoot(), "comment");
    }

    public String getReason() {
        return Utils.getElementStringValue(this.getDocument(), this.getRoot(), "reason");
    }

    public void setComment(String comment) {
        if (!this.isWithinCancelStringLimits("", comment)) {
            comment = comment.substring(0, 140);
        }
        Utils.findElementAndSetElseCreateAndSet(this.getDocument(), this.getRoot(), "comment", comment);
    }

    public void setReason(String reason) {
        if (!this.isWithinCancelStringLimits(reason, "")) {
            reason = reason.substring(0, 140);
        }
        Utils.findElementAndSetElseCreateAndSet(this.getDocument(), this.getRoot(), "reason", reason);
    }

    public boolean isWithinCancelStringLimits(String reason, String comment) {
        if (reason == null || comment == null) {
            throw new IllegalArgumentException(CANCEL_ERROR_STRING);
        }
        return reason.length() <= 140 && comment.length() <= 140;
    }
}

