/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.orderprocessing;

import com.google.checkout.MerchantInfo;
import com.google.checkout.orderprocessing.AbstractOrderProcessingRequest;
import com.google.checkout.util.Utils;

public class SendBuyerMessageRequest
extends AbstractOrderProcessingRequest {
    public static final int MESSAGE_STRING_LIMIT = 255;
    public static final String MESSAGE_ERROR_STRING = "The message string limits have been exceeded. The message cannot exceed 255 characters.";

    public SendBuyerMessageRequest(MerchantInfo merchantInfo) {
        super(merchantInfo, "send-buyer-message");
    }

    public SendBuyerMessageRequest(MerchantInfo merchantInfo, String googleOrderNumber, String message) {
        this(merchantInfo);
        this.setGoogleOrderNumber(googleOrderNumber);
        this.setMessage(message);
    }

    public SendBuyerMessageRequest(MerchantInfo merchantInfo, String googleOrderNumber, String message, boolean sendEmail) {
        this(merchantInfo, googleOrderNumber, message);
        this.setGoogleOrderNumber(googleOrderNumber);
        this.setMessage(message);
        this.setSendEmail(sendEmail);
    }

    public boolean isWithinMessageStringLimits(String message) {
        if (message == null) {
            throw new IllegalArgumentException(MESSAGE_ERROR_STRING);
        }
        return message.length() <= 255;
    }

    public String getMessage() {
        return Utils.getElementStringValue(this.getDocument(), this.getRoot(), "message");
    }

    public boolean isSendEmail() {
        return Utils.getElementBooleanValue(this.getDocument(), this.getRoot(), "send-email");
    }

    public void setMessage(String message) {
        if (!this.isWithinMessageStringLimits(message)) {
            message = message.substring(0, 255);
        }
        Utils.findElementAndSetElseCreateAndSet(this.getDocument(), this.getRoot(), "message", message);
    }

    public void setSendEmail(boolean sendEmail) {
        Utils.findElementAndSetElseCreateAndSet(this.getDocument(), this.getRoot(), "send-email", sendEmail);
    }
}

