/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.orderprocessing;

import com.google.checkout.CheckoutException;
import com.google.checkout.MerchantInfo;
import com.google.checkout.orderprocessing.AbstractOrderProcessingRequest;
import com.google.checkout.util.Utils;
import org.w3c.dom.Element;

public class RefundOrderRequest
extends AbstractOrderProcessingRequest {
    public static final int REFUND_STRING_LIMIT = 140;
    public static final String REFUND_ERROR_STRING = "The refund string limits have been exceeded. The reason and comment cannot exceed 140 characters.";

    public RefundOrderRequest(MerchantInfo merchantInfo) {
        super(merchantInfo, "refund-order");
    }

    public RefundOrderRequest(MerchantInfo merchantInfo, String googleOrderNumber, String reason) {
        this(merchantInfo);
        this.setGoogleOrderNumber(googleOrderNumber);
        this.setReason(reason);
    }

    public RefundOrderRequest(MerchantInfo merchantInfo, String googleOrderNumber, String reason, float amount, String comment) throws CheckoutException {
        this(merchantInfo);
        this.setGoogleOrderNumber(googleOrderNumber);
        this.setReason(reason);
        this.setAmount(amount);
        this.setComment(comment);
    }

    public boolean isWithinRefundStringLimits(String reason, String comment) {
        if (reason == null || comment == null) {
            throw new IllegalArgumentException(REFUND_ERROR_STRING);
        }
        return reason.length() <= 140 && comment.length() <= 140;
    }

    public float getAmount() {
        return Utils.getElementFloatValue(this.getDocument(), this.getRoot(), "amount");
    }

    public String getComment() {
        return Utils.getElementStringValue(this.getDocument(), this.getRoot(), "comment");
    }

    public String getReason() {
        return Utils.getElementStringValue(this.getDocument(), this.getRoot(), "reason");
    }

    public void setAmount(float amount) throws CheckoutException {
        if (amount <= 0.0f) {
            throw new CheckoutException("Refund amount must be greater than 0.");
        }
        Element e = Utils.findElementAndSetElseCreateAndSet(this.getDocument(), this.getRoot(), "amount", amount);
        e.setAttribute("currency", this.merchantInfo.getCurrencyCode());
    }

    public void setComment(String comment) throws CheckoutException {
        if (!this.isWithinRefundStringLimits("", comment)) {
            comment = comment.substring(0, 140);
        }
        Utils.findElementAndSetElseCreateAndSet(this.getDocument(), this.getRoot(), "comment", comment);
    }

    public void setReason(String reason) {
        if (!this.isWithinRefundStringLimits(reason, "")) {
            reason = reason.substring(0, 140);
        }
        Utils.findElementAndSetElseCreateAndSet(this.getDocument(), this.getRoot(), "reason", reason);
    }
}

